/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.CharIndexTranslator;
import ai2.org.apache.poi.hwpf.model.FormattedDiskPage;
import ai2.org.apache.poi.hwpf.model.PAPX;
import ai2.org.apache.poi.hwpf.model.ParagraphHeight;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class PAPFormattedDiskPage
extends FormattedDiskPage {
    private static final int BX_SIZE = 13;
    private static final int FC_SIZE = 4;
    private ArrayList<PAPX> _papxList = new ArrayList();
    private ArrayList<PAPX> _overFlow;

    public PAPFormattedDiskPage(byte[] byArray) {
        this();
    }

    public PAPFormattedDiskPage() {
    }

    public PAPFormattedDiskPage(byte[] byArray, byte[] byArray2, int n, int n2, TextPieceTable textPieceTable) {
        this(byArray, byArray2, n, textPieceTable);
    }

    public PAPFormattedDiskPage(byte[] byArray, byte[] byArray2, int n, CharIndexTranslator charIndexTranslator) {
        super(byArray, n);
        for (int i = 0; i < this._crun; ++i) {
            int n2 = this.getStart(i);
            int n3 = this.getEnd(i);
            for (int[] nArray : charIndexTranslator.getCharIndexRanges(n2, n3)) {
                PAPX pAPX = new PAPX(nArray[0], nArray[1], this.getGrpprl(i), this.getParagraphHeight(i), byArray2);
                this._papxList.add(pAPX);
            }
        }
        this._fkp = null;
    }

    public void fill(List<PAPX> list) {
        this._papxList.addAll(list);
    }

    ArrayList<PAPX> getOverflow() {
        return this._overFlow;
    }

    public PAPX getPAPX(int n) {
        return this._papxList.get(n);
    }

    public List<PAPX> getPAPXs() {
        return Collections.unmodifiableList(this._papxList);
    }

    @Override
    protected byte[] getGrpprl(int n) {
        int n2 = 2 * LittleEndian.getUnsignedByte(this._fkp, this._offset + ((this._crun + 1) * 4 + n * 13));
        int n3 = 2 * LittleEndian.getUnsignedByte(this._fkp, this._offset + n2);
        n3 = n3 == 0 ? 2 * LittleEndian.getUnsignedByte(this._fkp, this._offset + ++n2) : --n3;
        byte[] byArray = new byte[n3];
        System.arraycopy(this._fkp, this._offset + ++n2, byArray, 0, n3);
        return byArray;
    }

    protected byte[] toByteArray(HWPFOutputStream hWPFOutputStream, CharIndexTranslator charIndexTranslator) throws IOException {
        int n;
        Object object;
        int n2;
        byte[] byArray = new byte[512];
        int n3 = this._papxList.size();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Object object2 = new byte[]{};
        int n7 = 4;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this._papxList.get(n2).getGrpprl();
            n = ((byte[])object).length;
            if (n > 488) {
                n = 8;
            }
            int n8 = 0;
            n8 = !Arrays.equals(object, object2) ? 17 + n + 1 : 17;
            if ((n7 += n8) > 511 + n2 % 2) {
                n7 -= n8;
                break;
            }
            n7 = n % 2 > 0 ? ++n7 : (n7 += 2);
            object2 = object;
        }
        if (n2 != n3) {
            this._overFlow = new ArrayList();
            this._overFlow.addAll(this._papxList.subList(n2, n3));
        }
        byArray[511] = (byte)n2;
        n5 = 4 * n2 + 4;
        n4 = 511;
        object = null;
        object2 = new byte[]{};
        for (n = 0; n < n2; ++n) {
            boolean bl;
            int n9;
            object = this._papxList.get(n);
            byte[] byArray2 = object.getParagraphHeight().toByteArray();
            byte[] byArray3 = object.getGrpprl();
            if (byArray3.length > 488) {
                byte[] byArray4 = new byte[byArray3.length - 2];
                System.arraycopy(byArray3, 2, byArray4, 0, byArray3.length - 2);
                n9 = hWPFOutputStream.getOffset();
                hWPFOutputStream.write(byArray4);
                int n10 = LittleEndian.getUShort(byArray3, 0);
                byArray3 = new byte[8];
                LittleEndian.putUShort(byArray3, 0, n10);
                LittleEndian.putUShort(byArray3, 2, 26182);
                LittleEndian.putInt(byArray3, 4, n9);
            }
            if (!(bl = Arrays.equals(object2, byArray3))) {
                n4 -= byArray3.length + (2 - byArray3.length % 2);
                n4 -= n4 % 2;
            }
            LittleEndian.putInt(byArray, n6, charIndexTranslator.getByteIndex(object.getStart()));
            byArray[n5] = (byte)(n4 / 2);
            System.arraycopy(byArray2, 0, byArray, n5 + 1, byArray2.length);
            if (!bl) {
                n9 = n4;
                if (byArray3.length % 2 > 0) {
                    byArray[n9++] = (byte)((byArray3.length + 1) / 2);
                } else {
                    byArray[++n9] = (byte)(byArray3.length / 2);
                    ++n9;
                }
                System.arraycopy(byArray3, 0, byArray, n9, byArray3.length);
                object2 = byArray3;
            }
            n5 += 13;
            n6 += 4;
        }
        LittleEndian.putInt(byArray, n6, charIndexTranslator.getByteIndex(object.getEnd()));
        return byArray;
    }

    private ParagraphHeight getParagraphHeight(int n) {
        int n2 = this._offset + 1 + ((this._crun + 1) * 4 + n * 13);
        ParagraphHeight paragraphHeight = new ParagraphHeight(this._fkp, n2);
        return paragraphHeight;
    }
}

