/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.LFO;
import ai2.org.apache.poi.hwpf.model.LFOData;
import ai2.org.apache.poi.hwpf.model.LSTF;
import ai2.org.apache.poi.hwpf.model.ListData;
import ai2.org.apache.poi.hwpf.model.ListLevel;
import ai2.org.apache.poi.hwpf.model.PlfLfo;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;

@Internal
public final class ListTables {
    private static POILogger log = POILogFactory.getLogger(ListTables.class);
    private final LinkedHashMap<Integer, ListData> _listMap = new LinkedHashMap();
    private PlfLfo _plfLfo;

    public ListTables() {
    }

    public ListTables(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = LittleEndian.getShort(byArray, n4);
        int n6 = (n4 += 2) + n5 * LSTF.getSize();
        for (int i = 0; i < n5; ++i) {
            ListData listData = new ListData(byArray, n4);
            this._listMap.put(listData.getLsid(), listData);
            n4 += LSTF.getSize();
            int n7 = listData.numLevels();
            for (int j = 0; j < n7; ++j) {
                ListLevel listLevel = new ListLevel();
                n6 += listLevel.read(byArray, n6);
                listData.setLevel(j, listLevel);
            }
        }
        this._plfLfo = new PlfLfo(byArray, n2, n3);
    }

    public void writeListDataTo(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        int n = hWPFOutputStream.getOffset();
        fileInformationBlock.setFcPlfLst(n);
        int n2 = this._listMap.size();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2];
        LittleEndian.putShort(byArray, (short)n2);
        hWPFOutputStream.write(byArray);
        for (Integer n3 : this._listMap.keySet()) {
            ListData listData = this._listMap.get(n3);
            hWPFOutputStream.write(listData.toByteArray());
            ListLevel[] listLevelArray = listData.getLevels();
            for (int i = 0; i < listLevelArray.length; ++i) {
                byteArrayOutputStream.write(listLevelArray[i].toByteArray());
            }
        }
        fileInformationBlock.setLcbPlfLst(hWPFOutputStream.getOffset() - n);
        hWPFOutputStream.write(byteArrayOutputStream.toByteArray());
    }

    public void writeListOverridesTo(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        this._plfLfo.writeTo(fileInformationBlock, hWPFOutputStream);
    }

    public LFO getLfo(int n) throws NoSuchElementException {
        return this._plfLfo.getLfo(n);
    }

    public LFOData getLfoData(int n) throws NoSuchElementException {
        return this._plfLfo.getLfoData(n);
    }

    public int getOverrideIndexFromListID(int n) throws NoSuchElementException {
        return this._plfLfo.getIlfoByLsid(n);
    }

    public ListLevel getLevel(int n, int n2) {
        ListData listData = this._listMap.get(n);
        if (n2 < listData.numLevels()) {
            ListLevel listLevel = listData.getLevels()[n2];
            return listLevel;
        }
        if (log.check(5)) {
            log.log(5, new Object[]{"Requested level " + n2 + " which was greater than the maximum defined (" + listData.numLevels() + ")"});
        }
        return null;
    }

    public ListData getListData(int n) {
        return this._listMap.get(n);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._listMap == null ? 0 : this._listMap.hashCode());
        n = 31 * n + (this._plfLfo == null ? 0 : this._plfLfo.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ListTables listTables = (ListTables)object;
        if (this._listMap == null ? listTables._listMap != null : !this._listMap.equals(listTables._listMap)) {
            return false;
        }
        return !(this._plfLfo == null ? listTables._plfLfo != null : !this._plfLfo.equals(listTables._plfLfo));
    }

    public int addList(ListData listData, LFO lFO, LFOData lFOData) {
        int n = listData.getLsid();
        while (this._listMap.get(n) != null) {
            n = listData.resetListID();
            lFO.setLsid(n);
        }
        this._listMap.put(n, listData);
        if (lFO == null && lFOData != null) {
            throw new IllegalArgumentException("LFO and LFOData should be specified both or noone");
        }
        if (lFO != null) {
            this._plfLfo.add(lFO, lFOData);
        }
        return n;
    }
}

