/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.LSTF;
import ai2.org.apache.poi.hwpf.model.ListLevel;
import ai2.org.apache.poi.util.Internal;
import java.util.Arrays;

@Internal
public final class ListData {
    private ListLevel[] _levels;
    private LSTF _lstf;

    ListData(byte[] byArray, int n) {
        this._lstf = new LSTF(byArray, n);
        this._levels = this._lstf.isFSimpleList() ? new ListLevel[1] : new ListLevel[9];
    }

    public ListData(int n, boolean bl) {
        this._lstf = new LSTF();
        this._lstf.setLsid(n);
        this._lstf.setRgistdPara(new short[9]);
        Arrays.fill(this._lstf.getRgistdPara(), (short)4095);
        this._levels = new ListLevel[9];
        for (int i = 0; i < this._levels.length; ++i) {
            this._levels[i] = new ListLevel(i, bl);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ListData listData = (ListData)object;
        if (!Arrays.equals(this._levels, listData._levels)) {
            return false;
        }
        return !(this._lstf == null ? listData._lstf != null : !this._lstf.equals(listData._lstf));
    }

    public ListLevel getLevel(int n) {
        return this._levels[n - 1];
    }

    public ListLevel[] getLevels() {
        return this._levels;
    }

    public int getLevelStyle(int n) {
        return this._lstf.getRgistdPara()[n];
    }

    public int getLsid() {
        return this._lstf.getLsid();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this._levels);
        n = 31 * n + (this._lstf == null ? 0 : this._lstf.hashCode());
        return n;
    }

    public int numLevels() {
        return this._levels.length;
    }

    int resetListID() {
        this._lstf.setLsid((int)(Math.random() * (double)System.currentTimeMillis()));
        return this._lstf.getLsid();
    }

    public void setLevel(int n, ListLevel listLevel) {
        this._levels[n] = listLevel;
    }

    public void setLevelStyle(int n, int n2) {
        this._lstf.getRgistdPara()[n] = (short)n2;
    }

    public byte[] toByteArray() {
        return this._lstf.serialize();
    }
}

