/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;

@Internal
public class LFOData {
    private int _cp;
    private ListFormatOverrideLevel[] _rgLfoLvl;

    public LFOData() {
        this._cp = 0;
        this._rgLfoLvl = new ListFormatOverrideLevel[0];
    }

    LFOData(byte[] byArray, int n, int n2) {
        int n3 = n;
        this._cp = LittleEndian.getInt(byArray, n3);
        n3 += 4;
        this._rgLfoLvl = new ListFormatOverrideLevel[n2];
        for (int i = 0; i < n2; ++i) {
            this._rgLfoLvl[i] = new ListFormatOverrideLevel(byArray, n3);
            n3 += this._rgLfoLvl[i].getSizeInBytes();
        }
    }

    public int getCp() {
        return this._cp;
    }

    public ListFormatOverrideLevel[] getRgLfoLvl() {
        return this._rgLfoLvl;
    }

    public int getSizeInBytes() {
        int n = 0;
        n += 4;
        for (ListFormatOverrideLevel listFormatOverrideLevel : this._rgLfoLvl) {
            n += listFormatOverrideLevel.getSizeInBytes();
        }
        return n;
    }

    void writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        LittleEndian.putInt(this._cp, hWPFOutputStream);
        for (ListFormatOverrideLevel listFormatOverrideLevel : this._rgLfoLvl) {
            hWPFOutputStream.write(listFormatOverrideLevel.toByteArray());
        }
    }
}

