/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.hwpf.model.FIBFieldHandler;
import ai2.org.apache.poi.hwpf.model.FSPADocumentPart;
import ai2.org.apache.poi.hwpf.model.FibBase;
import ai2.org.apache.poi.hwpf.model.FibRgLw;
import ai2.org.apache.poi.hwpf.model.FibRgLw95;
import ai2.org.apache.poi.hwpf.model.FibRgLw97;
import ai2.org.apache.poi.hwpf.model.FibRgW97;
import ai2.org.apache.poi.hwpf.model.FieldsDocumentPart;
import ai2.org.apache.poi.hwpf.model.NoteType;
import ai2.org.apache.poi.hwpf.model.SubdocumentType;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;

@Internal
public final class FileInformationBlock
implements Cloneable {
    public static final POILogger logger = POILogFactory.getLogger(FileInformationBlock.class);
    private FibBase _fibBase;
    private int _csw;
    private FibRgW97 _fibRgW;
    private int _cslw;
    private FibRgLw _fibRgLw;
    private int _cbRgFcLcb;
    private FIBFieldHandler _fieldHandler;
    private int _cswNew;
    private int _nFibNew;
    private byte[] _fibRgCswNew;

    public FileInformationBlock(byte[] byArray) {
        int n = 0;
        this._fibBase = new FibBase(byArray, n);
        n = FibBase.getSize();
        assert (n == 32);
        if (this._fibBase.isFEncrypted()) {
            throw new EncryptedDocumentException("Cannot process encrypted word file");
        }
        this._csw = LittleEndian.getUShort(byArray, n);
        assert ((n += 2) == 34);
        this._fibRgW = new FibRgW97(byArray, n);
        assert ((n += FibRgW97.getSize()) == 62);
        this._cslw = LittleEndian.getUShort(byArray, n);
        assert ((n += 2) == 64);
        if (this._fibBase.getNFib() < 105) {
            this._fibRgLw = new FibRgLw95(byArray, n);
            n += FibRgLw97.getSize();
            this._cbRgFcLcb = 74;
            this._cswNew = LittleEndian.getUShort(byArray, n += this._cbRgFcLcb * 4 * 2);
            n += 2;
            this._cswNew = 0;
            this._nFibNew = -1;
            this._fibRgCswNew = new byte[0];
            return;
        }
        this._fibRgLw = new FibRgLw97(byArray, n);
        assert ((n += FibRgLw97.getSize()) == 152);
        this._cbRgFcLcb = LittleEndian.getUShort(byArray, n);
        assert ((n += 2) == 154);
        this._cswNew = LittleEndian.getUShort(byArray, n += this._cbRgFcLcb * 4 * 2);
        n += 2;
        if (this._cswNew != 0) {
            this._nFibNew = LittleEndian.getUShort(byArray, n);
            int n2 = (this._cswNew - 1) * 2;
            this._fibRgCswNew = new byte[n2];
            LittleEndian.getByteArray(byArray, n += 2, n2);
            n += n2;
        } else {
            this._nFibNew = -1;
            this._fibRgCswNew = new byte[0];
        }
        this.assertCbRgFcLcb();
        this.assertCswNew();
    }

    private void assertCbRgFcLcb() {
        switch (this.getNFib()) {
            case 193: {
                FileInformationBlock.assertCbRgFcLcb("0x00C1", 93, "0x005D", this._cbRgFcLcb);
                break;
            }
            case 217: {
                FileInformationBlock.assertCbRgFcLcb("0x00D9", 108, "0x006C", this._cbRgFcLcb);
                break;
            }
            case 257: {
                FileInformationBlock.assertCbRgFcLcb("0x0101", 136, "0x0088", this._cbRgFcLcb);
                break;
            }
            case 268: {
                FileInformationBlock.assertCbRgFcLcb("0x010C", 164, "0x00A4", this._cbRgFcLcb);
                break;
            }
            case 274: {
                FileInformationBlock.assertCbRgFcLcb("0x0112", 183, "0x00B7", this._cbRgFcLcb);
            }
        }
    }

    private static void assertCbRgFcLcb(String string, int n, String string2, int n2) {
        if (n2 == n) {
            return;
        }
        logger.log(5, "Since FIB.nFib == ", string, " value of FIB.cbRgFcLcb MUST be ", string2 + ", not 0x", Integer.toHexString(n2));
    }

    private void assertCswNew() {
        switch (this.getNFib()) {
            case 193: {
                FileInformationBlock.assertCswNew("0x00C1", 0, "0x0000", this._cswNew);
                break;
            }
            case 217: {
                FileInformationBlock.assertCswNew("0x00D9", 2, "0x0002", this._cswNew);
                break;
            }
            case 257: {
                FileInformationBlock.assertCswNew("0x0101", 2, "0x0002", this._cswNew);
                break;
            }
            case 268: {
                FileInformationBlock.assertCswNew("0x010C", 2, "0x0002", this._cswNew);
                break;
            }
            case 274: {
                FileInformationBlock.assertCswNew("0x0112", 5, "0x0005", this._cswNew);
            }
        }
    }

    private static void assertCswNew(String string, int n, String string2, int n2) {
        if (n2 == n) {
            return;
        }
        logger.log(5, "Since FIB.nFib == ", string, " value of FIB.cswNew MUST be ", string2 + ", not 0x", Integer.toHexString(n2));
    }

    public void fillVariableFields(byte[] byArray, byte[] byArray2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(1);
        hashSet.add(33);
        hashSet.add(31);
        hashSet.add(12);
        hashSet.add(13);
        hashSet.add(6);
        hashSet.add(73);
        hashSet.add(74);
        for (FieldsDocumentPart enum_ : FieldsDocumentPart.values()) {
            hashSet.add(enum_.getFibFieldsField());
        }
        hashSet.add(22);
        hashSet.add(23);
        hashSet.add(21);
        for (Enum enum_ : NoteType.values()) {
            hashSet.add(((NoteType)enum_).getFibDescriptorsFieldIndex());
            hashSet.add(((NoteType)enum_).getFibTextPositionsFieldIndex());
        }
        hashSet.add(15);
        hashSet.add(51);
        hashSet.add(71);
        hashSet.add(87);
        this._fieldHandler = new FIBFieldHandler(byArray, 154, this._cbRgFcLcb, byArray2, hashSet, true);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._fibBase);
        stringBuilder.append("[FIB2]\n");
        stringBuilder.append("\tSubdocuments info:\n");
        for (SubdocumentType object : SubdocumentType.values()) {
            stringBuilder.append("\t\t");
            stringBuilder.append((Object)object);
            stringBuilder.append(" has length of ");
            stringBuilder.append(this.getSubdocumentTextStreamLength(object));
            stringBuilder.append(" char(s)\n");
        }
        stringBuilder.append("\tFields PLCF info:\n");
        for (Enum enum_ : FieldsDocumentPart.values()) {
            stringBuilder.append("\t\t");
            stringBuilder.append(enum_);
            stringBuilder.append(": PLCF starts at ");
            stringBuilder.append(this.getFieldsPlcfOffset((FieldsDocumentPart)enum_));
            stringBuilder.append(" and have length of ");
            stringBuilder.append(this.getFieldsPlcfLength((FieldsDocumentPart)enum_));
            stringBuilder.append("\n");
        }
        stringBuilder.append("\tNotes PLCF info:\n");
        for (Enum enum_ : NoteType.values()) {
            stringBuilder.append("\t\t");
            stringBuilder.append(enum_);
            stringBuilder.append(": descriptions starts ");
            stringBuilder.append(this.getNotesDescriptorsOffset((NoteType)enum_));
            stringBuilder.append(" and have length of ");
            stringBuilder.append(this.getNotesDescriptorsSize((NoteType)enum_));
            stringBuilder.append(" bytes\n");
            stringBuilder.append("\t\t");
            stringBuilder.append(enum_);
            stringBuilder.append(": text positions starts ");
            stringBuilder.append(this.getNotesTextPositionsOffset((NoteType)enum_));
            stringBuilder.append(" and have length of ");
            stringBuilder.append(this.getNotesTextPositionsSize((NoteType)enum_));
            stringBuilder.append(" bytes\n");
        }
        stringBuilder.append(this._fieldHandler);
        try {
            stringBuilder.append("\tJava reflection info:\n");
            for (Method method : FileInformationBlock.class.getMethods()) {
                if (!method.getName().startsWith("get") || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length > 0) continue;
                stringBuilder.append("\t\t");
                stringBuilder.append(method.getName());
                stringBuilder.append(" => ");
                stringBuilder.append(method.invoke((Object)this, new Object[0]));
                stringBuilder.append("\n");
            }
        }
        catch (Exception exception) {
            stringBuilder.append("(exc: " + exception.getMessage() + ")");
        }
        stringBuilder.append("[/FIB2]\n");
        return stringBuilder.toString();
    }

    public int getNFib() {
        if (this._cswNew == 0) {
            return this._fibBase.getNFib();
        }
        return this._nFibNew;
    }

    public int getFcDop() {
        return this._fieldHandler.getFieldOffset(31);
    }

    public void setFcDop(int n) {
        this._fieldHandler.setFieldOffset(31, n);
    }

    public int getLcbDop() {
        return this._fieldHandler.getFieldSize(31);
    }

    public void setLcbDop(int n) {
        this._fieldHandler.setFieldSize(31, n);
    }

    public int getFcStshf() {
        return this._fieldHandler.getFieldOffset(1);
    }

    public int getLcbStshf() {
        return this._fieldHandler.getFieldSize(1);
    }

    public void setFcStshf(int n) {
        this._fieldHandler.setFieldOffset(1, n);
    }

    public void setLcbStshf(int n) {
        this._fieldHandler.setFieldSize(1, n);
    }

    public int getFcClx() {
        return this._fieldHandler.getFieldOffset(33);
    }

    public int getLcbClx() {
        return this._fieldHandler.getFieldSize(33);
    }

    public void setFcClx(int n) {
        this._fieldHandler.setFieldOffset(33, n);
    }

    public void setLcbClx(int n) {
        this._fieldHandler.setFieldSize(33, n);
    }

    public int getFcPlcfbteChpx() {
        return this._fieldHandler.getFieldOffset(12);
    }

    public int getLcbPlcfbteChpx() {
        return this._fieldHandler.getFieldSize(12);
    }

    public void setFcPlcfbteChpx(int n) {
        this._fieldHandler.setFieldOffset(12, n);
    }

    public void setLcbPlcfbteChpx(int n) {
        this._fieldHandler.setFieldSize(12, n);
    }

    public int getFcPlcfbtePapx() {
        return this._fieldHandler.getFieldOffset(13);
    }

    public int getLcbPlcfbtePapx() {
        return this._fieldHandler.getFieldSize(13);
    }

    public void setFcPlcfbtePapx(int n) {
        this._fieldHandler.setFieldOffset(13, n);
    }

    public void setLcbPlcfbtePapx(int n) {
        this._fieldHandler.setFieldSize(13, n);
    }

    public int getFcPlcfsed() {
        return this._fieldHandler.getFieldOffset(6);
    }

    public int getLcbPlcfsed() {
        return this._fieldHandler.getFieldSize(6);
    }

    public void setFcPlcfsed(int n) {
        this._fieldHandler.setFieldOffset(6, n);
    }

    public void setLcbPlcfsed(int n) {
        this._fieldHandler.setFieldSize(6, n);
    }

    @Deprecated
    public int getFcPlcfLst() {
        return this._fieldHandler.getFieldOffset(73);
    }

    public int getFcPlfLst() {
        return this._fieldHandler.getFieldOffset(73);
    }

    @Deprecated
    public int getLcbPlcfLst() {
        return this._fieldHandler.getFieldSize(73);
    }

    public int getLcbPlfLst() {
        return this._fieldHandler.getFieldSize(73);
    }

    @Deprecated
    public void setFcPlcfLst(int n) {
        this._fieldHandler.setFieldOffset(73, n);
    }

    public void setFcPlfLst(int n) {
        this._fieldHandler.setFieldOffset(73, n);
    }

    @Deprecated
    public void setLcbPlcfLst(int n) {
        this._fieldHandler.setFieldSize(73, n);
    }

    public void setLcbPlfLst(int n) {
        this._fieldHandler.setFieldSize(73, n);
    }

    public int getFcPlfLfo() {
        return this._fieldHandler.getFieldOffset(74);
    }

    public int getLcbPlfLfo() {
        return this._fieldHandler.getFieldSize(74);
    }

    public int getFcSttbfbkmk() {
        return this._fieldHandler.getFieldOffset(21);
    }

    public void setFcSttbfbkmk(int n) {
        this._fieldHandler.setFieldOffset(21, n);
    }

    public int getLcbSttbfbkmk() {
        return this._fieldHandler.getFieldSize(21);
    }

    public void setLcbSttbfbkmk(int n) {
        this._fieldHandler.setFieldSize(21, n);
    }

    public int getFcPlcfbkf() {
        return this._fieldHandler.getFieldOffset(22);
    }

    public void setFcPlcfbkf(int n) {
        this._fieldHandler.setFieldOffset(22, n);
    }

    public int getLcbPlcfbkf() {
        return this._fieldHandler.getFieldSize(22);
    }

    public void setLcbPlcfbkf(int n) {
        this._fieldHandler.setFieldSize(22, n);
    }

    public int getFcPlcfbkl() {
        return this._fieldHandler.getFieldOffset(23);
    }

    public void setFcPlcfbkl(int n) {
        this._fieldHandler.setFieldOffset(23, n);
    }

    public int getLcbPlcfbkl() {
        return this._fieldHandler.getFieldSize(23);
    }

    public void setLcbPlcfbkl(int n) {
        this._fieldHandler.setFieldSize(23, n);
    }

    public void setFcPlfLfo(int n) {
        this._fieldHandler.setFieldOffset(74, n);
    }

    public void setLcbPlfLfo(int n) {
        this._fieldHandler.setFieldSize(74, n);
    }

    public int getFcSttbfffn() {
        return this._fieldHandler.getFieldOffset(15);
    }

    public int getLcbSttbfffn() {
        return this._fieldHandler.getFieldSize(15);
    }

    public void setFcSttbfffn(int n) {
        this._fieldHandler.setFieldOffset(15, n);
    }

    public void setLcbSttbfffn(int n) {
        this._fieldHandler.setFieldSize(15, n);
    }

    public int getFcSttbfRMark() {
        return this._fieldHandler.getFieldOffset(51);
    }

    public int getLcbSttbfRMark() {
        return this._fieldHandler.getFieldSize(51);
    }

    public void setFcSttbfRMark(int n) {
        this._fieldHandler.setFieldOffset(51, n);
    }

    public void setLcbSttbfRMark(int n) {
        this._fieldHandler.setFieldSize(51, n);
    }

    public int getPlcfHddOffset() {
        return this._fieldHandler.getFieldOffset(11);
    }

    public int getPlcfHddSize() {
        return this._fieldHandler.getFieldSize(11);
    }

    public void setPlcfHddOffset(int n) {
        this._fieldHandler.setFieldOffset(11, n);
    }

    public void setPlcfHddSize(int n) {
        this._fieldHandler.setFieldSize(11, n);
    }

    public int getFcSttbSavedBy() {
        return this._fieldHandler.getFieldOffset(71);
    }

    public int getLcbSttbSavedBy() {
        return this._fieldHandler.getFieldSize(71);
    }

    public void setFcSttbSavedBy(int n) {
        this._fieldHandler.setFieldOffset(71, n);
    }

    public void setLcbSttbSavedBy(int n) {
        this._fieldHandler.setFieldSize(71, n);
    }

    public int getModifiedLow() {
        return this._fieldHandler.getFieldOffset(74);
    }

    public int getModifiedHigh() {
        return this._fieldHandler.getFieldSize(74);
    }

    public void setModifiedLow(int n) {
        this._fieldHandler.setFieldOffset(74, n);
    }

    public void setModifiedHigh(int n) {
        this._fieldHandler.setFieldSize(74, n);
    }

    public int getCbMac() {
        return this._fibRgLw.getCbMac();
    }

    public void setCbMac(int n) {
        this._fibRgLw.setCbMac(n);
    }

    public int getSubdocumentTextStreamLength(SubdocumentType subdocumentType) {
        if (subdocumentType == null) {
            throw new IllegalArgumentException("argument 'type' is null");
        }
        return this._fibRgLw.getSubdocumentTextStreamLength(subdocumentType);
    }

    public void setSubdocumentTextStreamLength(SubdocumentType subdocumentType, int n) {
        if (subdocumentType == null) {
            throw new IllegalArgumentException("argument 'type' is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Subdocument length can't be less than 0 (passed value is " + n + "). " + "If there is no subdocument " + "length must be set to zero.");
        }
        this._fibRgLw.setSubdocumentTextStreamLength(subdocumentType, n);
    }

    public void clearOffsetsSizes() {
        this._fieldHandler.clearFields();
    }

    public int getFieldsPlcfOffset(FieldsDocumentPart fieldsDocumentPart) {
        return this._fieldHandler.getFieldOffset(fieldsDocumentPart.getFibFieldsField());
    }

    public int getFieldsPlcfLength(FieldsDocumentPart fieldsDocumentPart) {
        return this._fieldHandler.getFieldSize(fieldsDocumentPart.getFibFieldsField());
    }

    public void setFieldsPlcfOffset(FieldsDocumentPart fieldsDocumentPart, int n) {
        this._fieldHandler.setFieldOffset(fieldsDocumentPart.getFibFieldsField(), n);
    }

    public void setFieldsPlcfLength(FieldsDocumentPart fieldsDocumentPart, int n) {
        this._fieldHandler.setFieldSize(fieldsDocumentPart.getFibFieldsField(), n);
    }

    @Deprecated
    public int getFcPlcffldAtn() {
        return this._fieldHandler.getFieldOffset(19);
    }

    @Deprecated
    public int getLcbPlcffldAtn() {
        return this._fieldHandler.getFieldSize(19);
    }

    @Deprecated
    public void setFcPlcffldAtn(int n) {
        this._fieldHandler.setFieldOffset(19, n);
    }

    @Deprecated
    public void setLcbPlcffldAtn(int n) {
        this._fieldHandler.setFieldSize(19, n);
    }

    @Deprecated
    public int getFcPlcffldEdn() {
        return this._fieldHandler.getFieldOffset(48);
    }

    @Deprecated
    public int getLcbPlcffldEdn() {
        return this._fieldHandler.getFieldSize(48);
    }

    @Deprecated
    public void setFcPlcffldEdn(int n) {
        this._fieldHandler.setFieldOffset(48, n);
    }

    @Deprecated
    public void setLcbPlcffldEdn(int n) {
        this._fieldHandler.setFieldSize(48, n);
    }

    @Deprecated
    public int getFcPlcffldFtn() {
        return this._fieldHandler.getFieldOffset(18);
    }

    @Deprecated
    public int getLcbPlcffldFtn() {
        return this._fieldHandler.getFieldSize(18);
    }

    @Deprecated
    public void setFcPlcffldFtn(int n) {
        this._fieldHandler.setFieldOffset(18, n);
    }

    @Deprecated
    public void setLcbPlcffldFtn(int n) {
        this._fieldHandler.setFieldSize(18, n);
    }

    @Deprecated
    public int getFcPlcffldHdr() {
        return this._fieldHandler.getFieldOffset(17);
    }

    @Deprecated
    public int getLcbPlcffldHdr() {
        return this._fieldHandler.getFieldSize(17);
    }

    @Deprecated
    public void setFcPlcffldHdr(int n) {
        this._fieldHandler.setFieldOffset(17, n);
    }

    @Deprecated
    public void setLcbPlcffldHdr(int n) {
        this._fieldHandler.setFieldSize(17, n);
    }

    @Deprecated
    public int getFcPlcffldHdrtxbx() {
        return this._fieldHandler.getFieldOffset(59);
    }

    @Deprecated
    public int getLcbPlcffldHdrtxbx() {
        return this._fieldHandler.getFieldSize(59);
    }

    @Deprecated
    public void setFcPlcffldHdrtxbx(int n) {
        this._fieldHandler.setFieldOffset(59, n);
    }

    @Deprecated
    public void setLcbPlcffldHdrtxbx(int n) {
        this._fieldHandler.setFieldSize(59, n);
    }

    @Deprecated
    public int getFcPlcffldMom() {
        return this._fieldHandler.getFieldOffset(16);
    }

    @Deprecated
    public int getLcbPlcffldMom() {
        return this._fieldHandler.getFieldSize(16);
    }

    @Deprecated
    public void setFcPlcffldMom(int n) {
        this._fieldHandler.setFieldOffset(16, n);
    }

    @Deprecated
    public void setLcbPlcffldMom(int n) {
        this._fieldHandler.setFieldSize(16, n);
    }

    @Deprecated
    public int getFcPlcffldTxbx() {
        return this._fieldHandler.getFieldOffset(57);
    }

    @Deprecated
    public int getLcbPlcffldTxbx() {
        return this._fieldHandler.getFieldSize(57);
    }

    @Deprecated
    public void setFcPlcffldTxbx(int n) {
        this._fieldHandler.setFieldOffset(57, n);
    }

    @Deprecated
    public void setLcbPlcffldTxbx(int n) {
        this._fieldHandler.setFieldSize(57, n);
    }

    public int getFSPAPlcfOffset(FSPADocumentPart fSPADocumentPart) {
        return this._fieldHandler.getFieldOffset(fSPADocumentPart.getFibFieldsField());
    }

    public int getFSPAPlcfLength(FSPADocumentPart fSPADocumentPart) {
        return this._fieldHandler.getFieldSize(fSPADocumentPart.getFibFieldsField());
    }

    public void setFSPAPlcfOffset(FSPADocumentPart fSPADocumentPart, int n) {
        this._fieldHandler.setFieldOffset(fSPADocumentPart.getFibFieldsField(), n);
    }

    public void setFSPAPlcfLength(FSPADocumentPart fSPADocumentPart, int n) {
        this._fieldHandler.setFieldSize(fSPADocumentPart.getFibFieldsField(), n);
    }

    @Deprecated
    public int getFcPlcspaMom() {
        return this._fieldHandler.getFieldOffset(40);
    }

    @Deprecated
    public int getLcbPlcspaMom() {
        return this._fieldHandler.getFieldSize(40);
    }

    public int getFcDggInfo() {
        return this._fieldHandler.getFieldOffset(50);
    }

    public int getLcbDggInfo() {
        return this._fieldHandler.getFieldSize(50);
    }

    public int getNotesDescriptorsOffset(NoteType noteType) {
        return this._fieldHandler.getFieldOffset(noteType.getFibDescriptorsFieldIndex());
    }

    public void setNotesDescriptorsOffset(NoteType noteType, int n) {
        this._fieldHandler.setFieldOffset(noteType.getFibDescriptorsFieldIndex(), n);
    }

    public int getNotesDescriptorsSize(NoteType noteType) {
        return this._fieldHandler.getFieldSize(noteType.getFibDescriptorsFieldIndex());
    }

    public void setNotesDescriptorsSize(NoteType noteType, int n) {
        this._fieldHandler.setFieldSize(noteType.getFibDescriptorsFieldIndex(), n);
    }

    public int getNotesTextPositionsOffset(NoteType noteType) {
        return this._fieldHandler.getFieldOffset(noteType.getFibTextPositionsFieldIndex());
    }

    public void setNotesTextPositionsOffset(NoteType noteType, int n) {
        this._fieldHandler.setFieldOffset(noteType.getFibTextPositionsFieldIndex(), n);
    }

    public int getNotesTextPositionsSize(NoteType noteType) {
        return this._fieldHandler.getFieldSize(noteType.getFibTextPositionsFieldIndex());
    }

    public void setNotesTextPositionsSize(NoteType noteType, int n) {
        this._fieldHandler.setFieldSize(noteType.getFibTextPositionsFieldIndex(), n);
    }

    public void writeTo(byte[] byArray, HWPFOutputStream hWPFOutputStream) throws IOException {
        this._cbRgFcLcb = this._fieldHandler.getFieldsCount();
        this._fibBase.serialize(byArray, 0);
        int n = FibBase.getSize();
        LittleEndian.putUShort(byArray, n, this._csw);
        this._fibRgW.serialize(byArray, n += 2);
        LittleEndian.putUShort(byArray, n += FibRgW97.getSize(), this._cslw);
        ((FibRgLw97)this._fibRgLw).serialize(byArray, n += 2);
        LittleEndian.putUShort(byArray, n += FibRgLw97.getSize(), this._cbRgFcLcb);
        this._fieldHandler.writeTo(byArray, n += 2, hWPFOutputStream);
        LittleEndian.putUShort(byArray, n += this._cbRgFcLcb * 4 * 2, this._cswNew);
        n += 2;
        if (this._cswNew != 0) {
            LittleEndian.putUShort(byArray, n, this._nFibNew);
            System.arraycopy(this._fibRgCswNew, 0, byArray, n += 2, this._fibRgCswNew.length);
            n += this._fibRgCswNew.length;
        }
    }

    public int getSize() {
        return FibBase.getSize() + 2 + FibRgW97.getSize() + 2 + FibRgLw97.getSize() + 2 + this._fieldHandler.sizeInBytes();
    }

    public FibBase getFibBase() {
        return this._fibBase;
    }
}

