/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.FSPA;
import ai2.org.apache.poi.hwpf.model.FSPADocumentPart;
import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.TextPiece;
import ai2.org.apache.poi.util.Internal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class FSPATable {
    private final Map<Integer, GenericPropertyNode> _byStart = new LinkedHashMap<Integer, GenericPropertyNode>();

    public FSPATable(byte[] byArray, FileInformationBlock fileInformationBlock, FSPADocumentPart fSPADocumentPart) {
        int n = fileInformationBlock.getFSPAPlcfOffset(fSPADocumentPart);
        int n2 = fileInformationBlock.getFSPAPlcfLength(fSPADocumentPart);
        PlexOfCps plexOfCps = new PlexOfCps(byArray, n, n2, FSPA.getSize());
        for (int i = 0; i < plexOfCps.length(); ++i) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(i);
            this._byStart.put(genericPropertyNode.getStart(), genericPropertyNode);
        }
    }

    @Deprecated
    public FSPATable(byte[] byArray, int n, int n2, List<TextPiece> list) {
        if (n == 0) {
            return;
        }
        PlexOfCps plexOfCps = new PlexOfCps(byArray, n, n2, FSPA.FSPA_SIZE);
        for (int i = 0; i < plexOfCps.length(); ++i) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(i);
            this._byStart.put(genericPropertyNode.getStart(), genericPropertyNode);
        }
    }

    public FSPA getFspaFromCp(int n) {
        GenericPropertyNode genericPropertyNode = this._byStart.get(n);
        if (genericPropertyNode == null) {
            return null;
        }
        return new FSPA(genericPropertyNode.getBytes(), 0);
    }

    public FSPA[] getShapes() {
        ArrayList<FSPA> arrayList = new ArrayList<FSPA>(this._byStart.size());
        for (GenericPropertyNode genericPropertyNode : this._byStart.values()) {
            arrayList.add(new FSPA(genericPropertyNode.getBytes(), 0));
        }
        return arrayList.toArray(new FSPA[arrayList.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FPSA PLC size=").append(this._byStart.size()).append("]\n");
        for (Map.Entry<Integer, GenericPropertyNode> entry : this._byStart.entrySet()) {
            Integer n = entry.getKey();
            stringBuffer.append("  ").append(n.toString()).append(" => \t");
            try {
                FSPA fSPA = this.getFspaFromCp(n);
                stringBuffer.append(fSPA.toString());
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("[/FSPA PLC]");
        return stringBuffer.toString();
    }
}

