/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.CHPFormattedDiskPage;
import ai2.org.apache.poi.hwpf.model.CHPX;
import ai2.org.apache.poi.hwpf.model.CharIndexTranslator;
import ai2.org.apache.poi.hwpf.model.ComplexFileTable;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.PropertyModifier;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.hwpf.model.TextPiece;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.model.io.HWPFFileSystem;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.sprm.SprmIterator;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class CHPBinTable {
    private static final POILogger logger = POILogFactory.getLogger(CHPBinTable.class);
    protected List<CHPX> _textRuns = new ArrayList<CHPX>();

    public CHPBinTable() {
    }

    public CHPBinTable(byte[] byArray, byte[] byArray2, int n, int n2, int n3, TextPieceTable textPieceTable) {
        this(byArray, byArray2, n, n2, textPieceTable);
    }

    public CHPBinTable(byte[] byArray, byte[] byArray2, int n, int n2, CharIndexTranslator charIndexTranslator) {
        long l = System.currentTimeMillis();
        PlexOfCps plexOfCps = new PlexOfCps(byArray2, n, n2, 4);
        int n3 = plexOfCps.length();
        for (int i = 0; i < n3; ++i) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(i);
            int n4 = LittleEndian.getInt(genericPropertyNode.getBytes());
            int n5 = 512 * n4;
            CHPFormattedDiskPage cHPFormattedDiskPage = new CHPFormattedDiskPage(byArray, n5, charIndexTranslator);
            for (CHPX cHPX : cHPFormattedDiskPage.getCHPXs()) {
                if (cHPX == null) continue;
                this._textRuns.add(cHPX);
            }
        }
        logger.log(1, "CHPX FKPs loaded in ", System.currentTimeMillis() - l, " ms (", this._textRuns.size(), " elements)");
        if (this._textRuns.isEmpty()) {
            logger.log(5, new Object[]{"CHPX FKPs are empty"});
            this._textRuns.add(new CHPX(0, 0, new SprmBuffer(0)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rebuild(ComplexFileTable complexFileTable) {
        Iterator<CHPX> iterator2;
        Cloneable cloneable;
        Object object2;
        long l = System.currentTimeMillis();
        if (complexFileTable != null) {
            object2 = complexFileTable.getGrpprls();
            for (TextPiece textPiece : complexFileTable.getTextPieceTable().getTextPieces()) {
                Object object;
                cloneable = textPiece.getPieceDescriptor().getPrm();
                if (!((PropertyModifier)cloneable).isComplex()) continue;
                short s = ((PropertyModifier)cloneable).getIgrpprl();
                if (s < 0 || s >= ((SprmBuffer[])object2).length) {
                    logger.log(5, new Object[]{textPiece + "'s PRM references to unknown grpprl"});
                    continue;
                }
                boolean bl = false;
                SprmBuffer object4 = object2[s];
                iterator2 = object4.iterator();
                while (((SprmIterator)((Object)iterator2)).hasNext()) {
                    object = ((SprmIterator)((Object)iterator2)).next();
                    if (((SprmOperation)object).getType() != 2) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                try {
                    iterator2 = (SprmBuffer)object4.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new Error(cloneNotSupportedException);
                }
                object = new CHPX(textPiece.getStart(), textPiece.getEnd(), (SprmBuffer)((Object)iterator2));
                this._textRuns.add((CHPX)object);
            }
            logger.log(1, "Merged with CHPX from complex file table in ", System.currentTimeMillis() - l, " ms (", this._textRuns.size(), " elements in total)");
            l = System.currentTimeMillis();
        }
        object2 = new ArrayList<CHPX>(this._textRuns);
        Collections.sort(object2, PropertyNode.StartComparator.instance);
        logger.log(1, "CHPX sorted by start position in ", System.currentTimeMillis() - l, " ms");
        l = System.currentTimeMillis();
        final IdentityHashMap identityHashMap = new IdentityHashMap();
        int n = 0;
        for (CHPX cHPX : this._textRuns) {
            identityHashMap.put(cHPX, n++);
        }
        Comparator<CHPX> comparator = new Comparator<CHPX>(){

            @Override
            public int compare(CHPX cHPX, CHPX cHPX2) {
                Integer n = (Integer)identityHashMap.get(cHPX);
                Integer n2 = (Integer)identityHashMap.get(cHPX2);
                return n.compareTo(n2);
            }
        };
        logger.log(1, "CHPX's order map created in ", System.currentTimeMillis() - l, " ms");
        l = System.currentTimeMillis();
        AbstractCollection abstractCollection = new HashSet<Integer>();
        for (CHPX cHPX : this._textRuns) {
            abstractCollection.add(cHPX.getStart());
            abstractCollection.add(cHPX.getEnd());
        }
        abstractCollection.remove(0);
        cloneable = new ArrayList(abstractCollection);
        Collections.sort(cloneable);
        logger.log(1, "Texts CHPX boundaries collected in ", System.currentTimeMillis() - l, " ms");
        l = System.currentTimeMillis();
        abstractCollection = new LinkedList();
        int n2 = 0;
        for (Iterator<CHPX> iterator2 : cloneable) {
            Cloneable cloneable2;
            Object object;
            int n3;
            int n4 = (Integer)((Object)iterator2);
            int n5 = n2;
            n2 = n3 = n4;
            int n6 = CHPBinTable.binarySearch((List<CHPX>)object2, n4);
            for (n6 = Math.abs(n6); n6 >= object2.size(); --n6) {
            }
            while (n6 > 0 && ((CHPX)object2.get(n6)).getStart() >= n4) {
                --n6;
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (int i = n6; i < object2.size() && n4 >= ((PropertyNode)(object = (CHPX)object2.get(i))).getStart(); ++i) {
                int n7;
                int n8 = Math.max(n5, ((PropertyNode)object).getStart());
                if (n8 >= (n7 = Math.min(n3, ((PropertyNode)object).getEnd()))) continue;
                linkedList.add(object);
            }
            if (linkedList.size() == 0) {
                logger.log(5, "Text piece [", n5, "; ", n3, ") has no CHPX. Creating new one.");
                cloneable2 = new CHPX(n5, n3, new SprmBuffer(0));
                abstractCollection.add(cloneable2);
                continue;
            }
            if (linkedList.size() == 1 && ((PropertyNode)(cloneable2 = (CHPX)linkedList.get(0))).getStart() == n5 && ((PropertyNode)cloneable2).getEnd() == n3) {
                abstractCollection.add((Cloneable)cloneable2);
                continue;
            }
            Collections.sort(linkedList, comparator);
            cloneable2 = new SprmBuffer(0);
            for (CHPX cHPX : linkedList) {
                ((SprmBuffer)cloneable2).append(cHPX.getGrpprl(), 0);
            }
            object = new CHPX(n5, n3, (SprmBuffer)cloneable2);
            abstractCollection.add(object);
        }
        this._textRuns = new ArrayList<CHPX>(abstractCollection);
        logger.log(1, "CHPX rebuilded in ", System.currentTimeMillis() - l, " ms (", this._textRuns.size(), " elements)");
        l = System.currentTimeMillis();
        Object var10_19 = null;
        iterator2 = this._textRuns.iterator();
        while (iterator2.hasNext()) {
            void var10_20;
            CHPX cHPX = iterator2.next();
            if (var10_20 == null) {
                CHPX cHPX2 = cHPX;
                continue;
            }
            if (var10_20.getEnd() == cHPX.getStart() && Arrays.equals(var10_20.getGrpprl(), cHPX.getGrpprl())) {
                var10_20.setEnd(cHPX.getEnd());
                iterator2.remove();
                continue;
            }
            CHPX cHPX3 = cHPX;
        }
        logger.log(1, "CHPX compacted in ", System.currentTimeMillis() - l, " ms (", this._textRuns.size(), " elements)");
    }

    private static int binarySearch(List<CHPX> list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            CHPX cHPX = list.get(n4);
            int n5 = cHPX.getStart();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public void adjustForDelete(int n, int n2, int n3) {
        int n4;
        int n5 = this._textRuns.size();
        int n6 = n2 + n3;
        int n7 = n;
        CHPX cHPX = this._textRuns.get(n7);
        while (cHPX.getEnd() < n6) {
            cHPX = this._textRuns.get(++n7);
        }
        if (n == n7) {
            cHPX = this._textRuns.get(n7);
            cHPX.setEnd(cHPX.getEnd() - n6 + n2);
        } else {
            cHPX = this._textRuns.get(n);
            cHPX.setEnd(n2);
            for (n4 = n + 1; n4 < n7; ++n4) {
                cHPX = this._textRuns.get(n4);
                cHPX.setStart(n2);
                cHPX.setEnd(n2);
            }
            cHPX = this._textRuns.get(n7);
            cHPX.setEnd(cHPX.getEnd() - n6 + n2);
        }
        for (n4 = n7 + 1; n4 < n5; ++n4) {
            cHPX = this._textRuns.get(n4);
            cHPX.setStart(cHPX.getStart() - n3);
            cHPX.setEnd(cHPX.getEnd() - n3);
        }
    }

    public void insert(int n, int n2, SprmBuffer sprmBuffer) {
        CHPX cHPX = new CHPX(0, 0, sprmBuffer);
        cHPX.setStart(n2);
        cHPX.setEnd(n2);
        if (n == this._textRuns.size()) {
            this._textRuns.add(cHPX);
        } else {
            CHPX cHPX2 = this._textRuns.get(n);
            if (cHPX2.getStart() < n2) {
                CHPX cHPX3 = new CHPX(0, 0, cHPX2.getSprmBuf());
                cHPX3.setStart(n2);
                cHPX3.setEnd(cHPX2.getEnd());
                cHPX2.setEnd(n2);
                this._textRuns.add(n + 1, cHPX);
                this._textRuns.add(n + 2, cHPX3);
            } else {
                this._textRuns.add(n, cHPX);
            }
        }
    }

    public void adjustForInsert(int n, int n2) {
        int n3 = this._textRuns.size();
        CHPX cHPX = this._textRuns.get(n);
        cHPX.setEnd(cHPX.getEnd() + n2);
        for (int i = n + 1; i < n3; ++i) {
            cHPX = this._textRuns.get(i);
            cHPX.setStart(cHPX.getStart() + n2);
            cHPX.setEnd(cHPX.getEnd() + n2);
        }
    }

    public List<CHPX> getTextRuns() {
        return this._textRuns;
    }

    @Deprecated
    public void writeTo(HWPFFileSystem hWPFFileSystem, int n, CharIndexTranslator charIndexTranslator) throws IOException {
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("WordDocument");
        HWPFOutputStream hWPFOutputStream2 = hWPFFileSystem.getStream("1Table");
        this.writeTo(hWPFOutputStream, hWPFOutputStream2, n, charIndexTranslator);
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream, HWPFOutputStream hWPFOutputStream2, int n, CharIndexTranslator charIndexTranslator) throws IOException {
        PlexOfCps plexOfCps = new PlexOfCps(4);
        int n2 = hWPFOutputStream.getOffset();
        int n3 = n2 % 512;
        if (n3 != 0) {
            byte[] byArray = new byte[512 - n3];
            hWPFOutputStream.write(byArray);
        }
        n2 = hWPFOutputStream.getOffset();
        int n4 = n2 / 512;
        int n5 = charIndexTranslator.getByteIndex(this._textRuns.get(this._textRuns.size() - 1).getEnd());
        List<CHPX> list = this._textRuns;
        do {
            CHPX cHPX = list.get(0);
            int n6 = charIndexTranslator.getByteIndex(cHPX.getStart());
            CHPFormattedDiskPage cHPFormattedDiskPage = new CHPFormattedDiskPage();
            cHPFormattedDiskPage.fill(list);
            byte[] byArray = cHPFormattedDiskPage.toByteArray(charIndexTranslator);
            hWPFOutputStream.write(byArray);
            list = cHPFormattedDiskPage.getOverflow();
            int n7 = n5;
            if (list != null) {
                n7 = charIndexTranslator.getByteIndex(list.get(0).getStart());
            }
            byte[] byArray2 = new byte[4];
            LittleEndian.putInt(byArray2, n4++);
            plexOfCps.addProperty(new GenericPropertyNode(n6, n7, byArray2));
        } while (list != null);
        hWPFOutputStream2.write(plexOfCps.toByteArray());
    }
}

