/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hwpf.converter.AbstractWordUtils;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableRow;
import org.w3c.dom.Element;

public class WordToHtmlUtils
extends AbstractWordUtils {
    public static void addBold(boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append("font-weight:" + (bl ? "bold" : "normal") + ";");
    }

    public static void addBorder(BorderCode borderCode, String string, StringBuilder stringBuilder) {
        if (borderCode == null || borderCode.isEmpty()) {
            return;
        }
        if (WordToHtmlUtils.isEmpty(string)) {
            stringBuilder.append("border:");
        } else {
            stringBuilder.append("border-");
            stringBuilder.append(string);
        }
        stringBuilder.append(":");
        if (borderCode.getLineWidth() < 8) {
            stringBuilder.append("thin");
        } else {
            stringBuilder.append(WordToHtmlUtils.getBorderWidth(borderCode));
        }
        stringBuilder.append(' ');
        stringBuilder.append(WordToHtmlUtils.getBorderType(borderCode));
        stringBuilder.append(' ');
        stringBuilder.append(WordToHtmlUtils.getColor(borderCode.getColor()));
        stringBuilder.append(';');
    }

    public static void addCharactersProperties(CharacterRun characterRun, StringBuilder stringBuilder) {
        WordToHtmlUtils.addBorder(characterRun.getBorder(), "", stringBuilder);
        if (characterRun.isCapitalized()) {
            stringBuilder.append("text-transform:uppercase;");
        }
        if (characterRun.getIco24() != -1) {
            stringBuilder.append("color:" + WordToHtmlUtils.getColor24(characterRun.getIco24()) + ";");
        }
        if (characterRun.isHighlighted()) {
            stringBuilder.append("background-color:" + WordToHtmlUtils.getColor(characterRun.getHighlightedColor()) + ";");
        }
        if (characterRun.isStrikeThrough()) {
            stringBuilder.append("text-decoration:line-through;");
        }
        if (characterRun.isShadowed()) {
            stringBuilder.append("text-shadow:" + characterRun.getFontSize() / 24 + "pt;");
        }
        if (characterRun.isSmallCaps()) {
            stringBuilder.append("font-variant:small-caps;");
        }
        if (characterRun.getSubSuperScriptIndex() == 1) {
            stringBuilder.append("vertical-align:super;");
            stringBuilder.append("font-size:smaller;");
        }
        if (characterRun.getSubSuperScriptIndex() == 2) {
            stringBuilder.append("vertical-align:sub;");
            stringBuilder.append("font-size:smaller;");
        }
        if (characterRun.getUnderlineCode() > 0) {
            stringBuilder.append("text-decoration:underline;");
        }
        if (characterRun.isVanished()) {
            stringBuilder.append("visibility:hidden;");
        }
    }

    public static void addFontFamily(String string, StringBuilder stringBuilder) {
        if (WordToHtmlUtils.isEmpty(string)) {
            return;
        }
        stringBuilder.append("font-family:" + string + ";");
    }

    public static void addFontSize(int n, StringBuilder stringBuilder) {
        stringBuilder.append("font-size:" + n + "pt;");
    }

    public static void addIndent(Paragraph paragraph, StringBuilder stringBuilder) {
        WordToHtmlUtils.addIndent(stringBuilder, "text-indent", paragraph.getFirstLineIndent());
        WordToHtmlUtils.addIndent(stringBuilder, "margin-left", paragraph.getIndentFromLeft());
        WordToHtmlUtils.addIndent(stringBuilder, "margin-right", paragraph.getIndentFromRight());
        WordToHtmlUtils.addIndent(stringBuilder, "margin-top", paragraph.getSpacingBefore());
        WordToHtmlUtils.addIndent(stringBuilder, "margin-bottom", paragraph.getSpacingAfter());
    }

    private static void addIndent(StringBuilder stringBuilder, String string, int n) {
        if (n == 0) {
            return;
        }
        stringBuilder.append(string + ":" + (float)n / 1440.0f + "in;");
    }

    public static void addJustification(Paragraph paragraph, StringBuilder stringBuilder) {
        String string = WordToHtmlUtils.getJustification(paragraph.getJustification());
        if (WordToHtmlUtils.isNotEmpty(string)) {
            stringBuilder.append("text-align:" + string + ";");
        }
    }

    public static void addParagraphProperties(Paragraph paragraph, StringBuilder stringBuilder) {
        WordToHtmlUtils.addIndent(paragraph, stringBuilder);
        WordToHtmlUtils.addJustification(paragraph, stringBuilder);
        WordToHtmlUtils.addBorder(paragraph.getBottomBorder(), "bottom", stringBuilder);
        WordToHtmlUtils.addBorder(paragraph.getLeftBorder(), "left", stringBuilder);
        WordToHtmlUtils.addBorder(paragraph.getRightBorder(), "right", stringBuilder);
        WordToHtmlUtils.addBorder(paragraph.getTopBorder(), "top", stringBuilder);
        if (paragraph.pageBreakBefore()) {
            stringBuilder.append("break-before:page;");
        }
        stringBuilder.append("hyphenate:" + (paragraph.isAutoHyphenated() ? "auto" : "none") + ";");
        if (paragraph.keepOnPage()) {
            stringBuilder.append("keep-together.within-page:always;");
        }
        if (paragraph.keepWithNext()) {
            stringBuilder.append("keep-with-next.within-page:always;");
        }
    }

    public static void addTableCellProperties(TableRow tableRow, TableCell tableCell, boolean bl, boolean bl2, boolean bl3, boolean bl4, StringBuilder stringBuilder) {
        BorderCode borderCode;
        BorderCode borderCode2;
        BorderCode borderCode3;
        stringBuilder.append("width:" + (float)tableCell.getWidth() / 1440.0f + "in;");
        stringBuilder.append("padding-start:" + (float)tableRow.getGapHalf() / 1440.0f + "in;");
        stringBuilder.append("padding-end:" + (float)tableRow.getGapHalf() / 1440.0f + "in;");
        BorderCode borderCode4 = tableCell.getBrcTop() != null && tableCell.getBrcTop().getBorderType() != 0 ? tableCell.getBrcTop() : (borderCode3 = bl ? tableRow.getTopBorder() : tableRow.getHorizontalBorder());
        BorderCode borderCode5 = tableCell.getBrcBottom() != null && tableCell.getBrcBottom().getBorderType() != 0 ? tableCell.getBrcBottom() : (borderCode2 = bl2 ? tableRow.getBottomBorder() : tableRow.getHorizontalBorder());
        BorderCode borderCode6 = tableCell.getBrcLeft() != null && tableCell.getBrcLeft().getBorderType() != 0 ? tableCell.getBrcLeft() : (borderCode = bl3 ? tableRow.getLeftBorder() : tableRow.getVerticalBorder());
        BorderCode borderCode7 = tableCell.getBrcRight() != null && tableCell.getBrcRight().getBorderType() != 0 ? tableCell.getBrcRight() : (bl4 ? tableRow.getRightBorder() : tableRow.getVerticalBorder());
        WordToHtmlUtils.addBorder(borderCode2, "bottom", stringBuilder);
        WordToHtmlUtils.addBorder(borderCode, "left", stringBuilder);
        WordToHtmlUtils.addBorder(borderCode7, "right", stringBuilder);
        WordToHtmlUtils.addBorder(borderCode3, "top", stringBuilder);
    }

    public static void addTableRowProperties(TableRow tableRow, StringBuilder stringBuilder) {
        if (tableRow.getRowHeight() > 0) {
            stringBuilder.append("height:" + (float)tableRow.getRowHeight() / 1440.0f + "in;");
        }
        if (!tableRow.cantSplit()) {
            stringBuilder.append("keep-together:always;");
        }
    }

    static void compactSpans(Element element) {
        WordToHtmlUtils.compactChildNodesR(element, "span");
    }
}

