/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.converter.AbstractWordConverter;
import ai2.org.apache.poi.hwpf.converter.FontReplacer;
import ai2.org.apache.poi.hwpf.converter.HtmlDocumentFacade;
import ai2.org.apache.poi.hwpf.converter.WordToHtmlUtils;
import ai2.org.apache.poi.hwpf.usermodel.Bookmark;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawing;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Picture;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.Section;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableRow;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.XMLHelper;
import java.io.File;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordToHtmlConverter
extends AbstractWordConverter {
    private static final POILogger logger = POILogFactory.getLogger(WordToHtmlConverter.class);
    private final Stack<BlockProperies> blocksProperies = new Stack();
    private final HtmlDocumentFacade htmlDocumentFacade;
    private Element notes = null;

    private static String getSectionStyle(Section section) {
        float f = (float)section.getMarginLeft() / 1440.0f;
        float f2 = (float)section.getMarginRight() / 1440.0f;
        float f3 = (float)section.getMarginTop() / 1440.0f;
        float f4 = (float)section.getMarginBottom() / 1440.0f;
        String string = "margin: " + f3 + "in " + f2 + "in " + f4 + "in " + f + "in;";
        if (section.getNumColumns() > 1) {
            string = string + "column-count: " + section.getNumColumns() + ";";
            if (section.isColumnsEvenlySpaced()) {
                float f5 = (float)section.getDistanceBetweenColumns() / 1440.0f;
                string = string + "column-gap: " + f5 + "in;";
            } else {
                string = string + "column-gap: 0.25in;";
            }
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: WordToHtmlConverter <inputFile.doc> <saveTo.html>");
            return;
        }
        System.out.println("Converting " + stringArray[0]);
        System.out.println("Saving output to " + stringArray[1]);
        Document document = WordToHtmlConverter.process(new File(stringArray[0]));
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(stringArray[1]));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "html");
        transformer.transform(dOMSource, streamResult);
    }

    static Document process(File file) throws Exception {
        HWPFDocumentCore hWPFDocumentCore = WordToHtmlUtils.loadDoc(file);
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(XMLHelper.getDocumentBuilderFactory().newDocumentBuilder().newDocument());
        wordToHtmlConverter.processDocument(hWPFDocumentCore);
        return wordToHtmlConverter.getDocument();
    }

    public WordToHtmlConverter(Document document) {
        this.htmlDocumentFacade = new HtmlDocumentFacade(document);
    }

    public WordToHtmlConverter(HtmlDocumentFacade htmlDocumentFacade) {
        this.htmlDocumentFacade = htmlDocumentFacade;
    }

    @Override
    protected void afterProcess() {
        if (this.notes != null) {
            this.htmlDocumentFacade.getBody().appendChild(this.notes);
        }
        this.htmlDocumentFacade.updateStylesheet();
    }

    @Override
    public Document getDocument() {
        return this.htmlDocumentFacade.getDocument();
    }

    @Override
    protected void outputCharacters(Element element, CharacterRun characterRun, String string) {
        Element element2 = this.htmlDocumentFacade.document.createElement("span");
        element.appendChild(element2);
        StringBuilder stringBuilder = new StringBuilder();
        BlockProperies blockProperies = this.blocksProperies.peek();
        FontReplacer.Triplet triplet = this.getCharacterRunTriplet(characterRun);
        if (WordToHtmlUtils.isNotEmpty(triplet.fontName) && !WordToHtmlUtils.equals(triplet.fontName, blockProperies.pFontName)) {
            stringBuilder.append("font-family:" + triplet.fontName + ";");
        }
        if (characterRun.getFontSize() / 2 != blockProperies.pFontSize) {
            stringBuilder.append("font-size:" + characterRun.getFontSize() / 2 + "pt;");
        }
        if (triplet.bold) {
            stringBuilder.append("font-weight:bold;");
        }
        if (triplet.italic) {
            stringBuilder.append("font-style:italic;");
        }
        WordToHtmlUtils.addCharactersProperties(characterRun, stringBuilder);
        if (stringBuilder.length() != 0) {
            this.htmlDocumentFacade.addStyleClass(element2, "s", stringBuilder.toString());
        }
        Text text = this.htmlDocumentFacade.createText(string);
        element2.appendChild(text);
    }

    @Override
    protected void processBookmarks(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, List<Bookmark> list) {
        Element element2 = element;
        for (Bookmark bookmark : list) {
            Element element3 = this.htmlDocumentFacade.createBookmark(bookmark.getName());
            element2.appendChild(element3);
            element2 = element3;
        }
        if (range != null) {
            this.processCharacters(hWPFDocumentCore, n, range, element2);
        }
    }

    @Override
    protected void processDocumentInformation(SummaryInformation summaryInformation) {
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getTitle())) {
            this.htmlDocumentFacade.setTitle(summaryInformation.getTitle());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getAuthor())) {
            this.htmlDocumentFacade.addAuthor(summaryInformation.getAuthor());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getKeywords())) {
            this.htmlDocumentFacade.addKeywords(summaryInformation.getKeywords());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getComments())) {
            this.htmlDocumentFacade.addDescription(summaryInformation.getComments());
        }
    }

    @Override
    public void processDocumentPart(HWPFDocumentCore hWPFDocumentCore, Range range) {
        super.processDocumentPart(hWPFDocumentCore, range);
        this.afterProcess();
    }

    @Override
    protected void processDropDownList(Element element, CharacterRun characterRun, String[] stringArray, int n) {
        Element element2 = this.htmlDocumentFacade.createSelect();
        for (int i = 0; i < stringArray.length; ++i) {
            element2.appendChild(this.htmlDocumentFacade.createOption(stringArray[i], n == i));
        }
        element.appendChild(element2);
    }

    @Override
    protected void processDrawnObject(HWPFDocument hWPFDocument, CharacterRun characterRun, OfficeDrawing officeDrawing, String string, Element element) {
        Element element2 = this.htmlDocumentFacade.createImage(string);
        element.appendChild(element2);
    }

    @Override
    protected void processEndnoteAutonumbered(HWPFDocument hWPFDocument, int n, Element element, Range range) {
        this.processNoteAutonumbered(hWPFDocument, "end", n, element, range);
    }

    @Override
    protected void processFootnoteAutonumbered(HWPFDocument hWPFDocument, int n, Element element, Range range) {
        this.processNoteAutonumbered(hWPFDocument, "foot", n, element, range);
    }

    @Override
    protected void processHyperlink(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, String string) {
        Element element2 = this.htmlDocumentFacade.createHyperlink(string);
        element.appendChild(element2);
        if (range != null) {
            this.processCharacters(hWPFDocumentCore, n, range, element2);
        }
    }

    @Override
    protected void processImage(Element element, boolean bl, Picture picture, String string) {
        Element element2;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        int n = picture.getHorizontalScalingFactor();
        int n2 = picture.getVerticalScalingFactor();
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0) {
            f6 = (float)(picture.getDxaGoal() * n / 1000) / 1440.0f;
            f5 = (float)(picture.getDxaCropRight() * n / 1000) / 1440.0f;
            f4 = (float)(picture.getDxaCropLeft() * n / 1000) / 1440.0f;
        } else {
            f6 = (float)picture.getDxaGoal() / 1440.0f;
            f5 = (float)picture.getDxaCropRight() / 1440.0f;
            f4 = (float)picture.getDxaCropLeft() / 1440.0f;
        }
        if (n2 > 0) {
            f3 = (float)(picture.getDyaGoal() * n2 / 1000) / 1440.0f;
            f2 = (float)(picture.getDyaCropTop() * n2 / 1000) / 1440.0f;
            f = (float)(picture.getDyaCropBottom() * n2 / 1000) / 1440.0f;
        } else {
            f3 = (float)picture.getDyaGoal() / 1440.0f;
            f2 = (float)picture.getDyaCropTop() / 1440.0f;
            f = (float)picture.getDyaCropBottom() / 1440.0f;
        }
        if (f2 != 0.0f || f5 != 0.0f || f != 0.0f || f4 != 0.0f) {
            float f7 = Math.max(0.0f, f6 - f4 - f5);
            float f8 = Math.max(0.0f, f3 - f2 - f);
            element2 = this.htmlDocumentFacade.createBlock();
            this.htmlDocumentFacade.addStyleClass(element2, "d", "vertical-align:text-bottom;width:" + f7 + "in;height:" + f8 + "in;");
            Element element3 = this.htmlDocumentFacade.createBlock();
            this.htmlDocumentFacade.addStyleClass(element3, "d", "position:relative;width:" + f7 + "in;height:" + f8 + "in;overflow:hidden;");
            element2.appendChild(element3);
            Element element4 = this.htmlDocumentFacade.createImage(string);
            this.htmlDocumentFacade.addStyleClass(element4, "i", "position:absolute;left:-" + f4 + ";top:-" + f2 + ";width:" + f6 + "in;height:" + f3 + "in;");
            element3.appendChild(element4);
            stringBuilder.append("overflow:hidden;");
        } else {
            element2 = this.htmlDocumentFacade.createImage(string);
            element2.setAttribute("style", "width:" + f6 + "in;height:" + f3 + "in;vertical-align:text-bottom;");
        }
        element.appendChild(element2);
    }

    @Override
    protected void processImageWithoutPicturesManager(Element element, boolean bl, Picture picture) {
        element.appendChild(this.htmlDocumentFacade.document.createComment("Image link to '" + picture.suggestFullFileName() + "' can be here"));
    }

    @Override
    protected void processLineBreak(Element element, CharacterRun characterRun) {
        element.appendChild(this.htmlDocumentFacade.createLineBreak());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNoteAutonumbered(HWPFDocument hWPFDocument, String string, int n, Element element, Range range) {
        String string2 = String.valueOf(n + 1);
        String string3 = this.htmlDocumentFacade.getOrCreateCssClass("a", "vertical-align:super;font-size:smaller;");
        String string4 = string + "note_" + string2;
        String string5 = string + "note_back_" + string2;
        Element element2 = this.htmlDocumentFacade.createHyperlink("#" + string4);
        element2.setAttribute("name", string5);
        element2.setAttribute("class", string3 + " " + string + "noteanchor");
        element2.setTextContent(string2);
        element.appendChild(element2);
        if (this.notes == null) {
            this.notes = this.htmlDocumentFacade.createBlock();
            this.notes.setAttribute("class", "notes");
        }
        Element element3 = this.htmlDocumentFacade.createBlock();
        element3.setAttribute("class", string + "note");
        this.notes.appendChild(element3);
        Element element4 = this.htmlDocumentFacade.createBookmark(string4);
        element4.setAttribute("href", "#" + string5);
        element4.setTextContent(string2);
        element4.setAttribute("class", string3 + " " + string + "noteindex");
        element3.appendChild(element4);
        element3.appendChild(this.htmlDocumentFacade.createText(" "));
        Element element5 = this.htmlDocumentFacade.getDocument().createElement("span");
        element5.setAttribute("class", string + "notetext");
        element3.appendChild(element5);
        this.blocksProperies.add(new BlockProperies("", -1));
        try {
            this.processCharacters(hWPFDocument, Integer.MIN_VALUE, range, element5);
        }
        finally {
            this.blocksProperies.pop();
        }
    }

    @Override
    protected void processPageBreak(HWPFDocumentCore hWPFDocumentCore, Element element) {
        element.appendChild(this.htmlDocumentFacade.createLineBreak());
    }

    @Override
    protected void processPageref(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, String string) {
        Element element2 = this.htmlDocumentFacade.createHyperlink("#" + string);
        element.appendChild(element2);
        if (range != null) {
            this.processCharacters(hWPFDocumentCore, n, range, element2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processParagraph(HWPFDocumentCore hWPFDocumentCore, Element element, int n, Paragraph paragraph, String string) {
        Object object;
        int n2;
        Element element2 = this.htmlDocumentFacade.createParagraph();
        element.appendChild(element2);
        StringBuilder stringBuilder = new StringBuilder();
        WordToHtmlUtils.addParagraphProperties(paragraph, stringBuilder);
        int n3 = paragraph.numCharacterRuns();
        if (n3 == 0) {
            return;
        }
        CharacterRun characterRun = paragraph.getCharacterRun(0);
        if (characterRun != null) {
            FontReplacer.Triplet triplet = this.getCharacterRunTriplet(characterRun);
            n2 = characterRun.getFontSize() / 2;
            object = triplet.fontName;
            WordToHtmlUtils.addFontFamily((String)object, stringBuilder);
            WordToHtmlUtils.addFontSize(n2, stringBuilder);
        } else {
            n2 = -1;
            object = "";
        }
        this.blocksProperies.push(new BlockProperies((String)object, n2));
        try {
            if (WordToHtmlUtils.isNotEmpty(string)) {
                if (string.endsWith("\t")) {
                    float f = paragraph.getIndentFromLeft() + paragraph.getFirstLineIndent() + 20;
                    float f2 = (float)(Math.ceil(f / 720.0f) * 720.0);
                    float f3 = f2 - f;
                    Element element3 = this.htmlDocumentFacade.getDocument().createElement("span");
                    this.htmlDocumentFacade.addStyleClass(element3, "s", "display: inline-block; text-indent: 0; min-width: " + f3 / 1440.0f + "in;");
                    element2.appendChild(element3);
                    Text text = this.htmlDocumentFacade.createText(string.substring(0, string.length() - 1) + '\u200b' + '\u00a0');
                    element3.appendChild(text);
                } else {
                    object = this.htmlDocumentFacade.createText(string.substring(0, string.length() - 1));
                    element2.appendChild((Node)object);
                }
            }
            this.processCharacters(hWPFDocumentCore, n, paragraph, element2);
        }
        finally {
            this.blocksProperies.pop();
        }
        if (stringBuilder.length() > 0) {
            this.htmlDocumentFacade.addStyleClass(element2, "p", stringBuilder.toString());
        }
        WordToHtmlUtils.compactSpans(element2);
    }

    @Override
    protected void processSection(HWPFDocumentCore hWPFDocumentCore, Section section, int n) {
        Element element = this.htmlDocumentFacade.createBlock();
        this.htmlDocumentFacade.addStyleClass(element, "d", WordToHtmlConverter.getSectionStyle(section));
        this.htmlDocumentFacade.body.appendChild(element);
        this.processParagraphes(hWPFDocumentCore, element, section, Integer.MIN_VALUE);
    }

    @Override
    protected void processSingleSection(HWPFDocumentCore hWPFDocumentCore, Section section) {
        this.htmlDocumentFacade.addStyleClass(this.htmlDocumentFacade.body, "b", WordToHtmlConverter.getSectionStyle(section));
        this.processParagraphes(hWPFDocumentCore, this.htmlDocumentFacade.body, section, Integer.MIN_VALUE);
    }

    @Override
    protected void processTable(HWPFDocumentCore hWPFDocumentCore, Element element, Table table) {
        int n;
        Element element2 = this.htmlDocumentFacade.createTableHeader();
        Element element3 = this.htmlDocumentFacade.createTableBody();
        int[] nArray = WordToHtmlUtils.buildTableCellEdgesArray(table);
        int n2 = table.numRows();
        int n3 = Integer.MIN_VALUE;
        for (n = 0; n < n2; ++n) {
            n3 = Math.max(n3, table.getRow(n).numCells());
        }
        for (n = 0; n < n2; ++n) {
            TableRow tableRow = table.getRow(n);
            Element element4 = this.htmlDocumentFacade.createTableRow();
            StringBuilder stringBuilder = new StringBuilder();
            WordToHtmlUtils.addTableRowProperties(tableRow, stringBuilder);
            int n4 = 0;
            int n5 = tableRow.numCells();
            for (int i = 0; i < n5; ++i) {
                int n6;
                TableCell tableCell = tableRow.getCell(i);
                if (tableCell.isVerticallyMerged() && !tableCell.isFirstVerticallyMerged()) {
                    n4 += this.getNumberColumnsSpanned(nArray, n4, tableCell);
                    continue;
                }
                Element element5 = tableRow.isTableHeader() ? this.htmlDocumentFacade.createTableHeaderCell() : this.htmlDocumentFacade.createTableCell();
                StringBuilder stringBuilder2 = new StringBuilder();
                WordToHtmlUtils.addTableCellProperties(tableRow, tableCell, n == 0, n == n2 - 1, i == 0, i == n5 - 1, stringBuilder2);
                int n7 = this.getNumberColumnsSpanned(nArray, n4, tableCell);
                n4 += n7;
                if (n7 == 0) continue;
                if (n7 != 1) {
                    element5.setAttribute("colspan", String.valueOf(n7));
                }
                if ((n6 = this.getNumberRowsSpanned(table, nArray, n, i, tableCell)) > 1) {
                    element5.setAttribute("rowspan", String.valueOf(n6));
                }
                this.processParagraphes(hWPFDocumentCore, element5, tableCell, table.getTableLevel());
                if (!element5.hasChildNodes()) {
                    element5.appendChild(this.htmlDocumentFacade.createParagraph());
                }
                if (stringBuilder2.length() > 0) {
                    this.htmlDocumentFacade.addStyleClass(element5, element5.getTagName(), stringBuilder2.toString());
                }
                element4.appendChild(element5);
            }
            if (stringBuilder.length() > 0) {
                element4.setAttribute("class", this.htmlDocumentFacade.getOrCreateCssClass("r", stringBuilder.toString()));
            }
            if (tableRow.isTableHeader()) {
                element2.appendChild(element4);
                continue;
            }
            element3.appendChild(element4);
        }
        Element element6 = this.htmlDocumentFacade.createTable();
        element6.setAttribute("class", this.htmlDocumentFacade.getOrCreateCssClass("t", "table-layout:fixed;border-collapse:collapse;border-spacing:0;"));
        if (element2.hasChildNodes()) {
            element6.appendChild(element2);
        }
        if (element3.hasChildNodes()) {
            element6.appendChild(element3);
            element.appendChild(element6);
        } else {
            logger.log(5, "Table without body starting at [", table.getStartOffset(), "; ", table.getEndOffset(), ")");
        }
    }

    private static class BlockProperies {
        final String pFontName;
        final int pFontSize;

        public BlockProperies(String string, int n) {
            this.pFontName = string;
            this.pFontSize = n;
        }
    }
}

