/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hwpf.converter.WordToHtmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TextDocumentFacade {
    protected final Element body;
    protected final Document document;
    protected final Element head;
    protected final Element root;
    protected Element title;
    protected Text titleText;

    public TextDocumentFacade(Document document) {
        this.document = document;
        this.root = document.createElement("html");
        document.appendChild(this.root);
        this.body = document.createElement("body");
        this.head = document.createElement("head");
        this.root.appendChild(this.head);
        this.root.appendChild(this.body);
        this.title = document.createElement("title");
        this.titleText = document.createTextNode("");
        this.head.appendChild(this.title);
    }

    public void addAuthor(String string) {
        this.addMeta("Author", string);
    }

    public void addDescription(String string) {
        this.addMeta("Description", string);
    }

    public void addKeywords(String string) {
        this.addMeta("Keywords", string);
    }

    public void addMeta(String string, String string2) {
        Element element = this.document.createElement("meta");
        Element element2 = this.document.createElement("name");
        element2.appendChild(this.document.createTextNode(string + ": "));
        element.appendChild(element2);
        Element element3 = this.document.createElement("value");
        element3.appendChild(this.document.createTextNode(string2 + "\n"));
        element.appendChild(element3);
        this.head.appendChild(element);
    }

    public Element createBlock() {
        return this.document.createElement("div");
    }

    public Element createHeader1() {
        Element element = this.document.createElement("h1");
        element.appendChild(this.document.createTextNode("        "));
        return element;
    }

    public Element createHeader2() {
        Element element = this.document.createElement("h2");
        element.appendChild(this.document.createTextNode("    "));
        return element;
    }

    public Element createParagraph() {
        return this.document.createElement("p");
    }

    public Element createTable() {
        return this.document.createElement("table");
    }

    public Element createTableBody() {
        return this.document.createElement("tbody");
    }

    public Element createTableCell() {
        return this.document.createElement("td");
    }

    public Element createTableRow() {
        return this.document.createElement("tr");
    }

    public Text createText(String string) {
        return this.document.createTextNode(string);
    }

    public Element createUnorderedList() {
        return this.document.createElement("ul");
    }

    public Element getBody() {
        return this.body;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getHead() {
        return this.head;
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.titleText.getTextContent();
    }

    public void setTitle(String string) {
        if (WordToHtmlUtils.isEmpty(string) && this.title != null) {
            this.head.removeChild(this.title);
            this.title = null;
            this.titleText = null;
        }
        if (this.title == null) {
            this.title = this.document.createElement("title");
            this.titleText = this.document.createTextNode(string);
            this.title.appendChild(this.titleText);
            this.head.appendChild(this.title);
        }
        this.titleText.setData(string);
    }
}

