/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import java.util.Locale;

public final class NumberFormatter {
    private static final String[] ENGLISH_LETTERS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final String[] ROMAN_LETTERS = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};
    private static final int[] ROMAN_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final int T_ARABIC = 0;
    private static final int T_LOWER_LETTER = 4;
    private static final int T_LOWER_ROMAN = 2;
    private static final int T_ORDINAL = 5;
    private static final int T_UPPER_LETTER = 3;
    private static final int T_UPPER_ROMAN = 1;

    public static String getNumber(int n, int n2) {
        switch (n2) {
            case 1: {
                return NumberFormatter.toRoman(n).toUpperCase(Locale.ROOT);
            }
            case 2: {
                return NumberFormatter.toRoman(n);
            }
            case 3: {
                return NumberFormatter.toLetters(n).toUpperCase(Locale.ROOT);
            }
            case 4: {
                return NumberFormatter.toLetters(n);
            }
        }
        return String.valueOf(n);
    }

    private static String toLetters(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Unsupported number: " + n);
        }
        if (n < 27) {
            return ENGLISH_LETTERS[n - 1];
        }
        long l = n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        while (l > (long)n3) {
            ++n2;
            if ((n3 = n3 * 26 + 26) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Unsupported number: " + l);
        }
        for (n3 = --n2; n3 > 0; --n3) {
            int n4;
            long l2 = 0L;
            long l3 = 1L;
            for (n4 = 0; n4 < n3; ++n4) {
                l3 *= 26L;
                l2 = l2 * 26L + 26L;
            }
            n4 = 0;
            while (l > l2) {
                ++n4;
                l -= l3;
            }
            stringBuilder.append(ENGLISH_LETTERS[n4 - 1]);
        }
        stringBuilder.append(ENGLISH_LETTERS[(int)l - 1]);
        return stringBuilder.toString();
    }

    private static String toRoman(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Unsupported number: " + n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < ROMAN_LETTERS.length; ++i) {
            String string = ROMAN_LETTERS[i];
            int n2 = ROMAN_VALUES[i];
            while (n >= n2) {
                n -= n2;
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }
}

