/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hwpf.converter.WordToFoUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FoDocumentFacade {
    private static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String NS_XSLFO = "http://www.w3.org/1999/XSL/Format";
    protected final Element declarations;
    protected final Document document;
    protected final Element layoutMasterSet;
    protected Element propertiesRoot;
    protected final Element root;

    public FoDocumentFacade(Document document) {
        this.document = document;
        this.root = document.createElementNS(NS_XSLFO, "fo:root");
        document.appendChild(this.root);
        this.layoutMasterSet = document.createElementNS(NS_XSLFO, "fo:layout-master-set");
        this.root.appendChild(this.layoutMasterSet);
        this.declarations = document.createElementNS(NS_XSLFO, "fo:declarations");
        this.root.appendChild(this.declarations);
    }

    public Element addFlowToPageSequence(Element element, String string) {
        Element element2 = this.document.createElementNS(NS_XSLFO, "fo:flow");
        element2.setAttribute("flow-name", string);
        element.appendChild(element2);
        return element2;
    }

    public Element addListItem(Element element) {
        Element element2 = this.createListItem();
        element.appendChild(element2);
        return element2;
    }

    public Element addListItemBody(Element element) {
        Element element2 = this.createListItemBody();
        element.appendChild(element2);
        return element2;
    }

    public Element addListItemLabel(Element element, String string) {
        Element element2 = this.createListItemLabel(string);
        element.appendChild(element2);
        return element2;
    }

    public void addPageSequence(Element element) {
        this.root.appendChild(element);
    }

    public Element addPageSequence(String string) {
        Element element = this.createPageSequence(string);
        this.root.appendChild(element);
        return element;
    }

    public Element addRegionBody(Element element) {
        Element element2 = this.document.createElementNS(NS_XSLFO, "fo:region-body");
        element.appendChild(element2);
        return element2;
    }

    public Element addSimplePageMaster(String string) {
        Element element = this.document.createElementNS(NS_XSLFO, "fo:simple-page-master");
        element.setAttribute("master-name", string);
        this.layoutMasterSet.appendChild(element);
        return element;
    }

    public Element createBasicLinkExternal(String string) {
        Element element = this.document.createElementNS(NS_XSLFO, "fo:basic-link");
        element.setAttribute("external-destination", string);
        return element;
    }

    public Element createBasicLinkInternal(String string) {
        Element element = this.document.createElementNS(NS_XSLFO, "fo:basic-link");
        element.setAttribute("internal-destination", string);
        return element;
    }

    public Element createBlock() {
        return this.document.createElementNS(NS_XSLFO, "fo:block");
    }

    public Element createExternalGraphic(String string) {
        Element element = this.document.createElementNS(NS_XSLFO, "fo:external-graphic");
        element.setAttribute("src", "url('" + string + "')");
        return element;
    }

    public Element createFootnote() {
        return this.document.createElementNS(NS_XSLFO, "fo:footnote");
    }

    public Element createFootnoteBody() {
        return this.document.createElementNS(NS_XSLFO, "fo:footnote-body");
    }

    public Element createInline() {
        return this.document.createElementNS(NS_XSLFO, "fo:inline");
    }

    public Element createLeader() {
        return this.document.createElementNS(NS_XSLFO, "fo:leader");
    }

    public Element createListBlock() {
        return this.document.createElementNS(NS_XSLFO, "fo:list-block");
    }

    public Element createListItem() {
        return this.document.createElementNS(NS_XSLFO, "fo:list-item");
    }

    public Element createListItemBody() {
        return this.document.createElementNS(NS_XSLFO, "fo:list-item-body");
    }

    public Element createListItemLabel(String string) {
        Element element = this.document.createElementNS(NS_XSLFO, "fo:list-item-label");
        Element element2 = this.createBlock();
        element2.appendChild(this.document.createTextNode(string));
        element.appendChild(element2);
        return element;
    }

    public Element createPageSequence(String string) {
        Element element = this.document.createElementNS(NS_XSLFO, "fo:page-sequence");
        element.setAttribute("master-reference", string);
        return element;
    }

    public Element createTable() {
        return this.document.createElementNS(NS_XSLFO, "fo:table");
    }

    public Element createTableBody() {
        return this.document.createElementNS(NS_XSLFO, "fo:table-body");
    }

    public Element createTableCell() {
        return this.document.createElementNS(NS_XSLFO, "fo:table-cell");
    }

    public Element createTableColumn() {
        return this.document.createElementNS(NS_XSLFO, "fo:table-column");
    }

    public Element createTableHeader() {
        return this.document.createElementNS(NS_XSLFO, "fo:table-header");
    }

    public Element createTableRow() {
        return this.document.createElementNS(NS_XSLFO, "fo:table-row");
    }

    public Text createText(String string) {
        return this.document.createTextNode(string);
    }

    public Document getDocument() {
        return this.document;
    }

    protected Element getOrCreatePropertiesRoot() {
        if (this.propertiesRoot != null) {
            return this.propertiesRoot;
        }
        Element element = this.document.createElementNS("adobe:ns:meta/", "x:xmpmeta");
        this.declarations.appendChild(element);
        Element element2 = this.document.createElementNS(NS_RDF, "rdf:RDF");
        element.appendChild(element2);
        this.propertiesRoot = this.document.createElementNS(NS_RDF, "rdf:Description");
        this.propertiesRoot.setAttributeNS(NS_RDF, "rdf:about", "");
        element2.appendChild(this.propertiesRoot);
        return this.propertiesRoot;
    }

    public void setCreator(String string) {
        this.setDublinCoreProperty("creator", string);
    }

    public void setCreatorTool(String string) {
        this.setXmpProperty("CreatorTool", string);
    }

    public void setDescription(String string) {
        Element element = this.setDublinCoreProperty("description", string);
        if (element != null) {
            element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", "x-default");
        }
    }

    public Element setDublinCoreProperty(String string, String string2) {
        return this.setProperty("http://purl.org/dc/elements/1.1/", "dc", string, string2);
    }

    public void setKeywords(String string) {
        this.setPdfProperty("Keywords", string);
    }

    public Element setPdfProperty(String string, String string2) {
        return this.setProperty("http://ns.adobe.com/pdf/1.3/", "pdf", string, string2);
    }

    public void setProducer(String string) {
        this.setPdfProperty("Producer", string);
    }

    protected Element setProperty(String string, String string2, String string3, String string4) {
        Element element = this.getOrCreatePropertiesRoot();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !WordToFoUtils.isNotEmpty((element2 = (Element)node).getNamespaceURI()) || !WordToFoUtils.isNotEmpty(element2.getLocalName()) || !string.equals(element2.getNamespaceURI()) || !string3.equals(element2.getLocalName())) continue;
            element.removeChild(element2);
            break;
        }
        if (WordToFoUtils.isNotEmpty(string4)) {
            Element element3 = this.document.createElementNS(string, string2 + ":" + string3);
            element3.appendChild(this.document.createTextNode(string4));
            element.appendChild(element3);
            return element3;
        }
        return null;
    }

    public void setSubject(String string) {
        this.setDublinCoreProperty("title", string);
    }

    public void setTitle(String string) {
        this.setDublinCoreProperty("title", string);
    }

    public Element setXmpProperty(String string, String string2) {
        return this.setProperty("http://ns.adobe.com/xap/1.0/", "xmp", string, string2);
    }
}

