/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.converter.AbstractWordUtils;
import ai2.org.apache.poi.hwpf.converter.DefaultFontReplacer;
import ai2.org.apache.poi.hwpf.converter.FontReplacer;
import ai2.org.apache.poi.hwpf.converter.PicturesManager;
import ai2.org.apache.poi.hwpf.converter.WordToFoUtils;
import ai2.org.apache.poi.hwpf.model.FieldsDocumentPart;
import ai2.org.apache.poi.hwpf.usermodel.Bookmark;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.Field;
import ai2.org.apache.poi.hwpf.usermodel.HWPFList;
import ai2.org.apache.poi.hwpf.usermodel.Notes;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawing;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Picture;
import ai2.org.apache.poi.hwpf.usermodel.PictureType;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.Section;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableRow;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWordConverter {
    private static final byte BEL_MARK = 7;
    private static final byte FIELD_BEGIN_MARK = 19;
    private static final byte FIELD_END_MARK = 21;
    private static final byte FIELD_SEPARATOR_MARK = 20;
    private static final POILogger logger = POILogFactory.getLogger(AbstractWordConverter.class);
    private static final Pattern PATTERN_HYPERLINK_EXTERNAL = Pattern.compile("^[ \\t\\r\\n]*HYPERLINK \"(.*)\".*$");
    private static final Pattern PATTERN_HYPERLINK_LOCAL = Pattern.compile("^[ \\t\\r\\n]*HYPERLINK \\\\l \"(.*)\"[ ](.*)$");
    private static final Pattern PATTERN_PAGEREF = Pattern.compile("^[ \\t\\r\\n]*PAGEREF ([^ ]*)[ \\t\\r\\n]*\\\\h.*$");
    private static final byte SPECCHAR_AUTONUMBERED_FOOTNOTE_REFERENCE = 2;
    private static final byte SPECCHAR_DRAWN_OBJECT = 8;
    protected static final char UNICODECHAR_NO_BREAK_SPACE = '\u00a0';
    protected static final char UNICODECHAR_NONBREAKING_HYPHEN = '\u2011';
    protected static final char UNICODECHAR_ZERO_WIDTH_SPACE = '\u200b';
    private final Set<Bookmark> bookmarkStack = new LinkedHashSet<Bookmark>();
    private FontReplacer fontReplacer = new DefaultFontReplacer();
    private POILogger log = POILogFactory.getLogger(this.getClass());
    private AbstractWordUtils.NumberingState numberingState = new AbstractWordUtils.NumberingState();
    private PicturesManager picturesManager;

    private static void addToStructures(List<Structure> list, Structure structure) {
        Iterator<Structure> iterator = list.iterator();
        while (iterator.hasNext()) {
            Structure structure2 = iterator.next();
            if (structure2.start <= structure.start && structure2.end >= structure.start) {
                return;
            }
            if (!(structure.start < structure2.start && structure2.start < structure.end || structure.start < structure2.start && structure2.end <= structure.end) && (structure.start > structure2.start || structure2.end >= structure.end)) continue;
            iterator.remove();
        }
        list.add(structure);
    }

    protected void afterProcess() {
    }

    protected FontReplacer.Triplet getCharacterRunTriplet(CharacterRun characterRun) {
        FontReplacer.Triplet triplet = new FontReplacer.Triplet();
        triplet.bold = characterRun.isBold();
        triplet.italic = characterRun.isItalic();
        triplet.fontName = characterRun.getFontName();
        FontReplacer.Triplet triplet2 = this.getFontReplacer().update(triplet);
        return triplet2;
    }

    public abstract Document getDocument();

    public FontReplacer getFontReplacer() {
        return this.fontReplacer;
    }

    protected int getNumberColumnsSpanned(int[] nArray, int n, TableCell tableCell) {
        int n2 = n;
        int n3 = 0;
        int n4 = tableCell.getLeftEdge() + tableCell.getWidth();
        while (nArray[n2] < n4) {
            ++n3;
            ++n2;
        }
        return n3;
    }

    protected int getNumberRowsSpanned(Table table, int[] nArray, int n, int n2, TableCell tableCell) {
        TableRow tableRow;
        if (!tableCell.isFirstVerticallyMerged()) {
            return 1;
        }
        int n3 = table.numRows();
        int n4 = 1;
        for (int i = n + 1; i < n3 && n2 < (tableRow = table.getRow(i)).numCells(); ++i) {
            boolean bl = false;
            int n5 = 0;
            for (int j = 0; j < tableRow.numCells(); ++j) {
                TableCell tableCell2 = tableRow.getCell(j);
                if (!tableCell2.isVerticallyMerged() || tableCell2.isFirstVerticallyMerged()) {
                    int n6 = this.getNumberColumnsSpanned(nArray, n5, tableCell2);
                    n5 += n6;
                    if (n6 == 0) continue;
                    bl = true;
                    break;
                }
                n5 += this.getNumberColumnsSpanned(nArray, n5, tableCell2);
            }
            if (!bl) continue;
            TableCell tableCell3 = tableRow.getCell(n2);
            if (!tableCell3.isVerticallyMerged() || tableCell3.isFirstVerticallyMerged()) break;
            ++n4;
        }
        return n4;
    }

    public PicturesManager getPicturesManager() {
        return this.picturesManager;
    }

    protected abstract void outputCharacters(Element var1, CharacterRun var2, String var3);

    protected abstract void processBookmarks(HWPFDocumentCore var1, Element var2, Range var3, int var4, List<Bookmark> var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processCharacters(HWPFDocumentCore hWPFDocumentCore, int n, Range range, Element element) {
        Map<Integer, List<Bookmark>> map;
        if (range == null) {
            return false;
        }
        boolean bl = false;
        AbstractList abstractList = new LinkedList();
        if (hWPFDocumentCore instanceof HWPFDocument) {
            HWPFDocument hWPFDocument = (HWPFDocument)hWPFDocumentCore;
            map = hWPFDocument.getBookmarks().getBookmarksStartedBetween(range.getStartOffset(), range.getEndOffset());
            if (map != null) {
                for (List list : map.values()) {
                    for (Bookmark object2 : list) {
                        if (this.bookmarkStack.contains(object2)) continue;
                        AbstractWordConverter.addToStructures(abstractList, new Structure(object2));
                    }
                }
            }
            int n2 = -1;
            for (int i = 0; i < range.numCharacterRuns(); ++i) {
                String string;
                CharacterRun characterRun = range.getCharacterRun(i);
                if (characterRun == null) {
                    throw new AssertionError();
                }
                if (characterRun.getStartOffset() < n2 || (string = characterRun.text()) == null || string.length() == 0 || string.charAt(0) != '\u0013') continue;
                Field field = ((HWPFDocument)hWPFDocumentCore).getFields().getFieldByStartOffset(FieldsDocumentPart.MAIN, characterRun.getStartOffset());
                if (field != null) {
                    AbstractWordConverter.addToStructures(abstractList, new Structure(field));
                    continue;
                }
                int[] nArray = this.tryDeadField_lookupFieldSeparatorEnd(hWPFDocumentCore, range, i);
                if (nArray == null) continue;
                AbstractWordConverter.addToStructures(abstractList, new Structure(new DeadFieldBoundaries(i, nArray[0], nArray[1]), characterRun.getStartOffset(), range.getCharacterRun(nArray[1]).getEndOffset()));
                i = nArray[1];
            }
        }
        abstractList = new ArrayList(abstractList);
        Collections.sort(abstractList);
        int n3 = range.getStartOffset();
        for (Structure structure : abstractList) {
            Object object3;
            if (structure.start != n3) {
                Range range2 = new Range(n3, structure.start, range){

                    public String toString() {
                        return "BetweenStructuresSubrange " + super.toString();
                    }
                };
                this.processCharacters(hWPFDocumentCore, n, range2, element);
            }
            if (structure.structure instanceof Bookmark) {
                object3 = new LinkedList();
                for (Bookmark bookmark : ((HWPFDocument)hWPFDocumentCore).getBookmarks().getBookmarksStartedBetween(structure.start, structure.start + 1).values().iterator().next()) {
                    if (bookmark.getStart() != structure.start || bookmark.getEnd() != structure.end) continue;
                    object3.add(bookmark);
                }
                this.bookmarkStack.addAll((Collection<Bookmark>)object3);
                try {
                    int n4 = Math.min(range.getEndOffset(), structure.end);
                    Range range2 = new Range(structure.start, n4, range){

                        public String toString() {
                            return "BookmarksSubrange " + super.toString();
                        }
                    };
                    this.processBookmarks(hWPFDocumentCore, element, range2, n, (List<Bookmark>)object3);
                }
                finally {
                    this.bookmarkStack.removeAll((Collection<?>)object3);
                }
            } else if (structure.structure instanceof Field) {
                object3 = (Field)structure.structure;
                this.processField((HWPFDocument)hWPFDocumentCore, range, n, (Field)object3, element);
            } else if (structure.structure instanceof DeadFieldBoundaries) {
                object3 = (DeadFieldBoundaries)structure.structure;
                this.processDeadField(hWPFDocumentCore, element, range, n, ((DeadFieldBoundaries)object3).beginMark, ((DeadFieldBoundaries)object3).separatorMark, ((DeadFieldBoundaries)object3).endMark);
            } else {
                throw new UnsupportedOperationException("NYI: " + structure.structure.getClass());
            }
            n3 = Math.min(range.getEndOffset(), structure.end);
        }
        if (n3 != range.getStartOffset()) {
            if (n3 > range.getEndOffset()) {
                logger.log(5, "Latest structure in ", range, " ended at #" + n3, " after range boundaries [", range.getStartOffset() + "; " + range.getEndOffset(), ")");
                return true;
            }
            if (n3 < range.getEndOffset()) {
                map = new Range(n3, range.getEndOffset(), range){

                    public String toString() {
                        return "AfterStructureSubrange " + super.toString();
                    }
                };
                this.processCharacters(hWPFDocumentCore, n, (Range)((Object)map), element);
            }
            return true;
        }
        for (int i = 0; i < range.numCharacterRuns(); ++i) {
            Object object4;
            CharacterRun characterRun = range.getCharacterRun(i);
            if (characterRun == null) {
                throw new AssertionError();
            }
            if (hWPFDocumentCore instanceof HWPFDocument && ((HWPFDocument)hWPFDocumentCore).getPicturesTable().hasPicture(characterRun)) {
                object4 = (HWPFDocument)hWPFDocumentCore;
                Picture picture = ((HWPFDocument)object4).getPicturesTable().extractPicture(characterRun, true);
                this.processImage(element, characterRun.text().charAt(0) == '\u0001', picture);
                continue;
            }
            object4 = characterRun.text();
            if (((String)object4).isEmpty()) continue;
            if (characterRun.isSpecialCharacter()) {
                if (((String)object4).charAt(0) == '\u0002' && hWPFDocumentCore instanceof HWPFDocument) {
                    HWPFDocument hWPFDocument = (HWPFDocument)hWPFDocumentCore;
                    this.processNoteAnchor(hWPFDocument, characterRun, element);
                    continue;
                }
                if (((String)object4).charAt(0) == '\b' && hWPFDocumentCore instanceof HWPFDocument) {
                    HWPFDocument hWPFDocument = (HWPFDocument)hWPFDocumentCore;
                    this.processDrawnObject(hWPFDocument, characterRun, element);
                    continue;
                }
                if (characterRun.isOle2() && hWPFDocumentCore instanceof HWPFDocument) {
                    HWPFDocument hWPFDocument = (HWPFDocument)hWPFDocumentCore;
                    this.processOle2(hWPFDocument, characterRun, element);
                    continue;
                }
                if (characterRun.isSymbol() && hWPFDocumentCore instanceof HWPFDocument) {
                    HWPFDocument hWPFDocument = (HWPFDocument)hWPFDocumentCore;
                    this.processSymbol(hWPFDocument, characterRun, element);
                    continue;
                }
            }
            if (((String)object4).charAt(0) == '\u0013') {
                Field field;
                if (hWPFDocumentCore instanceof HWPFDocument && (field = ((HWPFDocument)hWPFDocumentCore).getFields().getFieldByStartOffset(FieldsDocumentPart.MAIN, characterRun.getStartOffset())) != null) {
                    this.processField((HWPFDocument)hWPFDocumentCore, range, n, field, element);
                    int n2 = field.getFieldEndOffset();
                    while (i < range.numCharacterRuns() && range.getCharacterRun(i).getEndOffset() <= n2) {
                        ++i;
                    }
                    if (i >= range.numCharacterRuns()) continue;
                    --i;
                    continue;
                }
                int n6 = this.tryDeadField(hWPFDocumentCore, range, n, i, element);
                if (n6 == i) continue;
                i = n6;
                continue;
            }
            if (((String)object4).charAt(0) == '\u0014' || ((String)object4).charAt(0) == '\u0015' || characterRun.isSpecialCharacter() || characterRun.isObj() || characterRun.isOle2()) continue;
            if (((String)object4).endsWith("\r") || ((String)object4).charAt(((String)object4).length() - 1) == '\u0007' && n != Integer.MIN_VALUE) {
                object4 = ((String)object4).substring(0, ((String)object4).length() - 1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (char c : ((String)object4).toCharArray()) {
                if (c == '\u000b') {
                    if (stringBuilder.length() > 0) {
                        this.outputCharacters(element, characterRun, stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    this.processLineBreak(element, characterRun);
                    continue;
                }
                if (c == '\u001e') {
                    stringBuilder.append('\u2011');
                    continue;
                }
                if (c == '\u001f') {
                    stringBuilder.append('\u200b');
                    continue;
                }
                if (c < ' ' && c != '\t' && c != '\n' && c != '\r') continue;
                stringBuilder.append(c);
            }
            if (stringBuilder.length() > 0) {
                this.outputCharacters(element, characterRun, stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            bl |= ((String)object4).trim().length() != 0;
        }
        return bl;
    }

    protected void processDeadField(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, int n2, int n3, int n4) {
        Object object;
        if (n2 + 1 < n3 && n3 + 1 < n4) {
            object = new Range(range.getCharacterRun(n2 + 1).getStartOffset(), range.getCharacterRun(n3 - 1).getEndOffset(), range){

                public String toString() {
                    return "Dead field formula subrange: " + super.toString();
                }
            };
            Range range2 = new Range(range.getCharacterRun(n3 + 1).getStartOffset(), range.getCharacterRun(n4 - 1).getEndOffset(), range){

                public String toString() {
                    return "Dead field value subrange: " + super.toString();
                }
            };
            String string = ((Range)object).text();
            Matcher matcher = PATTERN_HYPERLINK_LOCAL.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                this.processPageref(hWPFDocumentCore, element, range2, n, string2);
                return;
            }
        }
        object = new StringBuilder("Unsupported field type: \n");
        for (int i = n2; i <= n4; ++i) {
            ((StringBuilder)object).append("\t");
            ((StringBuilder)object).append(range.getCharacterRun(i));
            ((StringBuilder)object).append("\n");
        }
        logger.log(5, new Object[]{object});
        Range range3 = new Range(range.getCharacterRun(n3).getStartOffset() + 1, range.getCharacterRun(n4).getStartOffset(), range){

            public String toString() {
                return "DeadFieldValueSubrange (" + super.toString() + ")";
            }
        };
        if (n3 + 1 < n4) {
            this.processCharacters(hWPFDocumentCore, n, range3, element);
        }
    }

    public void processDocument(HWPFDocumentCore hWPFDocumentCore) {
        Object object;
        try {
            object = hWPFDocumentCore.getSummaryInformation();
            if (object != null) {
                this.processDocumentInformation((SummaryInformation)object);
            }
        }
        catch (Exception exception) {
            logger.log(5, "Unable to process document summary information: ", exception, exception);
        }
        object = hWPFDocumentCore.getRange();
        if (((Range)object).numSections() == 1) {
            this.processSingleSection(hWPFDocumentCore, ((Range)object).getSection(0));
            this.afterProcess();
            return;
        }
        this.processDocumentPart(hWPFDocumentCore, (Range)object);
        this.afterProcess();
    }

    protected abstract void processDocumentInformation(SummaryInformation var1);

    protected void processDocumentPart(HWPFDocumentCore hWPFDocumentCore, Range range) {
        for (int i = 0; i < range.numSections(); ++i) {
            this.processSection(hWPFDocumentCore, range.getSection(i), i);
        }
    }

    protected void processDrawnObject(HWPFDocument hWPFDocument, CharacterRun characterRun, Element element) {
        if (this.getPicturesManager() == null) {
            return;
        }
        OfficeDrawing officeDrawing = hWPFDocument.getOfficeDrawingsMain().getOfficeDrawingAt(characterRun.getStartOffset());
        if (officeDrawing == null) {
            logger.log(5, new Object[]{"Characters #" + characterRun + " references missing drawn object"});
            return;
        }
        byte[] byArray = officeDrawing.getPictureData();
        if (byArray == null) {
            return;
        }
        float f = (float)(officeDrawing.getRectangleRight() - officeDrawing.getRectangleLeft()) / 1440.0f;
        float f2 = (float)(officeDrawing.getRectangleBottom() - officeDrawing.getRectangleTop()) / 1440.0f;
        PictureType pictureType = PictureType.findMatchingType(byArray);
        String string = this.getPicturesManager().savePicture(byArray, pictureType, "s" + characterRun.getStartOffset() + "." + (Object)((Object)pictureType), f, f2);
        this.processDrawnObject(hWPFDocument, characterRun, officeDrawing, string, element);
    }

    protected abstract void processDrawnObject(HWPFDocument var1, CharacterRun var2, OfficeDrawing var3, String var4, Element var5);

    protected void processDropDownList(Element element, CharacterRun characterRun, String[] stringArray, int n) {
        this.outputCharacters(element, characterRun, stringArray[n]);
    }

    protected abstract void processEndnoteAutonumbered(HWPFDocument var1, int var2, Element var3, Range var4);

    protected void processField(HWPFDocument hWPFDocument, Range range, int n, Field field, Element element) {
        switch (field.getType()) {
            case 37: {
                String string;
                Matcher matcher;
                Range range2 = field.firstSubrange(range);
                if (range2 == null || !(matcher = PATTERN_PAGEREF.matcher(string = range2.text())).find()) break;
                String string2 = matcher.group(1);
                this.processPageref(hWPFDocument, element, field.secondSubrange(range), n, string2);
                return;
            }
            case 58: {
                if (!field.hasSeparator()) {
                    logger.log(5, new Object[]{range + " contains " + field + " with 'Embedded Object' but without separator mark"});
                    return;
                }
                CharacterRun characterRun = field.getMarkSeparatorCharacterRun(range);
                if (!characterRun.isOle2()) break;
                boolean bl = this.processOle2(hWPFDocument, characterRun, element);
                if (!bl) {
                    this.processCharacters(hWPFDocument, n, field.secondSubrange(range), element);
                }
                return;
            }
            case 83: {
                Range range3 = field.firstSubrange(range);
                CharacterRun characterRun = range3.getCharacterRun(range3.numCharacterRuns() - 1);
                String[] stringArray = characterRun.getDropDownListValues();
                Integer n2 = characterRun.getDropDownListDefaultItemIndex();
                if (stringArray == null || stringArray.length <= 0) break;
                this.processDropDownList(element, characterRun, stringArray, n2 == null ? -1 : n2);
                return;
            }
            case 88: {
                Range range4 = field.firstSubrange(range);
                if (range4 == null) break;
                String string = range4.text();
                Matcher matcher = PATTERN_HYPERLINK_EXTERNAL.matcher(string);
                if (matcher.matches()) {
                    String string3 = matcher.group(1);
                    this.processHyperlink(hWPFDocument, element, field.secondSubrange(range), n, string3);
                    return;
                }
                matcher.usePattern(PATTERN_HYPERLINK_LOCAL);
                if (!matcher.matches()) break;
                String string4 = matcher.group(1);
                Range range5 = null;
                String string5 = matcher.group(2);
                if (AbstractWordUtils.isNotEmpty(string5)) {
                    range5 = new Range(range4.getStartOffset() + matcher.start(2), range4.getStartOffset() + matcher.end(2), range4){

                        public String toString() {
                            return "Local hyperlink text";
                        }
                    };
                }
                this.processPageref(hWPFDocument, element, range5, n, string4);
                return;
            }
        }
        logger.log(5, new Object[]{range + " contains " + field + " with unsupported type or format"});
        this.processCharacters(hWPFDocument, n, field.secondSubrange(range), element);
    }

    protected abstract void processFootnoteAutonumbered(HWPFDocument var1, int var2, Element var3, Range var4);

    protected abstract void processHyperlink(HWPFDocumentCore var1, Element var2, Range var3, int var4, String var5);

    protected void processImage(Element element, boolean bl, Picture picture) {
        PicturesManager picturesManager = this.getPicturesManager();
        if (picturesManager != null) {
            int n = picture.getHorizontalScalingFactor();
            int n2 = picture.getVerticalScalingFactor();
            float f = n > 0 ? (float)(picture.getDxaGoal() * n / 1000) / 1440.0f : (float)picture.getDxaGoal() / 1440.0f;
            float f2 = n2 > 0 ? (float)(picture.getDyaGoal() * n2 / 1000) / 1440.0f : (float)picture.getDyaGoal() / 1440.0f;
            String string = picturesManager.savePicture(picture.getContent(), picture.suggestPictureType(), picture.suggestFullFileName(), f, f2);
            if (WordToFoUtils.isNotEmpty(string)) {
                this.processImage(element, bl, picture, string);
                return;
            }
        }
        this.processImageWithoutPicturesManager(element, bl, picture);
    }

    protected abstract void processImage(Element var1, boolean var2, Picture var3, String var4);

    @Internal
    protected abstract void processImageWithoutPicturesManager(Element var1, boolean var2, Picture var3);

    protected abstract void processLineBreak(Element var1, CharacterRun var2);

    protected void processNoteAnchor(HWPFDocument hWPFDocument, CharacterRun characterRun, Element element) {
        Notes notes = hWPFDocument.getFootnotes();
        int n = notes.getNoteIndexByAnchorPosition(characterRun.getStartOffset());
        if (n != -1) {
            Range range = hWPFDocument.getFootnoteRange();
            int n2 = range.getStartOffset();
            int n3 = notes.getNoteTextStartOffset(n);
            int n4 = notes.getNoteTextEndOffset(n);
            Range range2 = new Range(n2 + n3, n2 + n4, hWPFDocument);
            this.processFootnoteAutonumbered(hWPFDocument, n, element, range2);
            return;
        }
        notes = hWPFDocument.getEndnotes();
        n = notes.getNoteIndexByAnchorPosition(characterRun.getStartOffset());
        if (n != -1) {
            Range range = hWPFDocument.getEndnoteRange();
            int n5 = range.getStartOffset();
            int n6 = notes.getNoteTextStartOffset(n);
            int n7 = notes.getNoteTextEndOffset(n);
            Range range3 = new Range(n5 + n6, n5 + n7, hWPFDocument);
            this.processEndnoteAutonumbered(hWPFDocument, n, element, range3);
            return;
        }
    }

    private boolean processOle2(HWPFDocument hWPFDocument, CharacterRun characterRun, Element element) {
        Entry entry = hWPFDocument.getObjectsPool().getObjectById("_" + characterRun.getPicOffset());
        if (entry == null) {
            logger.log(5, "Referenced OLE2 object '", characterRun.getPicOffset(), "' not found in ObjectPool");
            return false;
        }
        try {
            return this.processOle2(hWPFDocument, element, entry);
        }
        catch (Exception exception) {
            logger.log(5, "Unable to convert internal OLE2 object '", characterRun.getPicOffset(), "': ", exception, exception);
            return false;
        }
    }

    protected boolean processOle2(HWPFDocument hWPFDocument, Element element, Entry entry) throws Exception {
        return false;
    }

    protected abstract void processPageBreak(HWPFDocumentCore var1, Element var2);

    protected abstract void processPageref(HWPFDocumentCore var1, Element var2, Range var3, int var4, String var5);

    protected abstract void processParagraph(HWPFDocumentCore var1, Element var2, int var3, Paragraph var4, String var5);

    protected void processParagraphes(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n) {
        int n2 = range.numParagraphs();
        for (int i = 0; i < n2; ++i) {
            Paragraph paragraph = range.getParagraph(i);
            if (paragraph.isInTable() && paragraph.getTableLevel() != n) {
                if (paragraph.getTableLevel() < n) {
                    throw new IllegalStateException("Trying to process table cell with higher level (" + paragraph.getTableLevel() + ") than current table level (" + n + ") as inner table part");
                }
                Table table = range.getTable(paragraph);
                this.processTable(hWPFDocumentCore, element, table);
                i += table.numParagraphs();
                --i;
                continue;
            }
            if (paragraph.text().equals("\f")) {
                this.processPageBreak(hWPFDocumentCore, element);
            }
            boolean bl = false;
            if (paragraph.isInList()) {
                try {
                    HWPFList hWPFList = paragraph.getList();
                    String string = AbstractWordUtils.getBulletText(this.numberingState, hWPFList, (char)paragraph.getIlvl());
                    this.processParagraph(hWPFDocumentCore, element, n, paragraph, string);
                    bl = true;
                }
                catch (Exception exception) {
                    this.log.log(5, new Object[]{"Can't process paragraph as list entry, will be processed without list information", exception});
                }
            }
            if (bl) continue;
            this.processParagraph(hWPFDocumentCore, element, n, paragraph, "");
        }
    }

    protected abstract void processSection(HWPFDocumentCore var1, Section var2, int var3);

    protected void processSingleSection(HWPFDocumentCore hWPFDocumentCore, Section section) {
        this.processSection(hWPFDocumentCore, section, 0);
    }

    protected void processSymbol(HWPFDocument hWPFDocument, CharacterRun characterRun, Element element) {
    }

    protected abstract void processTable(HWPFDocumentCore var1, Element var2, Table var3);

    public void setFontReplacer(FontReplacer fontReplacer) {
        this.fontReplacer = fontReplacer;
    }

    public void setPicturesManager(PicturesManager picturesManager) {
        this.picturesManager = picturesManager;
    }

    protected int tryDeadField(HWPFDocumentCore hWPFDocumentCore, Range range, int n, int n2, Element element) {
        int[] nArray = this.tryDeadField_lookupFieldSeparatorEnd(hWPFDocumentCore, range, n2);
        if (nArray == null) {
            return n2;
        }
        this.processDeadField(hWPFDocumentCore, element, range, n, n2, nArray[0], nArray[1]);
        return nArray[1];
    }

    private int[] tryDeadField_lookupFieldSeparatorEnd(HWPFDocumentCore hWPFDocumentCore, Range range, int n) {
        int n2 = -1;
        int n3 = -1;
        for (int i = n + 1; i < range.numCharacterRuns(); ++i) {
            CharacterRun characterRun = range.getCharacterRun(i);
            String string = characterRun.text();
            if (string.isEmpty()) continue;
            char c = string.charAt(0);
            if (c == '\u0013') {
                int[] nArray = this.tryDeadField_lookupFieldSeparatorEnd(hWPFDocumentCore, range, i);
                if (nArray == null) continue;
                i = nArray[1];
                continue;
            }
            if (c == '\u0014') {
                if (n2 != -1) {
                    return null;
                }
                n2 = i;
                continue;
            }
            if (c != '\u0015') continue;
            if (n3 != -1) {
                return null;
            }
            n3 = i;
            break;
        }
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        return new int[]{n2, n3};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Structure
    implements Comparable<Structure> {
        final int end;
        final int start;
        final Object structure;

        Structure(Bookmark bookmark) {
            this.start = bookmark.getStart();
            this.end = bookmark.getEnd();
            this.structure = bookmark;
        }

        Structure(DeadFieldBoundaries deadFieldBoundaries, int n, int n2) {
            this.start = n;
            this.end = n2;
            this.structure = deadFieldBoundaries;
        }

        Structure(Field field) {
            this.start = field.getFieldStartOffset();
            this.end = field.getFieldEndOffset();
            this.structure = field;
        }

        @Override
        public int compareTo(Structure structure) {
            return this.start < structure.start ? -1 : (this.start == structure.start ? 0 : 1);
        }

        public String toString() {
            return "Structure [" + this.start + "; " + this.end + "): " + this.structure.toString();
        }
    }

    private static class DeadFieldBoundaries {
        final int beginMark;
        final int endMark;
        final int separatorMark;

        public DeadFieldBoundaries(int n, int n2, int n3) {
            this.beginMark = n;
            this.separatorMark = n2;
            this.endMark = n3;
        }
    }
}

