/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf;

import ai2.org.apache.poi.POIDocument;
import ai2.org.apache.poi.hwpf.model.CHPBinTable;
import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.FontTable;
import ai2.org.apache.poi.hwpf.model.ListTables;
import ai2.org.apache.poi.hwpf.model.PAPBinTable;
import ai2.org.apache.poi.hwpf.model.SectionTable;
import ai2.org.apache.poi.hwpf.model.StyleSheet;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.usermodel.ObjectPoolImpl;
import ai2.org.apache.poi.hwpf.usermodel.ObjectsPool;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.Internal;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public abstract class HWPFDocumentCore
extends POIDocument {
    protected static final String STREAM_OBJECT_POOL = "ObjectPool";
    protected static final String STREAM_WORD_DOCUMENT = "WordDocument";
    protected ObjectPoolImpl _objectPool;
    protected FileInformationBlock _fib;
    protected StyleSheet _ss;
    protected CHPBinTable _cbt;
    protected PAPBinTable _pbt;
    protected SectionTable _st;
    protected FontTable _ft;
    protected ListTables _lt;
    protected byte[] _mainStream;

    protected HWPFDocumentCore() {
        super((DirectoryNode)null);
    }

    public static POIFSFileSystem verifyAndBuildPOIFS(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 6);
        byte[] byArray = new byte[6];
        pushbackInputStream.read(byArray);
        if (byArray[0] == 123 && byArray[1] == 92 && byArray[2] == 114 && byArray[3] == 116 && byArray[4] == 102) {
            throw new IllegalArgumentException("The document is really a RTF file");
        }
        if (byArray[0] == 37 && byArray[1] == 80 && byArray[2] == 68 && byArray[3] == 70) {
            throw new IllegalArgumentException("The document is really a PDF file");
        }
        pushbackInputStream.unread(byArray);
        return new POIFSFileSystem(pushbackInputStream);
    }

    public HWPFDocumentCore(InputStream inputStream) throws IOException {
        this(HWPFDocumentCore.verifyAndBuildPOIFS(inputStream));
    }

    public HWPFDocumentCore(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public HWPFDocumentCore(DirectoryNode directoryNode) throws IOException {
        super(directoryNode);
        DirectoryEntry directoryEntry;
        DocumentEntry documentEntry = (DocumentEntry)directoryNode.getEntry(STREAM_WORD_DOCUMENT);
        this._mainStream = new byte[documentEntry.getSize()];
        directoryNode.createDocumentInputStream(STREAM_WORD_DOCUMENT).read(this._mainStream);
        this._fib = new FileInformationBlock(this._mainStream);
        try {
            directoryEntry = (DirectoryEntry)directoryNode.getEntry(STREAM_OBJECT_POOL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            directoryEntry = null;
        }
        this._objectPool = new ObjectPoolImpl(directoryEntry);
    }

    public abstract Range getRange();

    public abstract Range getOverallRange();

    public String getDocumentText() {
        return this.getText().toString();
    }

    @Internal
    public abstract StringBuilder getText();

    public CHPBinTable getCharacterTable() {
        return this._cbt;
    }

    public PAPBinTable getParagraphTable() {
        return this._pbt;
    }

    public SectionTable getSectionTable() {
        return this._st;
    }

    public StyleSheet getStyleSheet() {
        return this._ss;
    }

    public ListTables getListTables() {
        return this._lt;
    }

    public FontTable getFontTable() {
        return this._ft;
    }

    public FileInformationBlock getFileInformationBlock() {
        return this._fib;
    }

    public ObjectsPool getObjectsPool() {
        return this._objectPool;
    }

    public abstract TextPieceTable getTextTable();
}

