/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.usermodel.FontDetails;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

final class StaticFontMetrics {
    private static Properties fontMetricsProps;
    private static Map<String, FontDetails> fontDetailsMap;

    StaticFontMetrics() {
    }

    public static FontDetails getFontDetails(Font font) {
        Object object;
        String string;
        Object object2;
        if (fontMetricsProps == null) {
            object2 = null;
            try {
                fontMetricsProps = new Properties();
                string = null;
                try {
                    string = System.getProperty("font.metrics.filename");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (string != null) {
                    object = new File(string);
                    if (!((File)object).exists()) {
                        throw new FileNotFoundException("font_metrics.properties not found at path " + ((File)object).getAbsolutePath());
                    }
                    object2 = new FileInputStream((File)object);
                } else {
                    object2 = FontDetails.class.getResourceAsStream("/font_metrics.properties");
                    if (object2 == null) {
                        throw new FileNotFoundException("font_metrics.properties not found in classpath");
                    }
                }
                fontMetricsProps.load((InputStream)object2);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not load font metrics: " + iOException.getMessage());
            }
            finally {
                if (object2 != null) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        object2 = font.getName();
        string = "";
        if (font.isPlain()) {
            string = string + "plain";
        }
        if (font.isBold()) {
            string = string + "bold";
        }
        if (font.isItalic()) {
            string = string + "italic";
        }
        if (fontMetricsProps.get(FontDetails.buildFontHeightProperty((String)object2)) == null && fontMetricsProps.get(FontDetails.buildFontHeightProperty((String)object2 + "." + string)) != null) {
            object2 = (String)object2 + "." + string;
        }
        if (fontDetailsMap.get(object2) == null) {
            object = FontDetails.create((String)object2, fontMetricsProps);
            fontDetailsMap.put((String)object2, (FontDetails)object);
            return object;
        }
        return fontDetailsMap.get(object2);
    }

    static {
        fontDetailsMap = new HashMap<String, FontDetails>();
    }
}

