/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherBoolProperty;
import ai2.org.apache.poi.ddf.EscherClientDataRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherRGBProperty;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherShapePathProperty;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherTextboxRecord;
import ai2.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai2.org.apache.poi.hssf.record.EndSubRecord;
import ai2.org.apache.poi.hssf.record.EscherAggregate;
import ai2.org.apache.poi.hssf.record.ObjRecord;
import ai2.org.apache.poi.hssf.record.TextObjectRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai2.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai2.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai2.org.apache.poi.hssf.usermodel.HSSFShape;
import ai2.org.apache.poi.ss.usermodel.RichTextString;

public class HSSFSimpleShape
extends HSSFShape {
    public static final short OBJECT_TYPE_LINE = 20;
    public static final short OBJECT_TYPE_RECTANGLE = 1;
    public static final short OBJECT_TYPE_OVAL = 3;
    public static final short OBJECT_TYPE_ARC = 19;
    public static final short OBJECT_TYPE_PICTURE = 75;
    public static final short OBJECT_TYPE_COMBO_BOX = 201;
    public static final short OBJECT_TYPE_COMMENT = 202;
    public static final short OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING = 30;
    public static final int WRAP_SQUARE = 0;
    public static final int WRAP_BY_POINTS = 1;
    public static final int WRAP_NONE = 2;
    private TextObjectRecord _textObjectRecord;

    public HSSFSimpleShape(EscherContainerRecord escherContainerRecord, ObjRecord objRecord, TextObjectRecord textObjectRecord) {
        super(escherContainerRecord, objRecord);
        this._textObjectRecord = textObjectRecord;
    }

    public HSSFSimpleShape(EscherContainerRecord escherContainerRecord, ObjRecord objRecord) {
        super(escherContainerRecord, objRecord);
    }

    public HSSFSimpleShape(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
        this._textObjectRecord = this.createTextObjRecord();
    }

    protected TextObjectRecord getTextObjectRecord() {
        return this._textObjectRecord;
    }

    protected TextObjectRecord createTextObjRecord() {
        TextObjectRecord textObjectRecord = new TextObjectRecord();
        textObjectRecord.setHorizontalTextAlignment(2);
        textObjectRecord.setVerticalTextAlignment(2);
        textObjectRecord.setTextLocked(true);
        textObjectRecord.setTextOrientation(0);
        textObjectRecord.setStr(new HSSFRichTextString(""));
        return textObjectRecord;
    }

    protected EscherContainerRecord createSpContainer() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        escherContainerRecord.setRecordId((short)-4092);
        escherContainerRecord.setOptions((short)15);
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        escherSpRecord.setRecordId((short)-4086);
        escherSpRecord.setFlags(2560);
        escherSpRecord.setVersion((short)2);
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        escherClientDataRecord.setRecordId((short)-4079);
        escherClientDataRecord.setOptions((short)0);
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(462, 0));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(511, 524296));
        escherOptRecord.setEscherProperty(new EscherRGBProperty(385, 0x8000009));
        escherOptRecord.setEscherProperty(new EscherRGBProperty(448, 0x8000040));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(447, 65536));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(511, 524296));
        escherOptRecord.setEscherProperty(new EscherShapePathProperty(324, 4));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(959, 524288));
        escherOptRecord.setRecordId((short)-4085);
        EscherTextboxRecord escherTextboxRecord = new EscherTextboxRecord();
        escherTextboxRecord.setRecordId((short)-4083);
        escherTextboxRecord.setOptions((short)0);
        escherContainerRecord.addChildRecord(escherSpRecord);
        escherContainerRecord.addChildRecord(escherOptRecord);
        escherContainerRecord.addChildRecord(this.getAnchor().getEscherAnchor());
        escherContainerRecord.addChildRecord(escherClientDataRecord);
        escherContainerRecord.addChildRecord(escherTextboxRecord);
        return escherContainerRecord;
    }

    protected ObjRecord createObjRecord() {
        ObjRecord objRecord = new ObjRecord();
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.setLocked(true);
        commonObjectDataSubRecord.setPrintable(true);
        commonObjectDataSubRecord.setAutofill(true);
        commonObjectDataSubRecord.setAutoline(true);
        EndSubRecord endSubRecord = new EndSubRecord();
        objRecord.addSubRecord(commonObjectDataSubRecord);
        objRecord.addSubRecord(endSubRecord);
        return objRecord;
    }

    protected void afterRemove(HSSFPatriarch hSSFPatriarch) {
        hSSFPatriarch._getBoundAggregate().removeShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079));
        if (null != this.getEscherContainer().getChildById((short)-4083)) {
            hSSFPatriarch._getBoundAggregate().removeShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4083));
        }
    }

    public HSSFRichTextString getString() {
        return this._textObjectRecord.getStr();
    }

    public void setString(RichTextString richTextString) {
        if (this.getShapeType() == 0 || this.getShapeType() == 20) {
            throw new IllegalStateException("Cannot set text for shape type: " + this.getShapeType());
        }
        HSSFRichTextString hSSFRichTextString = (HSSFRichTextString)richTextString;
        if (hSSFRichTextString.numFormattingRuns() == 0) {
            hSSFRichTextString.applyFont((short)0);
        }
        TextObjectRecord textObjectRecord = this.getOrCreateTextObjRecord();
        textObjectRecord.setStr(hSSFRichTextString);
        if (richTextString.getString() != null) {
            this.setPropertyValue(new EscherSimpleProperty(128, richTextString.getString().hashCode()));
        }
    }

    void afterInsert(HSSFPatriarch hSSFPatriarch) {
        EscherAggregate escherAggregate = hSSFPatriarch._getBoundAggregate();
        escherAggregate.associateShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079), this.getObjRecord());
        if (null != this.getTextObjectRecord()) {
            escherAggregate.associateShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4083), this.getTextObjectRecord());
        }
    }

    protected HSSFShape cloneShape() {
        TextObjectRecord textObjectRecord = null;
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        byte[] byArray = this.getEscherContainer().serialize();
        escherContainerRecord.fillFields(byArray, 0, new DefaultEscherRecordFactory());
        ObjRecord objRecord = (ObjRecord)this.getObjRecord().cloneViaReserialise();
        if (this.getTextObjectRecord() != null && this.getString() != null && null != this.getString().getString()) {
            textObjectRecord = (TextObjectRecord)this.getTextObjectRecord().cloneViaReserialise();
        }
        return new HSSFSimpleShape(escherContainerRecord, objRecord, textObjectRecord);
    }

    public int getShapeType() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherContainer().getChildById((short)-4086);
        return escherSpRecord.getShapeType();
    }

    public int getWrapText() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(133);
        return null == escherSimpleProperty ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public void setWrapText(int n) {
        this.setPropertyValue(new EscherSimpleProperty(133, false, false, n));
    }

    public void setShapeType(int n) {
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)this.getObjRecord().getSubRecords().get(0);
        commonObjectDataSubRecord.setObjectType((short)30);
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherContainer().getChildById((short)-4086);
        escherSpRecord.setShapeType((short)n);
    }

    private TextObjectRecord getOrCreateTextObjRecord() {
        EscherTextboxRecord escherTextboxRecord;
        if (this.getTextObjectRecord() == null) {
            this._textObjectRecord = this.createTextObjRecord();
        }
        if (null == (escherTextboxRecord = (EscherTextboxRecord)this.getEscherContainer().getChildById((short)-4083))) {
            escherTextboxRecord = new EscherTextboxRecord();
            escherTextboxRecord.setRecordId((short)-4083);
            escherTextboxRecord.setOptions((short)0);
            this.getEscherContainer().addChildRecord(escherTextboxRecord);
            this.getPatriarch()._getBoundAggregate().associateShapeToObjRecord(escherTextboxRecord, this._textObjectRecord);
        }
        return this._textObjectRecord;
    }
}

