/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherBoolProperty;
import ai2.org.apache.poi.ddf.EscherChildAnchorRecord;
import ai2.org.apache.poi.ddf.EscherClientAnchorRecord;
import ai2.org.apache.poi.ddf.EscherClientDataRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherSpgrRecord;
import ai2.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai2.org.apache.poi.hssf.record.EndSubRecord;
import ai2.org.apache.poi.hssf.record.EscherAggregate;
import ai2.org.apache.poi.hssf.record.GroupMarkerSubRecord;
import ai2.org.apache.poi.hssf.record.ObjRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai2.org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import ai2.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai2.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai2.org.apache.poi.hssf.usermodel.HSSFPicture;
import ai2.org.apache.poi.hssf.usermodel.HSSFPolygon;
import ai2.org.apache.poi.hssf.usermodel.HSSFShape;
import ai2.org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import ai2.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import ai2.org.apache.poi.hssf.usermodel.HSSFTextbox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSSFShapeGroup
extends HSSFShape
implements HSSFShapeContainer {
    private final List<HSSFShape> shapes = new ArrayList<HSSFShape>();
    private EscherSpgrRecord _spgrRecord;

    public HSSFShapeGroup(EscherContainerRecord escherContainerRecord, ObjRecord objRecord) {
        super(escherContainerRecord, objRecord);
        EscherContainerRecord escherContainerRecord2 = escherContainerRecord.getChildContainers().get(0);
        this._spgrRecord = (EscherSpgrRecord)escherContainerRecord2.getChild(0);
        for (EscherRecord escherRecord : escherContainerRecord2.getChildRecords()) {
            switch (escherRecord.getRecordId()) {
                case -4087: {
                    break;
                }
                case -4080: {
                    this.anchor = new HSSFClientAnchor((EscherClientAnchorRecord)escherRecord);
                    break;
                }
                case -4081: {
                    this.anchor = new HSSFChildAnchor((EscherChildAnchorRecord)escherRecord);
                }
            }
        }
    }

    public HSSFShapeGroup(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
        this._spgrRecord = (EscherSpgrRecord)((EscherContainerRecord)this.getEscherContainer().getChild(0)).getChildById((short)-4087);
    }

    @Override
    protected EscherContainerRecord createSpContainer() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        EscherContainerRecord escherContainerRecord2 = new EscherContainerRecord();
        EscherSpgrRecord escherSpgrRecord = new EscherSpgrRecord();
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        escherContainerRecord.setRecordId((short)-4093);
        escherContainerRecord.setOptions((short)15);
        escherContainerRecord2.setRecordId((short)-4092);
        escherContainerRecord2.setOptions((short)15);
        escherSpgrRecord.setRecordId((short)-4087);
        escherSpgrRecord.setOptions((short)1);
        escherSpgrRecord.setRectX1(0);
        escherSpgrRecord.setRectY1(0);
        escherSpgrRecord.setRectX2(1023);
        escherSpgrRecord.setRectY2(255);
        escherSpRecord.setRecordId((short)-4086);
        escherSpRecord.setOptions((short)2);
        if (this.getAnchor() instanceof HSSFClientAnchor) {
            escherSpRecord.setFlags(513);
        } else {
            escherSpRecord.setFlags(515);
        }
        escherOptRecord.setRecordId((short)-4085);
        escherOptRecord.setOptions((short)35);
        escherOptRecord.addEscherProperty(new EscherBoolProperty(127, 262148));
        escherOptRecord.addEscherProperty(new EscherBoolProperty(959, 524288));
        EscherRecord escherRecord = this.getAnchor().getEscherAnchor();
        escherClientDataRecord.setRecordId((short)-4079);
        escherClientDataRecord.setOptions((short)0);
        escherContainerRecord.addChildRecord(escherContainerRecord2);
        escherContainerRecord2.addChildRecord(escherSpgrRecord);
        escherContainerRecord2.addChildRecord(escherSpRecord);
        escherContainerRecord2.addChildRecord(escherOptRecord);
        escherContainerRecord2.addChildRecord(escherRecord);
        escherContainerRecord2.addChildRecord(escherClientDataRecord);
        return escherContainerRecord;
    }

    @Override
    protected ObjRecord createObjRecord() {
        ObjRecord objRecord = new ObjRecord();
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.setObjectType((short)0);
        commonObjectDataSubRecord.setLocked(true);
        commonObjectDataSubRecord.setPrintable(true);
        commonObjectDataSubRecord.setAutofill(true);
        commonObjectDataSubRecord.setAutoline(true);
        GroupMarkerSubRecord groupMarkerSubRecord = new GroupMarkerSubRecord();
        EndSubRecord endSubRecord = new EndSubRecord();
        objRecord.addSubRecord(commonObjectDataSubRecord);
        objRecord.addSubRecord(groupMarkerSubRecord);
        objRecord.addSubRecord(endSubRecord);
        return objRecord;
    }

    @Override
    protected void afterRemove(HSSFPatriarch hSSFPatriarch) {
        hSSFPatriarch._getBoundAggregate().removeShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildContainers().get(0).getChildById((short)-4079));
        for (int i = 0; i < this.shapes.size(); ++i) {
            HSSFShape hSSFShape = this.shapes.get(i);
            this.removeShape(hSSFShape);
            hSSFShape.afterRemove(this.getPatriarch());
        }
        this.shapes.clear();
    }

    private void onCreate(HSSFShape hSSFShape) {
        if (this.getPatriarch() != null) {
            EscherContainerRecord escherContainerRecord = hSSFShape.getEscherContainer();
            int n = this.getPatriarch().newShapeId();
            hSSFShape.setShapeId(n);
            this.getEscherContainer().addChildRecord(escherContainerRecord);
            hSSFShape.afterInsert(this.getPatriarch());
            EscherSpRecord escherSpRecord = hSSFShape instanceof HSSFShapeGroup ? (EscherSpRecord)hSSFShape.getEscherContainer().getChildContainers().get(0).getChildById((short)-4086) : (EscherSpRecord)hSSFShape.getEscherContainer().getChildById((short)-4086);
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 2);
        }
    }

    public HSSFShapeGroup createGroup(HSSFChildAnchor hSSFChildAnchor) {
        HSSFShapeGroup hSSFShapeGroup = new HSSFShapeGroup(this, hSSFChildAnchor);
        hSSFShapeGroup.setParent(this);
        hSSFShapeGroup.setAnchor(hSSFChildAnchor);
        this.shapes.add(hSSFShapeGroup);
        this.onCreate(hSSFShapeGroup);
        return hSSFShapeGroup;
    }

    @Override
    public void addShape(HSSFShape hSSFShape) {
        hSSFShape.setPatriarch(this.getPatriarch());
        hSSFShape.setParent(this);
        this.shapes.add(hSSFShape);
    }

    public HSSFSimpleShape createShape(HSSFChildAnchor hSSFChildAnchor) {
        HSSFSimpleShape hSSFSimpleShape = new HSSFSimpleShape(this, hSSFChildAnchor);
        hSSFSimpleShape.setParent(this);
        hSSFSimpleShape.setAnchor(hSSFChildAnchor);
        this.shapes.add(hSSFSimpleShape);
        this.onCreate(hSSFSimpleShape);
        EscherSpRecord escherSpRecord = (EscherSpRecord)hSSFSimpleShape.getEscherContainer().getChildById((short)-4086);
        if (hSSFSimpleShape.getAnchor().isHorizontallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x40);
        }
        if (hSSFSimpleShape.getAnchor().isVerticallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x80);
        }
        return hSSFSimpleShape;
    }

    public HSSFTextbox createTextbox(HSSFChildAnchor hSSFChildAnchor) {
        HSSFTextbox hSSFTextbox = new HSSFTextbox(this, hSSFChildAnchor);
        hSSFTextbox.setParent(this);
        hSSFTextbox.setAnchor(hSSFChildAnchor);
        this.shapes.add(hSSFTextbox);
        this.onCreate(hSSFTextbox);
        return hSSFTextbox;
    }

    public HSSFPolygon createPolygon(HSSFChildAnchor hSSFChildAnchor) {
        HSSFPolygon hSSFPolygon = new HSSFPolygon(this, hSSFChildAnchor);
        hSSFPolygon.setParent(this);
        hSSFPolygon.setAnchor(hSSFChildAnchor);
        this.shapes.add(hSSFPolygon);
        this.onCreate(hSSFPolygon);
        return hSSFPolygon;
    }

    public HSSFPicture createPicture(HSSFChildAnchor hSSFChildAnchor, int n) {
        HSSFPicture hSSFPicture = new HSSFPicture(this, hSSFChildAnchor);
        hSSFPicture.setParent(this);
        hSSFPicture.setAnchor(hSSFChildAnchor);
        hSSFPicture.setPictureIndex(n);
        this.shapes.add(hSSFPicture);
        this.onCreate(hSSFPicture);
        EscherSpRecord escherSpRecord = (EscherSpRecord)hSSFPicture.getEscherContainer().getChildById((short)-4086);
        if (hSSFPicture.getAnchor().isHorizontallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x40);
        }
        if (hSSFPicture.getAnchor().isVerticallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x80);
        }
        return hSSFPicture;
    }

    @Override
    public List<HSSFShape> getChildren() {
        return Collections.unmodifiableList(this.shapes);
    }

    @Override
    public void setCoordinates(int n, int n2, int n3, int n4) {
        this._spgrRecord.setRectX1(n);
        this._spgrRecord.setRectX2(n3);
        this._spgrRecord.setRectY1(n2);
        this._spgrRecord.setRectY2(n4);
    }

    @Override
    public void clear() {
        ArrayList<HSSFShape> arrayList = new ArrayList<HSSFShape>(this.shapes);
        for (HSSFShape hSSFShape : arrayList) {
            this.removeShape(hSSFShape);
        }
    }

    @Override
    public int getX1() {
        return this._spgrRecord.getRectX1();
    }

    @Override
    public int getY1() {
        return this._spgrRecord.getRectY1();
    }

    @Override
    public int getX2() {
        return this._spgrRecord.getRectX2();
    }

    @Override
    public int getY2() {
        return this._spgrRecord.getRectY2();
    }

    @Override
    public int countOfAllChildren() {
        int n = this.shapes.size();
        for (HSSFShape hSSFShape : this.shapes) {
            n += hSSFShape.countOfAllChildren();
        }
        return n;
    }

    @Override
    void afterInsert(HSSFPatriarch hSSFPatriarch) {
        EscherAggregate escherAggregate = hSSFPatriarch._getBoundAggregate();
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.getEscherContainer().getChildById((short)-4092);
        escherAggregate.associateShapeToObjRecord((EscherRecord)escherContainerRecord.getChildById((short)-4079), this.getObjRecord());
    }

    @Override
    void setShapeId(int n) {
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.getEscherContainer().getChildById((short)-4092);
        EscherSpRecord escherSpRecord = (EscherSpRecord)escherContainerRecord.getChildById((short)-4086);
        escherSpRecord.setShapeId(n);
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)this.getObjRecord().getSubRecords().get(0);
        commonObjectDataSubRecord.setObjectId((short)(n % 1024));
    }

    @Override
    int getShapeId() {
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.getEscherContainer().getChildById((short)-4092);
        return ((EscherSpRecord)escherContainerRecord.getChildById((short)-4086)).getShapeId();
    }

    @Override
    protected HSSFShape cloneShape() {
        throw new IllegalStateException("Use method cloneShape(HSSFPatriarch patriarch)");
    }

    protected HSSFShape cloneShape(HSSFPatriarch hSSFPatriarch) {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        escherContainerRecord.setRecordId((short)-4093);
        escherContainerRecord.setOptions((short)15);
        EscherContainerRecord escherContainerRecord2 = new EscherContainerRecord();
        EscherContainerRecord escherContainerRecord3 = (EscherContainerRecord)this.getEscherContainer().getChildById((short)-4092);
        byte[] byArray = escherContainerRecord3.serialize();
        escherContainerRecord2.fillFields(byArray, 0, new DefaultEscherRecordFactory());
        escherContainerRecord.addChildRecord(escherContainerRecord2);
        ObjRecord objRecord = null;
        if (null != this.getObjRecord()) {
            objRecord = (ObjRecord)this.getObjRecord().cloneViaReserialise();
        }
        HSSFShapeGroup hSSFShapeGroup = new HSSFShapeGroup(escherContainerRecord, objRecord);
        hSSFShapeGroup.setPatriarch(hSSFPatriarch);
        for (HSSFShape hSSFShape : this.getChildren()) {
            HSSFShape hSSFShape2 = hSSFShape instanceof HSSFShapeGroup ? ((HSSFShapeGroup)hSSFShape).cloneShape(hSSFPatriarch) : hSSFShape.cloneShape();
            hSSFShapeGroup.addShape(hSSFShape2);
            hSSFShapeGroup.onCreate(hSSFShape2);
        }
        return hSSFShapeGroup;
    }

    @Override
    public boolean removeShape(HSSFShape hSSFShape) {
        boolean bl = this.getEscherContainer().removeChildRecord(hSSFShape.getEscherContainer());
        if (bl) {
            hSSFShape.afterRemove(this.getPatriarch());
            this.shapes.remove(hSSFShape);
        }
        return bl;
    }

    @Override
    public Iterator<HSSFShape> iterator() {
        return this.shapes.iterator();
    }
}

