/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai2.org.apache.poi.hssf.record.FontRecord;
import ai2.org.apache.poi.hssf.record.common.UnicodeString;
import ai2.org.apache.poi.hssf.usermodel.HSSFCell;
import ai2.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai2.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Row;
import java.util.HashSet;
import java.util.Iterator;

public class HSSFOptimiser {
    public static void optimiseFonts(HSSFWorkbook hSSFWorkbook) {
        int n;
        int n2;
        int n3;
        short[] sArray = new short[hSSFWorkbook.getWorkbook().getNumberOfFontRecords() + 1];
        boolean[] blArray = new boolean[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)i;
            blArray[i] = false;
        }
        FontRecord[] fontRecordArray = new FontRecord[sArray.length];
        for (n3 = 0; n3 < sArray.length; ++n3) {
            if (n3 == 4) continue;
            fontRecordArray[n3] = hSSFWorkbook.getWorkbook().getFontRecordAt(n3);
        }
        for (n3 = 5; n3 < sArray.length; ++n3) {
            n2 = -1;
            for (n = 0; n < n3 && n2 == -1; ++n) {
                FontRecord fontRecord;
                if (n == 4 || !(fontRecord = hSSFWorkbook.getWorkbook().getFontRecordAt(n)).sameProperties(fontRecordArray[n3])) continue;
                n2 = n;
            }
            if (n2 == -1) continue;
            sArray[n3] = (short)n2;
            blArray[n3] = true;
        }
        for (n3 = 5; n3 < sArray.length; ++n3) {
            n = n2 = sArray[n3];
            for (int i = 0; i < n2; ++i) {
                if (!blArray[i]) continue;
                n = (short)(n - 1);
            }
            sArray[n3] = n;
        }
        for (n3 = 5; n3 < sArray.length; ++n3) {
            if (!blArray[n3]) continue;
            hSSFWorkbook.getWorkbook().removeFontRecord(fontRecordArray[n3]);
        }
        hSSFWorkbook.resetFontCache();
        for (n3 = 0; n3 < hSSFWorkbook.getWorkbook().getNumExFormats(); ++n3) {
            ExtendedFormatRecord extendedFormatRecord = hSSFWorkbook.getWorkbook().getExFormatAt(n3);
            extendedFormatRecord.setFontIndex(sArray[extendedFormatRecord.getFontIndex()]);
        }
        HashSet<UnicodeString> hashSet = new HashSet<UnicodeString>();
        for (int i = 0; i < hSSFWorkbook.getNumberOfSheets(); ++i) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i);
            for (Row row : hSSFSheet) {
                for (Cell cell : row) {
                    HSSFRichTextString hSSFRichTextString;
                    UnicodeString unicodeString;
                    if (cell.getCellType() != 1 || hashSet.contains(unicodeString = (hSSFRichTextString = (HSSFRichTextString)cell.getRichStringCellValue()).getRawUnicodeString())) continue;
                    for (short s = 5; s < sArray.length; s = (short)((short)(s + 1))) {
                        if (s == sArray[s]) continue;
                        unicodeString.swapFontUse(s, sArray[s]);
                    }
                    hashSet.add(unicodeString);
                }
            }
        }
    }

    public static void optimiseCellStyles(HSSFWorkbook hSSFWorkbook) {
        int n;
        Object object;
        int n2;
        short[] sArray = new short[hSSFWorkbook.getWorkbook().getNumExFormats()];
        boolean[] blArray = new boolean[sArray.length];
        boolean[] blArray2 = new boolean[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            blArray[i] = false;
            sArray[i] = (short)i;
            blArray2[i] = false;
        }
        ExtendedFormatRecord[] extendedFormatRecordArray = new ExtendedFormatRecord[sArray.length];
        for (n2 = 0; n2 < sArray.length; ++n2) {
            extendedFormatRecordArray[n2] = hSSFWorkbook.getWorkbook().getExFormatAt(n2);
        }
        for (n2 = 21; n2 < sArray.length; ++n2) {
            int n3 = -1;
            for (int i = 0; i < n2 && n3 == -1; ++i) {
                Object object2 = hSSFWorkbook.getWorkbook().getExFormatAt(i);
                if (!((ExtendedFormatRecord)object2).equals(extendedFormatRecordArray[n2])) continue;
                n3 = i;
            }
            if (n3 != -1) {
                sArray[n2] = (short)n3;
                blArray2[n2] = true;
            }
            if (n3 == -1) continue;
            blArray[n3] = true;
        }
        for (n2 = 0; n2 < hSSFWorkbook.getNumberOfSheets(); ++n2) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(n2);
            for (Object object2 : hSSFSheet) {
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object object3 = (Cell)iterator.next();
                    object = (HSSFCell)object3;
                    short s = ((HSSFCell)object).getCellValueRecord().getXFIndex();
                    blArray[s] = true;
                }
            }
        }
        for (n2 = 21; n2 < blArray.length; ++n2) {
            if (blArray[n2]) continue;
            blArray2[n2] = true;
            sArray[n2] = 0;
        }
        for (n2 = 21; n2 < sArray.length; ++n2) {
            int n4;
            int n5 = n4 = sArray[n2];
            for (int i = 0; i < n4; ++i) {
                if (!blArray2[i]) continue;
                n5 = (short)(n5 - 1);
            }
            sArray[n2] = n5;
        }
        n2 = sArray.length;
        int n6 = 0;
        for (n = 21; n < n2; ++n) {
            if (!blArray2[n + n6]) continue;
            hSSFWorkbook.getWorkbook().removeExFormatRecord(n);
            --n;
            --n2;
            ++n6;
        }
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(n);
            for (Object object3 : hSSFSheet) {
                object = object3.iterator();
                while (object.hasNext()) {
                    Cell cell = (Cell)object.next();
                    HSSFCell hSSFCell = (HSSFCell)cell;
                    short s = hSSFCell.getCellValueRecord().getXFIndex();
                    HSSFCellStyle hSSFCellStyle = hSSFWorkbook.getCellStyleAt(sArray[s]);
                    hSSFCell.setCellStyle(hSSFCellStyle);
                }
            }
        }
    }
}

