/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.model.InternalWorkbook;
import ai2.org.apache.poi.hssf.record.NameRecord;
import ai2.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import ai2.org.apache.poi.hssf.usermodel.HSSFCell;
import ai2.org.apache.poi.hssf.usermodel.HSSFEvaluationCell;
import ai2.org.apache.poi.hssf.usermodel.HSSFEvaluationSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.EvaluationName;
import ai2.org.apache.poi.ss.formula.EvaluationSheet;
import ai2.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai2.org.apache.poi.ss.formula.FormulaParsingWorkbook;
import ai2.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import ai2.org.apache.poi.ss.formula.SheetIdentifier;
import ai2.org.apache.poi.ss.formula.SheetRangeIdentifier;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.NamePtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public final class HSSFEvaluationWorkbook
implements FormulaRenderingWorkbook,
EvaluationWorkbook,
FormulaParsingWorkbook {
    private static POILogger logger = POILogFactory.getLogger(HSSFEvaluationWorkbook.class);
    private final HSSFWorkbook _uBook;
    private final InternalWorkbook _iBook;

    public static HSSFEvaluationWorkbook create(HSSFWorkbook hSSFWorkbook) {
        if (hSSFWorkbook == null) {
            return null;
        }
        return new HSSFEvaluationWorkbook(hSSFWorkbook);
    }

    private HSSFEvaluationWorkbook(HSSFWorkbook hSSFWorkbook) {
        this._uBook = hSSFWorkbook;
        this._iBook = hSSFWorkbook.getWorkbook();
    }

    public int getExternalSheetIndex(String string) {
        int n = this._uBook.getSheetIndex(string);
        return this._iBook.checkExternSheet(n);
    }

    public int getExternalSheetIndex(String string, String string2) {
        return this._iBook.getExternalSheetIndex(string, string2);
    }

    public Ptg get3DReferencePtg(CellReference cellReference, SheetIdentifier sheetIdentifier) {
        int n = this.getSheetExtIx(sheetIdentifier);
        return new Ref3DPtg(cellReference, n);
    }

    public Ptg get3DReferencePtg(AreaReference areaReference, SheetIdentifier sheetIdentifier) {
        int n = this.getSheetExtIx(sheetIdentifier);
        return new Area3DPtg(areaReference, n);
    }

    public NameXPtg getNameXPtg(String string, SheetIdentifier sheetIdentifier) {
        int n = this.getSheetExtIx(sheetIdentifier);
        return this._iBook.getNameXPtg(string, n, this._uBook.getUDFFinder());
    }

    public EvaluationName getName(String string, int n) {
        for (int i = 0; i < this._iBook.getNumNames(); ++i) {
            NameRecord nameRecord = this._iBook.getNameRecord(i);
            if (nameRecord.getSheetNumber() != n + 1 || !string.equalsIgnoreCase(nameRecord.getNameText())) continue;
            return new Name(nameRecord, i);
        }
        return n == -1 ? null : this.getName(string, -1);
    }

    public int getSheetIndex(EvaluationSheet evaluationSheet) {
        HSSFSheet hSSFSheet = ((HSSFEvaluationSheet)evaluationSheet).getHSSFSheet();
        return this._uBook.getSheetIndex(hSSFSheet);
    }

    public int getSheetIndex(String string) {
        return this._uBook.getSheetIndex(string);
    }

    public String getSheetName(int n) {
        return this._uBook.getSheetName(n);
    }

    public EvaluationSheet getSheet(int n) {
        return new HSSFEvaluationSheet(this._uBook.getSheetAt(n));
    }

    public int convertFromExternSheetIndex(int n) {
        return this._iBook.getFirstSheetIndexFromExternSheetIndex(n);
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(int n) {
        EvaluationWorkbook.ExternalSheet externalSheet = this._iBook.getExternalSheet(n);
        if (externalSheet == null) {
            int n2 = this.convertFromExternSheetIndex(n);
            if (n2 == -1) {
                return null;
            }
            if (n2 == -2) {
                return null;
            }
            String string = this.getSheetName(n2);
            int n3 = this._iBook.getLastSheetIndexFromExternSheetIndex(n);
            if (n3 == n2) {
                externalSheet = new EvaluationWorkbook.ExternalSheet(null, string);
            } else {
                String string2 = this.getSheetName(n3);
                externalSheet = new EvaluationWorkbook.ExternalSheetRange(null, string, string2);
            }
        }
        return externalSheet;
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(String string, String string2, int n) {
        throw new IllegalStateException("XSSF-style external references are not supported for HSSF");
    }

    public EvaluationWorkbook.ExternalName getExternalName(int n, int n2) {
        return this._iBook.getExternalName(n, n2);
    }

    public EvaluationWorkbook.ExternalName getExternalName(String string, String string2, int n) {
        throw new IllegalStateException("XSSF-style external names are not supported for HSSF");
    }

    public String resolveNameXText(NameXPtg nameXPtg) {
        return this._iBook.resolveNameXText(nameXPtg.getSheetRefIndex(), nameXPtg.getNameIndex());
    }

    public String getSheetFirstNameByExternSheet(int n) {
        return this._iBook.findSheetFirstNameFromExternSheet(n);
    }

    public String getSheetLastNameByExternSheet(int n) {
        return this._iBook.findSheetLastNameFromExternSheet(n);
    }

    public String getNameText(NamePtg namePtg) {
        return this._iBook.getNameRecord(namePtg.getIndex()).getNameText();
    }

    public EvaluationName getName(NamePtg namePtg) {
        int n = namePtg.getIndex();
        return new Name(this._iBook.getNameRecord(n), n);
    }

    public Ptg[] getFormulaTokens(EvaluationCell evaluationCell) {
        HSSFCell hSSFCell = ((HSSFEvaluationCell)evaluationCell).getHSSFCell();
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)hSSFCell.getCellValueRecord();
        return formulaRecordAggregate.getFormulaTokens();
    }

    public UDFFinder getUDFFinder() {
        return this._uBook.getUDFFinder();
    }

    private int getSheetExtIx(SheetIdentifier sheetIdentifier) {
        int n;
        if (sheetIdentifier == null) {
            n = -1;
        } else {
            String string;
            String string2 = sheetIdentifier.getBookName();
            String string3 = string = sheetIdentifier.getSheetIdentifier().getName();
            if (sheetIdentifier instanceof SheetRangeIdentifier) {
                string3 = ((SheetRangeIdentifier)sheetIdentifier).getLastSheetIdentifier().getName();
            }
            if (string2 == null) {
                int n2 = this._uBook.getSheetIndex(string);
                int n3 = this._uBook.getSheetIndex(string3);
                n = this._iBook.checkExternSheet(n2, n3);
            } else {
                n = this._iBook.getExternalSheetIndex(string2, string, string3);
            }
        }
        return n;
    }

    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL97;
    }

    private static final class Name
    implements EvaluationName {
        private final NameRecord _nameRecord;
        private final int _index;

        public Name(NameRecord nameRecord, int n) {
            this._nameRecord = nameRecord;
            this._index = n;
        }

        public Ptg[] getNameDefinition() {
            return this._nameRecord.getNameDefinition();
        }

        public String getNameText() {
            return this._nameRecord.getNameText();
        }

        public boolean hasFormula() {
            return this._nameRecord.hasFormula();
        }

        public boolean isFunctionName() {
            return this._nameRecord.isFunctionName();
        }

        public boolean isRange() {
            return this._nameRecord.hasFormula();
        }

        public NamePtg createPtg() {
            return new NamePtg(this._index);
        }
    }
}

