/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.model.InternalWorkbook;
import ai2.org.apache.poi.hssf.record.FormatRecord;
import ai2.org.apache.poi.ss.usermodel.BuiltinFormats;
import ai2.org.apache.poi.ss.usermodel.DataFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFDataFormat
implements DataFormat {
    private static final String[] _builtinFormats = BuiltinFormats.getAll();
    private final Vector<String> _formats = new Vector();
    private final InternalWorkbook _workbook;
    private boolean _movedBuiltins = false;

    HSSFDataFormat(InternalWorkbook internalWorkbook) {
        this._workbook = internalWorkbook;
        for (FormatRecord formatRecord : internalWorkbook.getFormats()) {
            this.ensureFormatsSize(formatRecord.getIndexCode());
            this._formats.set(formatRecord.getIndexCode(), formatRecord.getFormatString());
        }
    }

    public static List<String> getBuiltinFormats() {
        return Arrays.asList(_builtinFormats);
    }

    public static short getBuiltinFormat(String string) {
        return (short)BuiltinFormats.getBuiltinFormat(string);
    }

    @Override
    public short getFormat(String string) {
        short s;
        String string2 = string.toUpperCase(Locale.ROOT).equals("TEXT") ? "@" : string;
        if (!this._movedBuiltins) {
            for (s = 0; s < _builtinFormats.length; ++s) {
                this.ensureFormatsSize(s);
                if (this._formats.get(s) != null) continue;
                this._formats.set(s, _builtinFormats[s]);
            }
            this._movedBuiltins = true;
        }
        for (s = 0; s < this._formats.size(); ++s) {
            if (!string2.equals(this._formats.get(s))) continue;
            return s;
        }
        s = this._workbook.getFormat(string2, true);
        this.ensureFormatsSize(s);
        this._formats.set(s, string2);
        return s;
    }

    @Override
    public String getFormat(short s) {
        String string;
        if (this._movedBuiltins) {
            return this._formats.get(s);
        }
        if (s == -1) {
            return null;
        }
        String string2 = string = this._formats.size() > s ? this._formats.get(s) : null;
        if (_builtinFormats.length > s && _builtinFormats[s] != null) {
            if (string != null) {
                return string;
            }
            return _builtinFormats[s];
        }
        return string;
    }

    public static String getBuiltinFormat(short s) {
        return BuiltinFormats.getBuiltinFormat(s);
    }

    public static int getNumberOfBuiltinBuiltinFormats() {
        return _builtinFormats.length;
    }

    private void ensureFormatsSize(int n) {
        if (this._formats.size() <= n) {
            this._formats.setSize(n + 1);
        }
    }
}

