/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai2.org.apache.poi.hssf.record.CFRule12Record;
import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.record.cf.BorderFormatting;
import ai2.org.apache.poi.hssf.record.cf.ColorGradientFormatting;
import ai2.org.apache.poi.hssf.record.cf.DataBarFormatting;
import ai2.org.apache.poi.hssf.record.cf.FontFormatting;
import ai2.org.apache.poi.hssf.record.cf.IconMultiStateFormatting;
import ai2.org.apache.poi.hssf.record.cf.PatternFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFBorderFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFColorScaleFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFDataBarFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFFontFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFIconMultiStateFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFPatternFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.usermodel.ConditionType;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingRule;

public final class HSSFConditionalFormattingRule
implements ConditionalFormattingRule {
    private static final byte CELL_COMPARISON = 1;
    private final CFRuleBase cfRuleRecord;
    private final HSSFWorkbook workbook;
    private final HSSFSheet sheet;

    HSSFConditionalFormattingRule(HSSFSheet hSSFSheet, CFRuleBase cFRuleBase) {
        if (hSSFSheet == null) {
            throw new IllegalArgumentException("pSheet must not be null");
        }
        if (cFRuleBase == null) {
            throw new IllegalArgumentException("pRuleRecord must not be null");
        }
        this.sheet = hSSFSheet;
        this.workbook = hSSFSheet.getWorkbook();
        this.cfRuleRecord = cFRuleBase;
    }

    CFRuleBase getCfRuleRecord() {
        return this.cfRuleRecord;
    }

    private CFRule12Record getCFRule12Record(boolean bl) {
        if (!(this.cfRuleRecord instanceof CFRule12Record)) {
            if (bl) {
                throw new IllegalArgumentException("Can't convert a CF into a CF12 record");
            }
            return null;
        }
        return (CFRule12Record)this.cfRuleRecord;
    }

    private HSSFFontFormatting getFontFormatting(boolean bl) {
        FontFormatting fontFormatting = this.cfRuleRecord.getFontFormatting();
        if (fontFormatting == null) {
            if (!bl) {
                return null;
            }
            fontFormatting = new FontFormatting();
            this.cfRuleRecord.setFontFormatting(fontFormatting);
        }
        return new HSSFFontFormatting(this.cfRuleRecord, this.workbook);
    }

    public HSSFFontFormatting getFontFormatting() {
        return this.getFontFormatting(false);
    }

    public HSSFFontFormatting createFontFormatting() {
        return this.getFontFormatting(true);
    }

    private HSSFBorderFormatting getBorderFormatting(boolean bl) {
        BorderFormatting borderFormatting = this.cfRuleRecord.getBorderFormatting();
        if (borderFormatting == null) {
            if (!bl) {
                return null;
            }
            borderFormatting = new BorderFormatting();
            this.cfRuleRecord.setBorderFormatting(borderFormatting);
        }
        return new HSSFBorderFormatting(this.cfRuleRecord, this.workbook);
    }

    public HSSFBorderFormatting getBorderFormatting() {
        return this.getBorderFormatting(false);
    }

    public HSSFBorderFormatting createBorderFormatting() {
        return this.getBorderFormatting(true);
    }

    private HSSFPatternFormatting getPatternFormatting(boolean bl) {
        PatternFormatting patternFormatting = this.cfRuleRecord.getPatternFormatting();
        if (patternFormatting == null) {
            if (!bl) {
                return null;
            }
            patternFormatting = new PatternFormatting();
            this.cfRuleRecord.setPatternFormatting(patternFormatting);
        }
        return new HSSFPatternFormatting(this.cfRuleRecord, this.workbook);
    }

    public HSSFPatternFormatting getPatternFormatting() {
        return this.getPatternFormatting(false);
    }

    public HSSFPatternFormatting createPatternFormatting() {
        return this.getPatternFormatting(true);
    }

    private HSSFDataBarFormatting getDataBarFormatting(boolean bl) {
        CFRule12Record cFRule12Record = this.getCFRule12Record(bl);
        if (cFRule12Record == null) {
            return null;
        }
        DataBarFormatting dataBarFormatting = cFRule12Record.getDataBarFormatting();
        if (dataBarFormatting == null) {
            if (!bl) {
                return null;
            }
            cFRule12Record.createDataBarFormatting();
        }
        return new HSSFDataBarFormatting(cFRule12Record, this.sheet);
    }

    public HSSFDataBarFormatting getDataBarFormatting() {
        return this.getDataBarFormatting(false);
    }

    public HSSFDataBarFormatting createDataBarFormatting() {
        return this.getDataBarFormatting(true);
    }

    private HSSFIconMultiStateFormatting getMultiStateFormatting(boolean bl) {
        CFRule12Record cFRule12Record = this.getCFRule12Record(bl);
        if (cFRule12Record == null) {
            return null;
        }
        IconMultiStateFormatting iconMultiStateFormatting = cFRule12Record.getMultiStateFormatting();
        if (iconMultiStateFormatting == null) {
            if (!bl) {
                return null;
            }
            cFRule12Record.createMultiStateFormatting();
        }
        return new HSSFIconMultiStateFormatting(cFRule12Record, this.sheet);
    }

    public HSSFIconMultiStateFormatting getMultiStateFormatting() {
        return this.getMultiStateFormatting(false);
    }

    public HSSFIconMultiStateFormatting createMultiStateFormatting() {
        return this.getMultiStateFormatting(true);
    }

    private HSSFColorScaleFormatting getColorScaleFormatting(boolean bl) {
        CFRule12Record cFRule12Record = this.getCFRule12Record(bl);
        if (cFRule12Record == null) {
            return null;
        }
        ColorGradientFormatting colorGradientFormatting = cFRule12Record.getColorGradientFormatting();
        if (colorGradientFormatting == null) {
            if (!bl) {
                return null;
            }
            cFRule12Record.createColorGradientFormatting();
        }
        return new HSSFColorScaleFormatting(cFRule12Record, this.sheet);
    }

    public HSSFColorScaleFormatting getColorScaleFormatting() {
        return this.getColorScaleFormatting(false);
    }

    public HSSFColorScaleFormatting createColorScaleFormatting() {
        return this.getColorScaleFormatting(true);
    }

    public byte getConditionType() {
        return this.cfRuleRecord.getConditionType();
    }

    public ConditionType getConditionTypeType() {
        return ConditionType.forId(this.getConditionType());
    }

    public byte getComparisonOperation() {
        return this.cfRuleRecord.getComparisonOperation();
    }

    public String getFormula1() {
        return this.toFormulaString(this.cfRuleRecord.getParsedExpression1());
    }

    public String getFormula2() {
        byte by = this.cfRuleRecord.getConditionType();
        if (by == 1) {
            byte by2 = this.cfRuleRecord.getComparisonOperation();
            switch (by2) {
                case 1: 
                case 2: {
                    return this.toFormulaString(this.cfRuleRecord.getParsedExpression2());
                }
            }
        }
        return null;
    }

    protected String toFormulaString(Ptg[] ptgArray) {
        return HSSFConditionalFormattingRule.toFormulaString(ptgArray, this.workbook);
    }

    protected static String toFormulaString(Ptg[] ptgArray, HSSFWorkbook hSSFWorkbook) {
        if (ptgArray == null || ptgArray.length == 0) {
            return null;
        }
        return HSSFFormulaParser.toFormulaString(hSSFWorkbook, ptgArray);
    }
}

