/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import ai2.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormatting;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.Region;

public final class HSSFConditionalFormatting
implements ConditionalFormatting {
    private final HSSFSheet sheet;
    private final CFRecordsAggregate cfAggregate;

    HSSFConditionalFormatting(HSSFSheet hSSFSheet, CFRecordsAggregate cFRecordsAggregate) {
        if (hSSFSheet == null) {
            throw new IllegalArgumentException("sheet must not be null");
        }
        if (cFRecordsAggregate == null) {
            throw new IllegalArgumentException("cfAggregate must not be null");
        }
        this.sheet = hSSFSheet;
        this.cfAggregate = cFRecordsAggregate;
    }

    CFRecordsAggregate getCFRecordsAggregate() {
        return this.cfAggregate;
    }

    public Region[] getFormattingRegions() {
        CellRangeAddress[] cellRangeAddressArray = this.getFormattingRanges();
        return Region.convertCellRangesToRegions(cellRangeAddressArray);
    }

    public CellRangeAddress[] getFormattingRanges() {
        return this.cfAggregate.getHeader().getCellRanges();
    }

    public void setRule(int n, HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        this.cfAggregate.setRule(n, hSSFConditionalFormattingRule.getCfRuleRecord());
    }

    public void setRule(int n, ConditionalFormattingRule conditionalFormattingRule) {
        this.setRule(n, (HSSFConditionalFormattingRule)conditionalFormattingRule);
    }

    public void addRule(HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        this.cfAggregate.addRule(hSSFConditionalFormattingRule.getCfRuleRecord());
    }

    public void addRule(ConditionalFormattingRule conditionalFormattingRule) {
        this.addRule((HSSFConditionalFormattingRule)conditionalFormattingRule);
    }

    public HSSFConditionalFormattingRule getRule(int n) {
        CFRuleBase cFRuleBase = this.cfAggregate.getRule(n);
        return new HSSFConditionalFormattingRule(this.sheet, cFRuleBase);
    }

    public int getNumberOfRules() {
        return this.cfAggregate.getNumberOfRules();
    }

    public String toString() {
        return this.cfAggregate.toString();
    }
}

