/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.CFRule12Record;
import ai2.org.apache.poi.hssf.record.cf.ColorGradientFormatting;
import ai2.org.apache.poi.hssf.record.cf.ColorGradientThreshold;
import ai2.org.apache.poi.hssf.record.common.ExtendedColor;
import ai2.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingThreshold;
import ai2.org.apache.poi.hssf.usermodel.HSSFExtendedColor;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.usermodel.Color;
import ai2.org.apache.poi.ss.usermodel.ColorScaleFormatting;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;

public final class HSSFColorScaleFormatting
implements ColorScaleFormatting {
    private final HSSFSheet sheet;
    private final CFRule12Record cfRule12Record;
    private final ColorGradientFormatting colorFormatting;

    protected HSSFColorScaleFormatting(CFRule12Record cFRule12Record, HSSFSheet hSSFSheet) {
        this.sheet = hSSFSheet;
        this.cfRule12Record = cFRule12Record;
        this.colorFormatting = this.cfRule12Record.getColorGradientFormatting();
    }

    public int getNumControlPoints() {
        return this.colorFormatting.getNumControlPoints();
    }

    public void setNumControlPoints(int n) {
        this.colorFormatting.setNumControlPoints(n);
    }

    public HSSFExtendedColor[] getColors() {
        ExtendedColor[] extendedColorArray = this.colorFormatting.getColors();
        HSSFExtendedColor[] hSSFExtendedColorArray = new HSSFExtendedColor[extendedColorArray.length];
        for (int i = 0; i < extendedColorArray.length; ++i) {
            hSSFExtendedColorArray[i] = new HSSFExtendedColor(extendedColorArray[i]);
        }
        return hSSFExtendedColorArray;
    }

    public void setColors(Color[] colorArray) {
        ExtendedColor[] extendedColorArray = new ExtendedColor[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            extendedColorArray[i] = ((HSSFExtendedColor)colorArray[i]).getExtendedColor();
        }
        this.colorFormatting.setColors(extendedColorArray);
    }

    public HSSFConditionalFormattingThreshold[] getThresholds() {
        ColorGradientThreshold[] colorGradientThresholdArray = this.colorFormatting.getThresholds();
        HSSFConditionalFormattingThreshold[] hSSFConditionalFormattingThresholdArray = new HSSFConditionalFormattingThreshold[colorGradientThresholdArray.length];
        for (int i = 0; i < colorGradientThresholdArray.length; ++i) {
            hSSFConditionalFormattingThresholdArray[i] = new HSSFConditionalFormattingThreshold(colorGradientThresholdArray[i], this.sheet);
        }
        return hSSFConditionalFormattingThresholdArray;
    }

    public void setThresholds(ConditionalFormattingThreshold[] conditionalFormattingThresholdArray) {
        ColorGradientThreshold[] colorGradientThresholdArray = new ColorGradientThreshold[conditionalFormattingThresholdArray.length];
        for (int i = 0; i < colorGradientThresholdArray.length; ++i) {
            HSSFConditionalFormattingThreshold hSSFConditionalFormattingThreshold = (HSSFConditionalFormattingThreshold)conditionalFormattingThresholdArray[i];
            colorGradientThresholdArray[i] = (ColorGradientThreshold)hSSFConditionalFormattingThreshold.getThreshold();
        }
        this.colorFormatting.setThresholds(colorGradientThresholdArray);
    }

    public HSSFConditionalFormattingThreshold createThreshold() {
        return new HSSFConditionalFormattingThreshold(new ColorGradientThreshold(), this.sheet);
    }
}

