/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.BOFRecord;
import ai2.org.apache.poi.hssf.record.DimensionsRecord;
import ai2.org.apache.poi.hssf.record.EOFRecord;
import ai2.org.apache.poi.hssf.record.FooterRecord;
import ai2.org.apache.poi.hssf.record.HCenterRecord;
import ai2.org.apache.poi.hssf.record.HeaderRecord;
import ai2.org.apache.poi.hssf.record.PrintSetupRecord;
import ai2.org.apache.poi.hssf.record.ProtectRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordBase;
import ai2.org.apache.poi.hssf.record.SCLRecord;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.record.UnknownRecord;
import ai2.org.apache.poi.hssf.record.VCenterRecord;
import ai2.org.apache.poi.hssf.record.chart.AreaFormatRecord;
import ai2.org.apache.poi.hssf.record.chart.AxisLineFormatRecord;
import ai2.org.apache.poi.hssf.record.chart.AxisOptionsRecord;
import ai2.org.apache.poi.hssf.record.chart.AxisParentRecord;
import ai2.org.apache.poi.hssf.record.chart.AxisRecord;
import ai2.org.apache.poi.hssf.record.chart.AxisUsedRecord;
import ai2.org.apache.poi.hssf.record.chart.BarRecord;
import ai2.org.apache.poi.hssf.record.chart.BeginRecord;
import ai2.org.apache.poi.hssf.record.chart.CategorySeriesAxisRecord;
import ai2.org.apache.poi.hssf.record.chart.ChartFormatRecord;
import ai2.org.apache.poi.hssf.record.chart.ChartRecord;
import ai2.org.apache.poi.hssf.record.chart.ChartTitleFormatRecord;
import ai2.org.apache.poi.hssf.record.chart.DataFormatRecord;
import ai2.org.apache.poi.hssf.record.chart.DefaultDataLabelTextPropertiesRecord;
import ai2.org.apache.poi.hssf.record.chart.EndRecord;
import ai2.org.apache.poi.hssf.record.chart.FontBasisRecord;
import ai2.org.apache.poi.hssf.record.chart.FontIndexRecord;
import ai2.org.apache.poi.hssf.record.chart.FrameRecord;
import ai2.org.apache.poi.hssf.record.chart.LegendRecord;
import ai2.org.apache.poi.hssf.record.chart.LineFormatRecord;
import ai2.org.apache.poi.hssf.record.chart.LinkedDataRecord;
import ai2.org.apache.poi.hssf.record.chart.PlotAreaRecord;
import ai2.org.apache.poi.hssf.record.chart.PlotGrowthRecord;
import ai2.org.apache.poi.hssf.record.chart.SeriesIndexRecord;
import ai2.org.apache.poi.hssf.record.chart.SeriesRecord;
import ai2.org.apache.poi.hssf.record.chart.SeriesTextRecord;
import ai2.org.apache.poi.hssf.record.chart.SeriesToChartGroupRecord;
import ai2.org.apache.poi.hssf.record.chart.SheetPropertiesRecord;
import ai2.org.apache.poi.hssf.record.chart.TextRecord;
import ai2.org.apache.poi.hssf.record.chart.TickRecord;
import ai2.org.apache.poi.hssf.record.chart.UnitsRecord;
import ai2.org.apache.poi.hssf.record.chart.ValueRangeRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtgBase;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellRangeAddressBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFChart {
    private HSSFSheet sheet;
    private ChartRecord chartRecord;
    private LegendRecord legendRecord;
    private ChartTitleFormatRecord chartTitleFormat;
    private SeriesTextRecord chartTitleText;
    private List<ValueRangeRecord> valueRanges = new ArrayList<ValueRangeRecord>();
    private HSSFChartType type = HSSFChartType.Unknown;
    private List<HSSFSeries> series = new ArrayList<HSSFSeries>();

    private HSSFChart(HSSFSheet hSSFSheet, ChartRecord chartRecord) {
        this.chartRecord = chartRecord;
        this.sheet = hSSFSheet;
    }

    public void createBarChart(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet) {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        arrayList.add(this.createMSDrawingObjectRecord());
        arrayList.add(this.createOBJRecord());
        arrayList.add(this.createBOFRecord());
        arrayList.add(new HeaderRecord(""));
        arrayList.add(new FooterRecord(""));
        arrayList.add(this.createHCenterRecord());
        arrayList.add(this.createVCenterRecord());
        arrayList.add(this.createPrintSetupRecord());
        arrayList.add(this.createFontBasisRecord1());
        arrayList.add(this.createFontBasisRecord2());
        arrayList.add(new ProtectRecord(false));
        arrayList.add(this.createUnitsRecord());
        arrayList.add(this.createChartRecord(0, 0, 30434904, 19031616));
        arrayList.add(this.createBeginRecord());
        arrayList.add(this.createSCLRecord((short)1, (short)1));
        arrayList.add(this.createPlotGrowthRecord(65536, 65536));
        arrayList.add(this.createFrameRecord1());
        arrayList.add(this.createBeginRecord());
        arrayList.add(this.createLineFormatRecord(true));
        arrayList.add(this.createAreaFormatRecord1());
        arrayList.add(this.createEndRecord());
        arrayList.add(this.createSeriesRecord());
        arrayList.add(this.createBeginRecord());
        arrayList.add(this.createTitleLinkedDataRecord());
        arrayList.add(this.createValuesLinkedDataRecord());
        arrayList.add(this.createCategoriesLinkedDataRecord());
        arrayList.add(this.createDataFormatRecord());
        arrayList.add(this.createSeriesToChartGroupRecord());
        arrayList.add(this.createEndRecord());
        arrayList.add(this.createSheetPropsRecord());
        arrayList.add(this.createDefaultTextRecord((short)2));
        arrayList.add(this.createAllTextRecord());
        arrayList.add(this.createBeginRecord());
        arrayList.add(this.createFontIndexRecord(5));
        arrayList.add(this.createDirectLinkRecord());
        arrayList.add(this.createEndRecord());
        arrayList.add(this.createDefaultTextRecord((short)3));
        arrayList.add(this.createUnknownTextRecord());
        arrayList.add(this.createBeginRecord());
        arrayList.add(this.createFontIndexRecord(6));
        arrayList.add(this.createDirectLinkRecord());
        arrayList.add(this.createEndRecord());
        arrayList.add(this.createAxisUsedRecord((short)1));
        this.createAxisRecords(arrayList);
        arrayList.add(this.createEndRecord());
        arrayList.add(this.createDimensionsRecord());
        arrayList.add(this.createSeriesIndexRecord(2));
        arrayList.add(this.createSeriesIndexRecord(1));
        arrayList.add(this.createSeriesIndexRecord(3));
        arrayList.add(EOFRecord.instance);
        hSSFSheet.insertChartRecords(arrayList);
        hSSFWorkbook.insertChartRecord();
    }

    public static HSSFChart[] getSheetCharts(HSSFSheet hSSFSheet) {
        ArrayList<HSSFChart> arrayList = new ArrayList<HSSFChart>();
        HSSFChart hSSFChart = null;
        Object object = null;
        List<RecordBase> list = hSSFSheet.getSheet().getRecords();
        block0: for (RecordBase recordBase : list) {
            Object object2;
            if (recordBase instanceof ChartRecord) {
                object = null;
                hSSFChart = new HSSFChart(hSSFSheet, (ChartRecord)recordBase);
                arrayList.add(hSSFChart);
                continue;
            }
            if (recordBase instanceof LegendRecord) {
                hSSFChart.legendRecord = (LegendRecord)recordBase;
                continue;
            }
            if (recordBase instanceof SeriesRecord) {
                HSSFChart hSSFChart2 = hSSFChart;
                hSSFChart2.getClass();
                object2 = hSSFChart2.new HSSFSeries((SeriesRecord)recordBase);
                hSSFChart.series.add((HSSFSeries)object2);
                object = object2;
                continue;
            }
            if (recordBase instanceof ChartTitleFormatRecord) {
                hSSFChart.chartTitleFormat = (ChartTitleFormatRecord)recordBase;
                continue;
            }
            if (recordBase instanceof SeriesTextRecord) {
                object2 = (SeriesTextRecord)recordBase;
                if (hSSFChart.legendRecord == null && hSSFChart.series.size() > 0) {
                    HSSFSeries hSSFSeries = hSSFChart.series.get(hSSFChart.series.size() - 1);
                    hSSFSeries.seriesTitleText = (SeriesTextRecord)object2;
                    continue;
                }
                hSSFChart.chartTitleText = object2;
                continue;
            }
            if (recordBase instanceof LinkedDataRecord) {
                object2 = (LinkedDataRecord)recordBase;
                if (object == null) continue;
                ((HSSFSeries)object).insertData((LinkedDataRecord)object2);
                continue;
            }
            if (recordBase instanceof ValueRangeRecord) {
                hSSFChart.valueRanges.add((ValueRangeRecord)recordBase);
                continue;
            }
            if (!(recordBase instanceof Record) || hSSFChart == null) continue;
            object2 = (Record)recordBase;
            for (HSSFChartType hSSFChartType : HSSFChartType.values()) {
                if (hSSFChartType == HSSFChartType.Unknown || ((Record)object2).getSid() != hSSFChartType.getSid()) continue;
                hSSFChart.type = hSSFChartType;
                continue block0;
            }
        }
        return arrayList.toArray(new HSSFChart[arrayList.size()]);
    }

    public int getChartX() {
        return this.chartRecord.getX();
    }

    public int getChartY() {
        return this.chartRecord.getY();
    }

    public int getChartWidth() {
        return this.chartRecord.getWidth();
    }

    public int getChartHeight() {
        return this.chartRecord.getHeight();
    }

    public void setChartX(int n) {
        this.chartRecord.setX(n);
    }

    public void setChartY(int n) {
        this.chartRecord.setY(n);
    }

    public void setChartWidth(int n) {
        this.chartRecord.setWidth(n);
    }

    public void setChartHeight(int n) {
        this.chartRecord.setHeight(n);
    }

    public HSSFSeries[] getSeries() {
        return this.series.toArray(new HSSFSeries[this.series.size()]);
    }

    public String getChartTitle() {
        if (this.chartTitleText != null) {
            return this.chartTitleText.getText();
        }
        return null;
    }

    public void setChartTitle(String string) {
        if (this.chartTitleText == null) {
            throw new IllegalStateException("No chart title found to change");
        }
        this.chartTitleText.setText(string);
    }

    public void setValueRange(int n, Double d, Double d2, Double d3, Double d4) {
        ValueRangeRecord valueRangeRecord = this.valueRanges.get(n);
        if (valueRangeRecord == null) {
            return;
        }
        if (d != null) {
            valueRangeRecord.setAutomaticMinimum(d.isNaN());
            valueRangeRecord.setMinimumAxisValue(d);
        }
        if (d2 != null) {
            valueRangeRecord.setAutomaticMaximum(d2.isNaN());
            valueRangeRecord.setMaximumAxisValue(d2);
        }
        if (d3 != null) {
            valueRangeRecord.setAutomaticMajor(d3.isNaN());
            valueRangeRecord.setMajorIncrement(d3);
        }
        if (d4 != null) {
            valueRangeRecord.setAutomaticMinor(d4.isNaN());
            valueRangeRecord.setMinorIncrement(d4);
        }
    }

    private SeriesIndexRecord createSeriesIndexRecord(int n) {
        SeriesIndexRecord seriesIndexRecord = new SeriesIndexRecord();
        seriesIndexRecord.setIndex((short)n);
        return seriesIndexRecord;
    }

    private DimensionsRecord createDimensionsRecord() {
        DimensionsRecord dimensionsRecord = new DimensionsRecord();
        dimensionsRecord.setFirstRow(0);
        dimensionsRecord.setLastRow(31);
        dimensionsRecord.setFirstCol((short)0);
        dimensionsRecord.setLastCol((short)1);
        return dimensionsRecord;
    }

    private HCenterRecord createHCenterRecord() {
        HCenterRecord hCenterRecord = new HCenterRecord();
        hCenterRecord.setHCenter(false);
        return hCenterRecord;
    }

    private VCenterRecord createVCenterRecord() {
        VCenterRecord vCenterRecord = new VCenterRecord();
        vCenterRecord.setVCenter(false);
        return vCenterRecord;
    }

    private PrintSetupRecord createPrintSetupRecord() {
        PrintSetupRecord printSetupRecord = new PrintSetupRecord();
        printSetupRecord.setPaperSize((short)0);
        printSetupRecord.setScale((short)18);
        printSetupRecord.setPageStart((short)1);
        printSetupRecord.setFitWidth((short)1);
        printSetupRecord.setFitHeight((short)1);
        printSetupRecord.setLeftToRight(false);
        printSetupRecord.setLandscape(false);
        printSetupRecord.setValidSettings(true);
        printSetupRecord.setNoColor(false);
        printSetupRecord.setDraft(false);
        printSetupRecord.setNotes(false);
        printSetupRecord.setNoOrientation(false);
        printSetupRecord.setUsePage(false);
        printSetupRecord.setHResolution((short)0);
        printSetupRecord.setVResolution((short)0);
        printSetupRecord.setHeaderMargin(0.5);
        printSetupRecord.setFooterMargin(0.5);
        printSetupRecord.setCopies((short)15);
        return printSetupRecord;
    }

    private FontBasisRecord createFontBasisRecord1() {
        FontBasisRecord fontBasisRecord = new FontBasisRecord();
        fontBasisRecord.setXBasis((short)9120);
        fontBasisRecord.setYBasis((short)5640);
        fontBasisRecord.setHeightBasis((short)200);
        fontBasisRecord.setScale((short)0);
        fontBasisRecord.setIndexToFontTable((short)5);
        return fontBasisRecord;
    }

    private FontBasisRecord createFontBasisRecord2() {
        FontBasisRecord fontBasisRecord = this.createFontBasisRecord1();
        fontBasisRecord.setIndexToFontTable((short)6);
        return fontBasisRecord;
    }

    private BOFRecord createBOFRecord() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.setVersion(600);
        bOFRecord.setType(20);
        bOFRecord.setBuild(7422);
        bOFRecord.setBuildYear(1997);
        bOFRecord.setHistoryBitMask(16585);
        bOFRecord.setRequiredVersion(106);
        return bOFRecord;
    }

    private UnknownRecord createOBJRecord() {
        byte[] byArray = new byte[]{21, 0, 18, 0, 5, 0, 2, 0, 17, 96, 0, 0, 0, 0, -72, 3, -121, 3, 0, 0, 0, 0, 0, 0, 0, 0};
        return new UnknownRecord(93, byArray);
    }

    private UnknownRecord createMSDrawingObjectRecord() {
        byte[] byArray = new byte[]{15, 0, 2, -16, -64, 0, 0, 0, 16, 0, 8, -16, 8, 0, 0, 0, 2, 0, 0, 0, 2, 4, 0, 0, 15, 0, 3, -16, -88, 0, 0, 0, 15, 0, 4, -16, 40, 0, 0, 0, 1, 0, 9, -16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 10, -16, 8, 0, 0, 0, 0, 4, 0, 0, 5, 0, 0, 0, 15, 0, 4, -16, 112, 0, 0, 0, -110, 12, 10, -16, 8, 0, 0, 0, 2, 4, 0, 0, 0, 10, 0, 0, -109, 0, 11, -16, 54, 0, 0, 0, 127, 0, 4, 1, 4, 1, -65, 0, 8, 0, 8, 0, -127, 1, 78, 0, 0, 8, -125, 1, 77, 0, 0, 8, -65, 1, 16, 0, 17, 0, -64, 1, 77, 0, 0, 8, -1, 1, 8, 0, 8, 0, 63, 2, 0, 0, 2, 0, -65, 3, 0, 0, 8, 0, 0, 0, 16, -16, 18, 0, 0, 0, 0, 0, 4, 0, -64, 2, 10, 0, -12, 0, 14, 0, 102, 1, 32, 0, -23, 0, 0, 0, 17, -16, 0, 0, 0, 0};
        return new UnknownRecord(236, byArray);
    }

    private void createAxisRecords(List<Record> list) {
        list.add(this.createAxisParentRecord());
        list.add(this.createBeginRecord());
        list.add(this.createAxisRecord((short)0));
        list.add(this.createBeginRecord());
        list.add(this.createCategorySeriesAxisRecord());
        list.add(this.createAxisOptionsRecord());
        list.add(this.createTickRecord1());
        list.add(this.createEndRecord());
        list.add(this.createAxisRecord((short)1));
        list.add(this.createBeginRecord());
        list.add(this.createValueRangeRecord());
        list.add(this.createTickRecord2());
        list.add(this.createAxisLineFormatRecord((short)1));
        list.add(this.createLineFormatRecord(false));
        list.add(this.createEndRecord());
        list.add(this.createPlotAreaRecord());
        list.add(this.createFrameRecord2());
        list.add(this.createBeginRecord());
        list.add(this.createLineFormatRecord2());
        list.add(this.createAreaFormatRecord2());
        list.add(this.createEndRecord());
        list.add(this.createChartFormatRecord());
        list.add(this.createBeginRecord());
        list.add(this.createBarRecord());
        list.add(this.createLegendRecord());
        list.add(this.createBeginRecord());
        list.add(this.createTextRecord());
        list.add(this.createBeginRecord());
        list.add(this.createLinkedDataRecord());
        list.add(this.createEndRecord());
        list.add(this.createEndRecord());
        list.add(this.createEndRecord());
        list.add(this.createEndRecord());
    }

    private LinkedDataRecord createLinkedDataRecord() {
        LinkedDataRecord linkedDataRecord = new LinkedDataRecord();
        linkedDataRecord.setLinkType((byte)0);
        linkedDataRecord.setReferenceType((byte)1);
        linkedDataRecord.setCustomNumberFormat(false);
        linkedDataRecord.setIndexNumberFmtRecord((short)0);
        linkedDataRecord.setFormulaOfLink(null);
        return linkedDataRecord;
    }

    private TextRecord createTextRecord() {
        TextRecord textRecord = new TextRecord();
        textRecord.setHorizontalAlignment((byte)2);
        textRecord.setVerticalAlignment((byte)2);
        textRecord.setDisplayMode((short)1);
        textRecord.setRgbColor(0);
        textRecord.setX(-37);
        textRecord.setY(-60);
        textRecord.setWidth(0);
        textRecord.setHeight(0);
        textRecord.setAutoColor(true);
        textRecord.setShowKey(false);
        textRecord.setShowValue(false);
        textRecord.setVertical(false);
        textRecord.setAutoGeneratedText(true);
        textRecord.setGenerated(true);
        textRecord.setAutoLabelDeleted(false);
        textRecord.setAutoBackground(true);
        textRecord.setRotation((short)0);
        textRecord.setShowCategoryLabelAsPercentage(false);
        textRecord.setShowValueAsPercentage(false);
        textRecord.setShowBubbleSizes(false);
        textRecord.setShowLabel(false);
        textRecord.setIndexOfColorValue((short)77);
        textRecord.setDataLabelPlacement((short)0);
        textRecord.setTextRotation((short)0);
        return textRecord;
    }

    private LegendRecord createLegendRecord() {
        LegendRecord legendRecord = new LegendRecord();
        legendRecord.setXAxisUpperLeft(3542);
        legendRecord.setYAxisUpperLeft(1566);
        legendRecord.setXSize(437);
        legendRecord.setYSize(213);
        legendRecord.setType((byte)3);
        legendRecord.setSpacing((byte)1);
        legendRecord.setAutoPosition(true);
        legendRecord.setAutoSeries(true);
        legendRecord.setAutoXPositioning(true);
        legendRecord.setAutoYPositioning(true);
        legendRecord.setVertical(true);
        legendRecord.setDataTable(false);
        return legendRecord;
    }

    private BarRecord createBarRecord() {
        BarRecord barRecord = new BarRecord();
        barRecord.setBarSpace((short)0);
        barRecord.setCategorySpace((short)150);
        barRecord.setHorizontal(false);
        barRecord.setStacked(false);
        barRecord.setDisplayAsPercentage(false);
        barRecord.setShadow(false);
        return barRecord;
    }

    private ChartFormatRecord createChartFormatRecord() {
        ChartFormatRecord chartFormatRecord = new ChartFormatRecord();
        chartFormatRecord.setXPosition(0);
        chartFormatRecord.setYPosition(0);
        chartFormatRecord.setWidth(0);
        chartFormatRecord.setHeight(0);
        chartFormatRecord.setVaryDisplayPattern(false);
        return chartFormatRecord;
    }

    private PlotAreaRecord createPlotAreaRecord() {
        PlotAreaRecord plotAreaRecord = new PlotAreaRecord();
        return plotAreaRecord;
    }

    private AxisLineFormatRecord createAxisLineFormatRecord(short s) {
        AxisLineFormatRecord axisLineFormatRecord = new AxisLineFormatRecord();
        axisLineFormatRecord.setAxisType(s);
        return axisLineFormatRecord;
    }

    private ValueRangeRecord createValueRangeRecord() {
        ValueRangeRecord valueRangeRecord = new ValueRangeRecord();
        valueRangeRecord.setMinimumAxisValue(0.0);
        valueRangeRecord.setMaximumAxisValue(0.0);
        valueRangeRecord.setMajorIncrement(0.0);
        valueRangeRecord.setMinorIncrement(0.0);
        valueRangeRecord.setCategoryAxisCross(0.0);
        valueRangeRecord.setAutomaticMinimum(true);
        valueRangeRecord.setAutomaticMaximum(true);
        valueRangeRecord.setAutomaticMajor(true);
        valueRangeRecord.setAutomaticMinor(true);
        valueRangeRecord.setAutomaticCategoryCrossing(true);
        valueRangeRecord.setLogarithmicScale(false);
        valueRangeRecord.setValuesInReverse(false);
        valueRangeRecord.setCrossCategoryAxisAtMaximum(false);
        valueRangeRecord.setReserved(true);
        return valueRangeRecord;
    }

    private TickRecord createTickRecord1() {
        TickRecord tickRecord = new TickRecord();
        tickRecord.setMajorTickType((byte)2);
        tickRecord.setMinorTickType((byte)0);
        tickRecord.setLabelPosition((byte)3);
        tickRecord.setBackground((byte)1);
        tickRecord.setLabelColorRgb(0);
        tickRecord.setZero1(0);
        tickRecord.setZero2(0);
        tickRecord.setZero3((short)45);
        tickRecord.setAutorotate(true);
        tickRecord.setAutoTextBackground(true);
        tickRecord.setRotation((short)0);
        tickRecord.setAutorotate(true);
        tickRecord.setTickColor((short)77);
        return tickRecord;
    }

    private TickRecord createTickRecord2() {
        TickRecord tickRecord = this.createTickRecord1();
        tickRecord.setZero3((short)0);
        return tickRecord;
    }

    private AxisOptionsRecord createAxisOptionsRecord() {
        AxisOptionsRecord axisOptionsRecord = new AxisOptionsRecord();
        axisOptionsRecord.setMinimumCategory((short)-28644);
        axisOptionsRecord.setMaximumCategory((short)-28715);
        axisOptionsRecord.setMajorUnitValue((short)2);
        axisOptionsRecord.setMajorUnit((short)0);
        axisOptionsRecord.setMinorUnitValue((short)1);
        axisOptionsRecord.setMinorUnit((short)0);
        axisOptionsRecord.setBaseUnit((short)0);
        axisOptionsRecord.setCrossingPoint((short)-28644);
        axisOptionsRecord.setDefaultMinimum(true);
        axisOptionsRecord.setDefaultMaximum(true);
        axisOptionsRecord.setDefaultMajor(true);
        axisOptionsRecord.setDefaultMinorUnit(true);
        axisOptionsRecord.setIsDate(true);
        axisOptionsRecord.setDefaultBase(true);
        axisOptionsRecord.setDefaultCross(true);
        axisOptionsRecord.setDefaultDateSettings(true);
        return axisOptionsRecord;
    }

    private CategorySeriesAxisRecord createCategorySeriesAxisRecord() {
        CategorySeriesAxisRecord categorySeriesAxisRecord = new CategorySeriesAxisRecord();
        categorySeriesAxisRecord.setCrossingPoint((short)1);
        categorySeriesAxisRecord.setLabelFrequency((short)1);
        categorySeriesAxisRecord.setTickMarkFrequency((short)1);
        categorySeriesAxisRecord.setValueAxisCrossing(true);
        categorySeriesAxisRecord.setCrossesFarRight(false);
        categorySeriesAxisRecord.setReversed(false);
        return categorySeriesAxisRecord;
    }

    private AxisRecord createAxisRecord(short s) {
        AxisRecord axisRecord = new AxisRecord();
        axisRecord.setAxisType(s);
        return axisRecord;
    }

    private AxisParentRecord createAxisParentRecord() {
        AxisParentRecord axisParentRecord = new AxisParentRecord();
        axisParentRecord.setAxisType((short)0);
        axisParentRecord.setX(479);
        axisParentRecord.setY(221);
        axisParentRecord.setWidth(2995);
        axisParentRecord.setHeight(2902);
        return axisParentRecord;
    }

    private AxisUsedRecord createAxisUsedRecord(short s) {
        AxisUsedRecord axisUsedRecord = new AxisUsedRecord();
        axisUsedRecord.setNumAxis(s);
        return axisUsedRecord;
    }

    private LinkedDataRecord createDirectLinkRecord() {
        LinkedDataRecord linkedDataRecord = new LinkedDataRecord();
        linkedDataRecord.setLinkType((byte)0);
        linkedDataRecord.setReferenceType((byte)1);
        linkedDataRecord.setCustomNumberFormat(false);
        linkedDataRecord.setIndexNumberFmtRecord((short)0);
        linkedDataRecord.setFormulaOfLink(null);
        return linkedDataRecord;
    }

    private FontIndexRecord createFontIndexRecord(int n) {
        FontIndexRecord fontIndexRecord = new FontIndexRecord();
        fontIndexRecord.setFontIndex((short)n);
        return fontIndexRecord;
    }

    private TextRecord createAllTextRecord() {
        TextRecord textRecord = new TextRecord();
        textRecord.setHorizontalAlignment((byte)2);
        textRecord.setVerticalAlignment((byte)2);
        textRecord.setDisplayMode((short)1);
        textRecord.setRgbColor(0);
        textRecord.setX(-37);
        textRecord.setY(-60);
        textRecord.setWidth(0);
        textRecord.setHeight(0);
        textRecord.setAutoColor(true);
        textRecord.setShowKey(false);
        textRecord.setShowValue(true);
        textRecord.setVertical(false);
        textRecord.setAutoGeneratedText(true);
        textRecord.setGenerated(true);
        textRecord.setAutoLabelDeleted(false);
        textRecord.setAutoBackground(true);
        textRecord.setRotation((short)0);
        textRecord.setShowCategoryLabelAsPercentage(false);
        textRecord.setShowValueAsPercentage(false);
        textRecord.setShowBubbleSizes(false);
        textRecord.setShowLabel(false);
        textRecord.setIndexOfColorValue((short)77);
        textRecord.setDataLabelPlacement((short)0);
        textRecord.setTextRotation((short)0);
        return textRecord;
    }

    private TextRecord createUnknownTextRecord() {
        TextRecord textRecord = new TextRecord();
        textRecord.setHorizontalAlignment((byte)2);
        textRecord.setVerticalAlignment((byte)2);
        textRecord.setDisplayMode((short)1);
        textRecord.setRgbColor(0);
        textRecord.setX(-37);
        textRecord.setY(-60);
        textRecord.setWidth(0);
        textRecord.setHeight(0);
        textRecord.setAutoColor(true);
        textRecord.setShowKey(false);
        textRecord.setShowValue(false);
        textRecord.setVertical(false);
        textRecord.setAutoGeneratedText(true);
        textRecord.setGenerated(true);
        textRecord.setAutoLabelDeleted(false);
        textRecord.setAutoBackground(true);
        textRecord.setRotation((short)0);
        textRecord.setShowCategoryLabelAsPercentage(false);
        textRecord.setShowValueAsPercentage(false);
        textRecord.setShowBubbleSizes(false);
        textRecord.setShowLabel(false);
        textRecord.setIndexOfColorValue((short)77);
        textRecord.setDataLabelPlacement((short)11088);
        textRecord.setTextRotation((short)0);
        return textRecord;
    }

    private DefaultDataLabelTextPropertiesRecord createDefaultTextRecord(short s) {
        DefaultDataLabelTextPropertiesRecord defaultDataLabelTextPropertiesRecord = new DefaultDataLabelTextPropertiesRecord();
        defaultDataLabelTextPropertiesRecord.setCategoryDataType(s);
        return defaultDataLabelTextPropertiesRecord;
    }

    private SheetPropertiesRecord createSheetPropsRecord() {
        SheetPropertiesRecord sheetPropertiesRecord = new SheetPropertiesRecord();
        sheetPropertiesRecord.setChartTypeManuallyFormatted(false);
        sheetPropertiesRecord.setPlotVisibleOnly(true);
        sheetPropertiesRecord.setDoNotSizeWithWindow(false);
        sheetPropertiesRecord.setDefaultPlotDimensions(true);
        sheetPropertiesRecord.setAutoPlotArea(false);
        return sheetPropertiesRecord;
    }

    private SeriesToChartGroupRecord createSeriesToChartGroupRecord() {
        return new SeriesToChartGroupRecord();
    }

    private DataFormatRecord createDataFormatRecord() {
        DataFormatRecord dataFormatRecord = new DataFormatRecord();
        dataFormatRecord.setPointNumber((short)-1);
        dataFormatRecord.setSeriesIndex((short)0);
        dataFormatRecord.setSeriesNumber((short)0);
        dataFormatRecord.setUseExcel4Colors(false);
        return dataFormatRecord;
    }

    private LinkedDataRecord createCategoriesLinkedDataRecord() {
        LinkedDataRecord linkedDataRecord = new LinkedDataRecord();
        linkedDataRecord.setLinkType((byte)2);
        linkedDataRecord.setReferenceType((byte)2);
        linkedDataRecord.setCustomNumberFormat(false);
        linkedDataRecord.setIndexNumberFmtRecord((short)0);
        Area3DPtg area3DPtg = new Area3DPtg(0, 31, 1, 1, false, false, false, false, 0);
        linkedDataRecord.setFormulaOfLink(new Ptg[]{area3DPtg});
        return linkedDataRecord;
    }

    private LinkedDataRecord createValuesLinkedDataRecord() {
        LinkedDataRecord linkedDataRecord = new LinkedDataRecord();
        linkedDataRecord.setLinkType((byte)1);
        linkedDataRecord.setReferenceType((byte)2);
        linkedDataRecord.setCustomNumberFormat(false);
        linkedDataRecord.setIndexNumberFmtRecord((short)0);
        Area3DPtg area3DPtg = new Area3DPtg(0, 31, 0, 0, false, false, false, false, 0);
        linkedDataRecord.setFormulaOfLink(new Ptg[]{area3DPtg});
        return linkedDataRecord;
    }

    private LinkedDataRecord createTitleLinkedDataRecord() {
        LinkedDataRecord linkedDataRecord = new LinkedDataRecord();
        linkedDataRecord.setLinkType((byte)0);
        linkedDataRecord.setReferenceType((byte)1);
        linkedDataRecord.setCustomNumberFormat(false);
        linkedDataRecord.setIndexNumberFmtRecord((short)0);
        linkedDataRecord.setFormulaOfLink(null);
        return linkedDataRecord;
    }

    private SeriesRecord createSeriesRecord() {
        SeriesRecord seriesRecord = new SeriesRecord();
        seriesRecord.setCategoryDataType((short)1);
        seriesRecord.setValuesDataType((short)1);
        seriesRecord.setNumCategories((short)32);
        seriesRecord.setNumValues((short)31);
        seriesRecord.setBubbleSeriesType((short)1);
        seriesRecord.setNumBubbleValues((short)0);
        return seriesRecord;
    }

    private EndRecord createEndRecord() {
        return new EndRecord();
    }

    private AreaFormatRecord createAreaFormatRecord1() {
        AreaFormatRecord areaFormatRecord = new AreaFormatRecord();
        areaFormatRecord.setForegroundColor(0xFFFFFF);
        areaFormatRecord.setBackgroundColor(0);
        areaFormatRecord.setPattern((short)1);
        areaFormatRecord.setAutomatic(true);
        areaFormatRecord.setInvert(false);
        areaFormatRecord.setForecolorIndex((short)78);
        areaFormatRecord.setBackcolorIndex((short)77);
        return areaFormatRecord;
    }

    private AreaFormatRecord createAreaFormatRecord2() {
        AreaFormatRecord areaFormatRecord = new AreaFormatRecord();
        areaFormatRecord.setForegroundColor(0xC0C0C0);
        areaFormatRecord.setBackgroundColor(0);
        areaFormatRecord.setPattern((short)1);
        areaFormatRecord.setAutomatic(false);
        areaFormatRecord.setInvert(false);
        areaFormatRecord.setForecolorIndex((short)22);
        areaFormatRecord.setBackcolorIndex((short)79);
        return areaFormatRecord;
    }

    private LineFormatRecord createLineFormatRecord(boolean bl) {
        LineFormatRecord lineFormatRecord = new LineFormatRecord();
        lineFormatRecord.setLineColor(0);
        lineFormatRecord.setLinePattern((short)0);
        lineFormatRecord.setWeight((short)-1);
        lineFormatRecord.setAuto(true);
        lineFormatRecord.setDrawTicks(bl);
        lineFormatRecord.setColourPaletteIndex((short)77);
        return lineFormatRecord;
    }

    private LineFormatRecord createLineFormatRecord2() {
        LineFormatRecord lineFormatRecord = new LineFormatRecord();
        lineFormatRecord.setLineColor(0x808080);
        lineFormatRecord.setLinePattern((short)0);
        lineFormatRecord.setWeight((short)0);
        lineFormatRecord.setAuto(false);
        lineFormatRecord.setDrawTicks(false);
        lineFormatRecord.setUnknown(false);
        lineFormatRecord.setColourPaletteIndex((short)23);
        return lineFormatRecord;
    }

    private FrameRecord createFrameRecord1() {
        FrameRecord frameRecord = new FrameRecord();
        frameRecord.setBorderType((short)0);
        frameRecord.setAutoSize(false);
        frameRecord.setAutoPosition(true);
        return frameRecord;
    }

    private FrameRecord createFrameRecord2() {
        FrameRecord frameRecord = new FrameRecord();
        frameRecord.setBorderType((short)0);
        frameRecord.setAutoSize(true);
        frameRecord.setAutoPosition(true);
        return frameRecord;
    }

    private PlotGrowthRecord createPlotGrowthRecord(int n, int n2) {
        PlotGrowthRecord plotGrowthRecord = new PlotGrowthRecord();
        plotGrowthRecord.setHorizontalScale(n);
        plotGrowthRecord.setVerticalScale(n2);
        return plotGrowthRecord;
    }

    private SCLRecord createSCLRecord(short s, short s2) {
        SCLRecord sCLRecord = new SCLRecord();
        sCLRecord.setDenominator(s2);
        sCLRecord.setNumerator(s);
        return sCLRecord;
    }

    private BeginRecord createBeginRecord() {
        return new BeginRecord();
    }

    private ChartRecord createChartRecord(int n, int n2, int n3, int n4) {
        ChartRecord chartRecord = new ChartRecord();
        chartRecord.setX(n);
        chartRecord.setY(n2);
        chartRecord.setWidth(n3);
        chartRecord.setHeight(n4);
        return chartRecord;
    }

    private UnitsRecord createUnitsRecord() {
        UnitsRecord unitsRecord = new UnitsRecord();
        unitsRecord.setUnits((short)0);
        return unitsRecord;
    }

    public HSSFSeries createSeries() throws Exception {
        ArrayList<RecordBase> arrayList = new ArrayList<RecordBase>();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        List<RecordBase> list = this.sheet.getSheet().getRecords();
        for (RecordBase object2 : list) {
            ++n;
            if (object2 instanceof BeginRecord) {
                ++n2;
            } else if (object2 instanceof EndRecord) {
                if (n5 == --n2) {
                    n5 = -1;
                    n6 = n;
                    if (!bl) {
                        arrayList.add(object2);
                        bl = true;
                    }
                }
                if (n4 == n2) break;
            }
            if (object2 instanceof ChartRecord) {
                if (object2 == this.chartRecord) {
                    n3 = n;
                    n4 = n2;
                }
            } else if (object2 instanceof SeriesRecord && n3 != -1) {
                ++n7;
                n5 = n2;
            }
            if (n5 == -1 || bl) continue;
            arrayList.add(object2);
        }
        if (n6 == -1) {
            return null;
        }
        n = n6 + 1;
        Object object3 = null;
        ArrayList<BeginRecord> arrayList2 = new ArrayList<BeginRecord>();
        for (RecordBase recordBase : arrayList) {
            StandardRecord standardRecord;
            Record record = null;
            if (recordBase instanceof BeginRecord) {
                record = new BeginRecord();
            } else if (recordBase instanceof EndRecord) {
                record = new EndRecord();
            } else if (recordBase instanceof SeriesRecord) {
                standardRecord = (SeriesRecord)((SeriesRecord)recordBase).clone();
                object3 = new HSSFSeries((SeriesRecord)standardRecord);
                record = standardRecord;
            } else if (recordBase instanceof LinkedDataRecord) {
                standardRecord = (LinkedDataRecord)((LinkedDataRecord)recordBase).clone();
                if (object3 != null) {
                    ((HSSFSeries)object3).insertData((LinkedDataRecord)standardRecord);
                }
                record = standardRecord;
            } else if (recordBase instanceof DataFormatRecord) {
                standardRecord = (DataFormatRecord)((DataFormatRecord)recordBase).clone();
                ((DataFormatRecord)standardRecord).setSeriesIndex((short)n7);
                ((DataFormatRecord)standardRecord).setSeriesNumber((short)n7);
                record = standardRecord;
            } else if (recordBase instanceof SeriesTextRecord) {
                standardRecord = (SeriesTextRecord)((SeriesTextRecord)recordBase).clone();
                if (object3 != null) {
                    ((HSSFSeries)object3).setSeriesTitleText((SeriesTextRecord)standardRecord);
                }
                record = standardRecord;
            } else if (recordBase instanceof Record) {
                record = (Record)((Record)recordBase).clone();
            }
            if (record == null) continue;
            arrayList2.add((BeginRecord)record);
        }
        if (object3 == null) {
            return null;
        }
        for (RecordBase recordBase : arrayList2) {
            list.add(n++, recordBase);
        }
        return object3;
    }

    public boolean removeSeries(HSSFSeries hSSFSeries) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        List<RecordBase> list = this.sheet.getSheet().getRecords();
        Iterator<RecordBase> iterator = list.iterator();
        while (iterator.hasNext()) {
            RecordBase recordBase = iterator.next();
            ++n;
            if (recordBase instanceof BeginRecord) {
                ++n2;
            } else if (recordBase instanceof EndRecord) {
                if (n4 == --n2) {
                    n4 = -1;
                    if (bl) {
                        bl = false;
                        bl3 = true;
                        iterator.remove();
                    }
                }
                if (n3 == n2) break;
            }
            if (recordBase instanceof ChartRecord) {
                if (recordBase == this.chartRecord) {
                    n3 = n2;
                    bl2 = true;
                }
            } else if (recordBase instanceof SeriesRecord) {
                if (bl2) {
                    if (hSSFSeries.series == recordBase) {
                        n4 = n2;
                        bl = true;
                    } else {
                        ++n5;
                    }
                }
            } else if (recordBase instanceof DataFormatRecord && bl2 && !bl) {
                DataFormatRecord dataFormatRecord = (DataFormatRecord)recordBase;
                dataFormatRecord.setSeriesIndex((short)n5);
                dataFormatRecord.setSeriesNumber((short)n5);
            }
            if (!bl) continue;
            iterator.remove();
        }
        return bl3;
    }

    public HSSFChartType getType() {
        return this.type;
    }

    public class HSSFSeries {
        private SeriesRecord series;
        private SeriesTextRecord seriesTitleText;
        private LinkedDataRecord dataName;
        private LinkedDataRecord dataValues;
        private LinkedDataRecord dataCategoryLabels;
        private LinkedDataRecord dataSecondaryCategoryLabels;

        HSSFSeries(SeriesRecord seriesRecord) {
            this.series = seriesRecord;
        }

        void insertData(LinkedDataRecord linkedDataRecord) {
            switch (linkedDataRecord.getLinkType()) {
                case 0: {
                    this.dataName = linkedDataRecord;
                    break;
                }
                case 1: {
                    this.dataValues = linkedDataRecord;
                    break;
                }
                case 2: {
                    this.dataCategoryLabels = linkedDataRecord;
                    break;
                }
                case 3: {
                    this.dataSecondaryCategoryLabels = linkedDataRecord;
                }
            }
        }

        void setSeriesTitleText(SeriesTextRecord seriesTextRecord) {
            this.seriesTitleText = seriesTextRecord;
        }

        public short getNumValues() {
            return this.series.getNumValues();
        }

        public short getValueType() {
            return this.series.getValuesDataType();
        }

        public String getSeriesTitle() {
            if (this.seriesTitleText != null) {
                return this.seriesTitleText.getText();
            }
            return null;
        }

        public void setSeriesTitle(String string) {
            if (this.seriesTitleText == null) {
                throw new IllegalStateException("No series title found to change");
            }
            this.seriesTitleText.setText(string);
        }

        public LinkedDataRecord getDataName() {
            return this.dataName;
        }

        public LinkedDataRecord getDataValues() {
            return this.dataValues;
        }

        public LinkedDataRecord getDataCategoryLabels() {
            return this.dataCategoryLabels;
        }

        public LinkedDataRecord getDataSecondaryCategoryLabels() {
            return this.dataSecondaryCategoryLabels;
        }

        public SeriesRecord getSeries() {
            return this.series;
        }

        private CellRangeAddressBase getCellRange(LinkedDataRecord linkedDataRecord) {
            if (linkedDataRecord == null) {
                return null;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (Ptg ptg : linkedDataRecord.getFormulaOfLink()) {
                if (!(ptg instanceof AreaPtgBase)) continue;
                AreaPtgBase areaPtgBase = (AreaPtgBase)ptg;
                n = areaPtgBase.getFirstRow();
                n2 = areaPtgBase.getLastRow();
                n3 = areaPtgBase.getFirstColumn();
                n4 = areaPtgBase.getLastColumn();
            }
            return new CellRangeAddress(n, n2, n3, n4);
        }

        public CellRangeAddressBase getValuesCellRange() {
            return this.getCellRange(this.dataValues);
        }

        public CellRangeAddressBase getCategoryLabelsCellRange() {
            return this.getCellRange(this.dataCategoryLabels);
        }

        private Integer setVerticalCellRange(LinkedDataRecord linkedDataRecord, CellRangeAddressBase cellRangeAddressBase) {
            if (linkedDataRecord == null) {
                return null;
            }
            ArrayList<AreaPtgBase> arrayList = new ArrayList<AreaPtgBase>();
            int n = cellRangeAddressBase.getLastRow() - cellRangeAddressBase.getFirstRow() + 1;
            int n2 = cellRangeAddressBase.getLastColumn() - cellRangeAddressBase.getFirstColumn() + 1;
            for (Ptg ptg : linkedDataRecord.getFormulaOfLink()) {
                if (!(ptg instanceof AreaPtgBase)) continue;
                AreaPtgBase areaPtgBase = (AreaPtgBase)ptg;
                areaPtgBase.setFirstRow(cellRangeAddressBase.getFirstRow());
                areaPtgBase.setLastRow(cellRangeAddressBase.getLastRow());
                areaPtgBase.setFirstColumn(cellRangeAddressBase.getFirstColumn());
                areaPtgBase.setLastColumn(cellRangeAddressBase.getLastColumn());
                arrayList.add(areaPtgBase);
            }
            linkedDataRecord.setFormulaOfLink(arrayList.toArray(new Ptg[arrayList.size()]));
            return n * n2;
        }

        public void setValuesCellRange(CellRangeAddressBase cellRangeAddressBase) {
            Integer n = this.setVerticalCellRange(this.dataValues, cellRangeAddressBase);
            if (n == null) {
                return;
            }
            this.series.setNumValues((short)n.intValue());
        }

        public void setCategoryLabelsCellRange(CellRangeAddressBase cellRangeAddressBase) {
            Integer n = this.setVerticalCellRange(this.dataCategoryLabels, cellRangeAddressBase);
            if (n == null) {
                return;
            }
            this.series.setNumCategories((short)n.intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HSSFChartType {
        Area{

            public short getSid() {
                return 4122;
            }
        }
        ,
        Bar{

            public short getSid() {
                return 4119;
            }
        }
        ,
        Line{

            public short getSid() {
                return 4120;
            }
        }
        ,
        Pie{

            public short getSid() {
                return 4121;
            }
        }
        ,
        Scatter{

            public short getSid() {
                return 4123;
            }
        }
        ,
        Unknown{

            public short getSid() {
                return 0;
            }
        };


        public abstract short getSid();
    }
}

