/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.pivottable;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;

public final class ViewFieldsRecord
extends StandardRecord {
    public static final short sid = 177;
    private static final int STRING_NOT_PRESENT_LEN = 65535;
    private static final int BASE_SIZE = 10;
    private int _sxaxis;
    private int _cSub;
    private int _grbitSub;
    private int _cItm;
    private String _name;

    public ViewFieldsRecord(RecordInputStream recordInputStream) {
        this._sxaxis = recordInputStream.readShort();
        this._cSub = recordInputStream.readShort();
        this._grbitSub = recordInputStream.readShort();
        this._cItm = recordInputStream.readShort();
        int n = recordInputStream.readUShort();
        if (n != 65535) {
            byte by = recordInputStream.readByte();
            this._name = (by & 1) != 0 ? recordInputStream.readUnicodeLEString(n) : recordInputStream.readCompressedUnicode(n);
        }
    }

    protected void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._sxaxis);
        littleEndianOutput.writeShort(this._cSub);
        littleEndianOutput.writeShort(this._grbitSub);
        littleEndianOutput.writeShort(this._cItm);
        if (this._name != null) {
            StringUtil.writeUnicodeString(littleEndianOutput, this._name);
        } else {
            littleEndianOutput.writeShort(65535);
        }
    }

    protected int getDataSize() {
        if (this._name == null) {
            return 10;
        }
        return 11 + this._name.length() * (StringUtil.hasMultibyte(this._name) ? 2 : 1);
    }

    public short getSid() {
        return 177;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SXVD]\n");
        stringBuffer.append("    .sxaxis    = ").append(HexDump.shortToHex(this._sxaxis)).append('\n');
        stringBuffer.append("    .cSub      = ").append(HexDump.shortToHex(this._cSub)).append('\n');
        stringBuffer.append("    .grbitSub  = ").append(HexDump.shortToHex(this._grbitSub)).append('\n');
        stringBuffer.append("    .cItm      = ").append(HexDump.shortToHex(this._cItm)).append('\n');
        stringBuffer.append("    .name      = ").append(this._name).append('\n');
        stringBuffer.append("[/SXVD]\n");
        return stringBuffer.toString();
    }

    private static final class Axis {
        public static final int NO_AXIS = 0;
        public static final int ROW = 1;
        public static final int COLUMN = 2;
        public static final int PAGE = 4;
        public static final int DATA = 8;

        private Axis() {
        }
    }
}

