/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.pivottable;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;

public final class DataItemRecord
extends StandardRecord {
    public static final short sid = 197;
    private int isxvdData;
    private int iiftab;
    private int df;
    private int isxvd;
    private int isxvi;
    private int ifmt;
    private String name;

    public DataItemRecord(RecordInputStream recordInputStream) {
        this.isxvdData = recordInputStream.readUShort();
        this.iiftab = recordInputStream.readUShort();
        this.df = recordInputStream.readUShort();
        this.isxvd = recordInputStream.readUShort();
        this.isxvi = recordInputStream.readUShort();
        this.ifmt = recordInputStream.readUShort();
        this.name = recordInputStream.readString();
    }

    protected void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.isxvdData);
        littleEndianOutput.writeShort(this.iiftab);
        littleEndianOutput.writeShort(this.df);
        littleEndianOutput.writeShort(this.isxvd);
        littleEndianOutput.writeShort(this.isxvi);
        littleEndianOutput.writeShort(this.ifmt);
        StringUtil.writeUnicodeString(littleEndianOutput, this.name);
    }

    protected int getDataSize() {
        return 12 + StringUtil.getEncodedSize(this.name);
    }

    public short getSid() {
        return 197;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SXDI]\n");
        stringBuffer.append("  .isxvdData = ").append(HexDump.shortToHex(this.isxvdData)).append("\n");
        stringBuffer.append("  .iiftab = ").append(HexDump.shortToHex(this.iiftab)).append("\n");
        stringBuffer.append("  .df = ").append(HexDump.shortToHex(this.df)).append("\n");
        stringBuffer.append("  .isxvd = ").append(HexDump.shortToHex(this.isxvd)).append("\n");
        stringBuffer.append("  .isxvi = ").append(HexDump.shortToHex(this.isxvi)).append("\n");
        stringBuffer.append("  .ifmt = ").append(HexDump.shortToHex(this.ifmt)).append("\n");
        stringBuffer.append("[/SXDI]\n");
        return stringBuffer.toString();
    }
}

