/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.crypto;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class Biff8RC4Key
extends Biff8EncryptionKey {
    public static final int KEY_DIGEST_LENGTH = 5;
    private static final int PASSWORD_HASH_NUMBER_OF_BYTES_USED = 5;
    private static POILogger log = POILogFactory.getLogger(Biff8RC4Key.class);

    Biff8RC4Key(byte[] byArray) {
        if (byArray.length != 5) {
            throw new IllegalArgumentException("Expected 5 byte key digest, but got " + HexDump.toHex(byArray));
        }
        CipherAlgorithm cipherAlgorithm = CipherAlgorithm.rc4;
        this._secretKey = new SecretKeySpec(byArray, cipherAlgorithm.jceId);
    }

    public static Biff8RC4Key create(String string, byte[] byArray) {
        return new Biff8RC4Key(Biff8RC4Key.createKeyDigest(string, byArray));
    }

    public boolean validate(byte[] byArray, byte[] byArray2) {
        Biff8RC4Key.check16Bytes(byArray, "verifier");
        Biff8RC4Key.check16Bytes(byArray2, "verifierHash");
        Cipher cipher = this.getCipher();
        this.initCipherForBlock(cipher, 0);
        byte[] byArray3 = (byte[])byArray.clone();
        byte[] byArray4 = (byte[])byArray2.clone();
        try {
            cipher.update(byArray3, 0, byArray3.length, byArray3);
            cipher.update(byArray4, 0, byArray4.length, byArray4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new EncryptedDocumentException("buffer too short", shortBufferException);
        }
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        messageDigest.update(byArray3);
        byte[] byArray5 = messageDigest.digest();
        if (log.check(1)) {
            byte[] byArray6 = Biff8RC4Key.xor(byArray2, Biff8RC4Key.xor(byArray4, byArray5));
            log.log(1, "valid verifierHash value", HexDump.toHex(byArray6));
        }
        return Arrays.equals(byArray4, byArray5);
    }

    Cipher getCipher() {
        CipherAlgorithm cipherAlgorithm = CipherAlgorithm.rc4;
        Cipher cipher = CryptoFunctions.getCipher(this._secretKey, cipherAlgorithm, null, null, 1);
        return cipher;
    }

    static byte[] createKeyDigest(String string, byte[] byArray) {
        Biff8RC4Key.check16Bytes(byArray, "docId");
        int n = Math.min(string.length(), 16);
        byte[] byArray2 = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray2[i * 2 + 0] = (byte)(c << 0 & 0xFF);
            byArray2[i * 2 + 1] = (byte)(c << 8 & 0xFF);
        }
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        messageDigest.update(byArray2);
        byte[] byArray3 = messageDigest.digest();
        messageDigest.reset();
        for (int i = 0; i < 16; ++i) {
            messageDigest.update(byArray3, 0, 5);
            messageDigest.update(byArray, 0, byArray.length);
        }
        byte[] byArray4 = CryptoFunctions.getBlock0(messageDigest.digest(), 5);
        return byArray4;
    }

    void initCipherForBlock(Cipher cipher, int n) {
        byte[] byArray = new byte[4];
        LittleEndian.putInt(byArray, 0, n);
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        messageDigest.update(this._secretKey.getEncoded());
        messageDigest.update(byArray);
        SecretKeySpec secretKeySpec = new SecretKeySpec(messageDigest.digest(), this._secretKey.getAlgorithm());
        try {
            cipher.init(1, secretKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException("Can't rekey for next block", generalSecurityException);
        }
    }

    private static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    private static void check16Bytes(byte[] byArray, String string) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Expected 16 byte " + string + ", but got " + HexDump.toHex(byArray));
        }
    }
}

