/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.common;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.common.SharedFeature;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class FeatFormulaErr2
implements SharedFeature {
    static BitField checkCalculationErrors = BitFieldFactory.getInstance(1);
    static BitField checkEmptyCellRef = BitFieldFactory.getInstance(2);
    static BitField checkNumbersAsText = BitFieldFactory.getInstance(4);
    static BitField checkInconsistentRanges = BitFieldFactory.getInstance(8);
    static BitField checkInconsistentFormulas = BitFieldFactory.getInstance(16);
    static BitField checkDateTimeFormats = BitFieldFactory.getInstance(32);
    static BitField checkUnprotectedFormulas = BitFieldFactory.getInstance(64);
    static BitField performDataValidation = BitFieldFactory.getInstance(128);
    private int errorCheck;

    public FeatFormulaErr2() {
    }

    public FeatFormulaErr2(RecordInputStream recordInputStream) {
        this.errorCheck = recordInputStream.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [FEATURE FORMULA ERRORS]\n");
        stringBuffer.append("  checkCalculationErrors    = ");
        stringBuffer.append("  checkEmptyCellRef         = ");
        stringBuffer.append("  checkNumbersAsText        = ");
        stringBuffer.append("  checkInconsistentRanges   = ");
        stringBuffer.append("  checkInconsistentFormulas = ");
        stringBuffer.append("  checkDateTimeFormats      = ");
        stringBuffer.append("  checkUnprotectedFormulas  = ");
        stringBuffer.append("  performDataValidation     = ");
        stringBuffer.append(" [/FEATURE FORMULA ERRORS]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.errorCheck);
    }

    public int getDataSize() {
        return 4;
    }

    public int _getRawErrorCheckValue() {
        return this.errorCheck;
    }

    public boolean getCheckCalculationErrors() {
        return checkCalculationErrors.isSet(this.errorCheck);
    }

    public void setCheckCalculationErrors(boolean bl) {
        checkCalculationErrors.setBoolean(this.errorCheck, bl);
    }

    public boolean getCheckEmptyCellRef() {
        return checkEmptyCellRef.isSet(this.errorCheck);
    }

    public void setCheckEmptyCellRef(boolean bl) {
        checkEmptyCellRef.setBoolean(this.errorCheck, bl);
    }

    public boolean getCheckNumbersAsText() {
        return checkNumbersAsText.isSet(this.errorCheck);
    }

    public void setCheckNumbersAsText(boolean bl) {
        checkNumbersAsText.setBoolean(this.errorCheck, bl);
    }

    public boolean getCheckInconsistentRanges() {
        return checkInconsistentRanges.isSet(this.errorCheck);
    }

    public void setCheckInconsistentRanges(boolean bl) {
        checkInconsistentRanges.setBoolean(this.errorCheck, bl);
    }

    public boolean getCheckInconsistentFormulas() {
        return checkInconsistentFormulas.isSet(this.errorCheck);
    }

    public void setCheckInconsistentFormulas(boolean bl) {
        checkInconsistentFormulas.setBoolean(this.errorCheck, bl);
    }

    public boolean getCheckDateTimeFormats() {
        return checkDateTimeFormats.isSet(this.errorCheck);
    }

    public void setCheckDateTimeFormats(boolean bl) {
        checkDateTimeFormats.setBoolean(this.errorCheck, bl);
    }

    public boolean getCheckUnprotectedFormulas() {
        return checkUnprotectedFormulas.isSet(this.errorCheck);
    }

    public void setCheckUnprotectedFormulas(boolean bl) {
        checkUnprotectedFormulas.setBoolean(this.errorCheck, bl);
    }

    public boolean getPerformDataValidation() {
        return performDataValidation.isSet(this.errorCheck);
    }

    public void setPerformDataValidation(boolean bl) {
        performDataValidation.setBoolean(this.errorCheck, bl);
    }
}

