/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.chart;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class SheetPropertiesRecord
extends StandardRecord {
    public static final short sid = 4164;
    private static final BitField chartTypeManuallyFormatted = BitFieldFactory.getInstance(1);
    private static final BitField plotVisibleOnly = BitFieldFactory.getInstance(2);
    private static final BitField doNotSizeWithWindow = BitFieldFactory.getInstance(4);
    private static final BitField defaultPlotDimensions = BitFieldFactory.getInstance(8);
    private static final BitField autoPlotArea = BitFieldFactory.getInstance(16);
    private int field_1_flags;
    private int field_2_empty;
    public static final byte EMPTY_NOT_PLOTTED = 0;
    public static final byte EMPTY_ZERO = 1;
    public static final byte EMPTY_INTERPOLATED = 2;

    public SheetPropertiesRecord() {
    }

    public SheetPropertiesRecord(RecordInputStream recordInputStream) {
        this.field_1_flags = recordInputStream.readUShort();
        this.field_2_empty = recordInputStream.readUShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SHTPROPS]\n");
        stringBuffer.append("    .flags                = ").append(HexDump.shortToHex(this.field_1_flags)).append('\n');
        stringBuffer.append("         .chartTypeManuallyFormatted= ").append(this.isChartTypeManuallyFormatted()).append('\n');
        stringBuffer.append("         .plotVisibleOnly           = ").append(this.isPlotVisibleOnly()).append('\n');
        stringBuffer.append("         .doNotSizeWithWindow       = ").append(this.isDoNotSizeWithWindow()).append('\n');
        stringBuffer.append("         .defaultPlotDimensions     = ").append(this.isDefaultPlotDimensions()).append('\n');
        stringBuffer.append("         .autoPlotArea              = ").append(this.isAutoPlotArea()).append('\n');
        stringBuffer.append("    .empty                = ").append(HexDump.shortToHex(this.field_2_empty)).append('\n');
        stringBuffer.append("[/SHTPROPS]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_flags);
        littleEndianOutput.writeShort(this.field_2_empty);
    }

    protected int getDataSize() {
        return 4;
    }

    public short getSid() {
        return 4164;
    }

    public Object clone() {
        SheetPropertiesRecord sheetPropertiesRecord = new SheetPropertiesRecord();
        sheetPropertiesRecord.field_1_flags = this.field_1_flags;
        sheetPropertiesRecord.field_2_empty = this.field_2_empty;
        return sheetPropertiesRecord;
    }

    public int getFlags() {
        return this.field_1_flags;
    }

    public int getEmpty() {
        return this.field_2_empty;
    }

    public void setEmpty(byte by) {
        this.field_2_empty = by;
    }

    public void setChartTypeManuallyFormatted(boolean bl) {
        this.field_1_flags = chartTypeManuallyFormatted.setBoolean(this.field_1_flags, bl);
    }

    public boolean isChartTypeManuallyFormatted() {
        return chartTypeManuallyFormatted.isSet(this.field_1_flags);
    }

    public void setPlotVisibleOnly(boolean bl) {
        this.field_1_flags = plotVisibleOnly.setBoolean(this.field_1_flags, bl);
    }

    public boolean isPlotVisibleOnly() {
        return plotVisibleOnly.isSet(this.field_1_flags);
    }

    public void setDoNotSizeWithWindow(boolean bl) {
        this.field_1_flags = doNotSizeWithWindow.setBoolean(this.field_1_flags, bl);
    }

    public boolean isDoNotSizeWithWindow() {
        return doNotSizeWithWindow.isSet(this.field_1_flags);
    }

    public void setDefaultPlotDimensions(boolean bl) {
        this.field_1_flags = defaultPlotDimensions.setBoolean(this.field_1_flags, bl);
    }

    public boolean isDefaultPlotDimensions() {
        return defaultPlotDimensions.isSet(this.field_1_flags);
    }

    public void setAutoPlotArea(boolean bl) {
        this.field_1_flags = autoPlotArea.setBoolean(this.field_1_flags, bl);
    }

    public boolean isAutoPlotArea() {
        return autoPlotArea.isSet(this.field_1_flags);
    }
}

