/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.chart;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class LegendRecord
extends StandardRecord {
    public static final short sid = 4117;
    private static final BitField autoPosition = BitFieldFactory.getInstance(1);
    private static final BitField autoSeries = BitFieldFactory.getInstance(2);
    private static final BitField autoXPositioning = BitFieldFactory.getInstance(4);
    private static final BitField autoYPositioning = BitFieldFactory.getInstance(8);
    private static final BitField vertical = BitFieldFactory.getInstance(16);
    private static final BitField dataTable = BitFieldFactory.getInstance(32);
    private int field_1_xAxisUpperLeft;
    private int field_2_yAxisUpperLeft;
    private int field_3_xSize;
    private int field_4_ySize;
    private byte field_5_type;
    public static final byte TYPE_BOTTOM = 0;
    public static final byte TYPE_CORNER = 1;
    public static final byte TYPE_TOP = 2;
    public static final byte TYPE_RIGHT = 3;
    public static final byte TYPE_LEFT = 4;
    public static final byte TYPE_UNDOCKED = 7;
    private byte field_6_spacing;
    public static final byte SPACING_CLOSE = 0;
    public static final byte SPACING_MEDIUM = 1;
    public static final byte SPACING_OPEN = 2;
    private short field_7_options;

    public LegendRecord() {
    }

    public LegendRecord(RecordInputStream recordInputStream) {
        this.field_1_xAxisUpperLeft = recordInputStream.readInt();
        this.field_2_yAxisUpperLeft = recordInputStream.readInt();
        this.field_3_xSize = recordInputStream.readInt();
        this.field_4_ySize = recordInputStream.readInt();
        this.field_5_type = recordInputStream.readByte();
        this.field_6_spacing = recordInputStream.readByte();
        this.field_7_options = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[LEGEND]\n");
        stringBuffer.append("    .xAxisUpperLeft       = ").append("0x").append(HexDump.toHex(this.getXAxisUpperLeft())).append(" (").append(this.getXAxisUpperLeft()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .yAxisUpperLeft       = ").append("0x").append(HexDump.toHex(this.getYAxisUpperLeft())).append(" (").append(this.getYAxisUpperLeft()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .xSize                = ").append("0x").append(HexDump.toHex(this.getXSize())).append(" (").append(this.getXSize()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .ySize                = ").append("0x").append(HexDump.toHex(this.getYSize())).append(" (").append(this.getYSize()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .type                 = ").append("0x").append(HexDump.toHex(this.getType())).append(" (").append(this.getType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .spacing              = ").append("0x").append(HexDump.toHex(this.getSpacing())).append(" (").append(this.getSpacing()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .autoPosition             = ").append(this.isAutoPosition()).append('\n');
        stringBuffer.append("         .autoSeries               = ").append(this.isAutoSeries()).append('\n');
        stringBuffer.append("         .autoXPositioning         = ").append(this.isAutoXPositioning()).append('\n');
        stringBuffer.append("         .autoYPositioning         = ").append(this.isAutoYPositioning()).append('\n');
        stringBuffer.append("         .vertical                 = ").append(this.isVertical()).append('\n');
        stringBuffer.append("         .dataTable                = ").append(this.isDataTable()).append('\n');
        stringBuffer.append("[/LEGEND]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.field_1_xAxisUpperLeft);
        littleEndianOutput.writeInt(this.field_2_yAxisUpperLeft);
        littleEndianOutput.writeInt(this.field_3_xSize);
        littleEndianOutput.writeInt(this.field_4_ySize);
        littleEndianOutput.writeByte(this.field_5_type);
        littleEndianOutput.writeByte(this.field_6_spacing);
        littleEndianOutput.writeShort(this.field_7_options);
    }

    protected int getDataSize() {
        return 20;
    }

    public short getSid() {
        return 4117;
    }

    public Object clone() {
        LegendRecord legendRecord = new LegendRecord();
        legendRecord.field_1_xAxisUpperLeft = this.field_1_xAxisUpperLeft;
        legendRecord.field_2_yAxisUpperLeft = this.field_2_yAxisUpperLeft;
        legendRecord.field_3_xSize = this.field_3_xSize;
        legendRecord.field_4_ySize = this.field_4_ySize;
        legendRecord.field_5_type = this.field_5_type;
        legendRecord.field_6_spacing = this.field_6_spacing;
        legendRecord.field_7_options = this.field_7_options;
        return legendRecord;
    }

    public int getXAxisUpperLeft() {
        return this.field_1_xAxisUpperLeft;
    }

    public void setXAxisUpperLeft(int n) {
        this.field_1_xAxisUpperLeft = n;
    }

    public int getYAxisUpperLeft() {
        return this.field_2_yAxisUpperLeft;
    }

    public void setYAxisUpperLeft(int n) {
        this.field_2_yAxisUpperLeft = n;
    }

    public int getXSize() {
        return this.field_3_xSize;
    }

    public void setXSize(int n) {
        this.field_3_xSize = n;
    }

    public int getYSize() {
        return this.field_4_ySize;
    }

    public void setYSize(int n) {
        this.field_4_ySize = n;
    }

    public byte getType() {
        return this.field_5_type;
    }

    public void setType(byte by) {
        this.field_5_type = by;
    }

    public byte getSpacing() {
        return this.field_6_spacing;
    }

    public void setSpacing(byte by) {
        this.field_6_spacing = by;
    }

    public short getOptions() {
        return this.field_7_options;
    }

    public void setOptions(short s) {
        this.field_7_options = s;
    }

    public void setAutoPosition(boolean bl) {
        this.field_7_options = autoPosition.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoPosition() {
        return autoPosition.isSet(this.field_7_options);
    }

    public void setAutoSeries(boolean bl) {
        this.field_7_options = autoSeries.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoSeries() {
        return autoSeries.isSet(this.field_7_options);
    }

    public void setAutoXPositioning(boolean bl) {
        this.field_7_options = autoXPositioning.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoXPositioning() {
        return autoXPositioning.isSet(this.field_7_options);
    }

    public void setAutoYPositioning(boolean bl) {
        this.field_7_options = autoYPositioning.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isAutoYPositioning() {
        return autoYPositioning.isSet(this.field_7_options);
    }

    public void setVertical(boolean bl) {
        this.field_7_options = vertical.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isVertical() {
        return vertical.isSet(this.field_7_options);
    }

    public void setDataTable(boolean bl) {
        this.field_7_options = dataTable.setShortBoolean(this.field_7_options, bl);
    }

    public boolean isDataTable() {
        return dataTable.isSet(this.field_7_options);
    }
}

