/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.cf;

import ai2.org.apache.poi.hssf.record.cf.DataBarThreshold;
import ai2.org.apache.poi.hssf.record.common.ExtendedColor;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public final class DataBarFormatting
implements Cloneable {
    private static POILogger log = POILogFactory.getLogger(DataBarFormatting.class);
    private byte options = 0;
    private byte percentMin = 0;
    private byte percentMax = 0;
    private ExtendedColor color;
    private DataBarThreshold thresholdMin;
    private DataBarThreshold thresholdMax;
    private static BitField iconOnly = BitFieldFactory.getInstance(1);
    private static BitField reversed = BitFieldFactory.getInstance(4);

    public DataBarFormatting() {
        this.options = (byte)2;
    }

    public DataBarFormatting(LittleEndianInput littleEndianInput) {
        littleEndianInput.readShort();
        littleEndianInput.readByte();
        this.options = littleEndianInput.readByte();
        this.percentMin = littleEndianInput.readByte();
        this.percentMax = littleEndianInput.readByte();
        if (this.percentMin < 0 || this.percentMin > 100) {
            log.log(5, new Object[]{"Inconsistent Minimum Percentage found " + this.percentMin});
        }
        if (this.percentMax < 0 || this.percentMax > 100) {
            log.log(5, new Object[]{"Inconsistent Minimum Percentage found " + this.percentMin});
        }
        this.color = new ExtendedColor(littleEndianInput);
        this.thresholdMin = new DataBarThreshold(littleEndianInput);
        this.thresholdMax = new DataBarThreshold(littleEndianInput);
    }

    public boolean isIconOnly() {
        return this.getOptionFlag(iconOnly);
    }

    public void setIconOnly(boolean bl) {
        this.setOptionFlag(bl, iconOnly);
    }

    public boolean isReversed() {
        return this.getOptionFlag(reversed);
    }

    public void setReversed(boolean bl) {
        this.setOptionFlag(bl, reversed);
    }

    private boolean getOptionFlag(BitField bitField) {
        int n = bitField.getValue(this.options);
        return n != 0;
    }

    private void setOptionFlag(boolean bl, BitField bitField) {
        this.options = bitField.setByteBoolean(this.options, bl);
    }

    public byte getPercentMin() {
        return this.percentMin;
    }

    public void setPercentMin(byte by) {
        this.percentMin = by;
    }

    public byte getPercentMax() {
        return this.percentMax;
    }

    public void setPercentMax(byte by) {
        this.percentMax = by;
    }

    public ExtendedColor getColor() {
        return this.color;
    }

    public void setColor(ExtendedColor extendedColor) {
        this.color = extendedColor;
    }

    public DataBarThreshold getThresholdMin() {
        return this.thresholdMin;
    }

    public void setThresholdMin(DataBarThreshold dataBarThreshold) {
        this.thresholdMin = dataBarThreshold;
    }

    public DataBarThreshold getThresholdMax() {
        return this.thresholdMax;
    }

    public void setThresholdMax(DataBarThreshold dataBarThreshold) {
        this.thresholdMax = dataBarThreshold;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    [Data Bar Formatting]\n");
        stringBuffer.append("          .icon_only= ").append(this.isIconOnly()).append("\n");
        stringBuffer.append("          .reversed = ").append(this.isReversed()).append("\n");
        stringBuffer.append(this.color);
        stringBuffer.append(this.thresholdMin);
        stringBuffer.append(this.thresholdMax);
        stringBuffer.append("    [/Data Bar Formatting]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        DataBarFormatting dataBarFormatting = new DataBarFormatting();
        dataBarFormatting.options = this.options;
        dataBarFormatting.percentMin = this.percentMin;
        dataBarFormatting.percentMax = this.percentMax;
        dataBarFormatting.color = (ExtendedColor)this.color.clone();
        dataBarFormatting.thresholdMin = (DataBarThreshold)this.thresholdMin.clone();
        dataBarFormatting.thresholdMax = (DataBarThreshold)this.thresholdMax.clone();
        return dataBarFormatting;
    }

    public int getDataLength() {
        return 6 + this.color.getDataLength() + this.thresholdMin.getDataLength() + this.thresholdMax.getDataLength();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(0);
        littleEndianOutput.writeByte(0);
        littleEndianOutput.writeByte(this.options);
        littleEndianOutput.writeByte(this.percentMin);
        littleEndianOutput.writeByte(this.percentMax);
        this.color.serialize(littleEndianOutput);
        this.thresholdMin.serialize(littleEndianOutput);
        this.thresholdMax.serialize(littleEndianOutput);
    }
}

