/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.cf;

import ai2.org.apache.poi.hssf.record.cf.ColorGradientThreshold;
import ai2.org.apache.poi.hssf.record.cf.Threshold;
import ai2.org.apache.poi.hssf.record.common.ExtendedColor;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public final class ColorGradientFormatting
implements Cloneable {
    private static POILogger log = POILogFactory.getLogger(ColorGradientFormatting.class);
    private byte options = 0;
    private ColorGradientThreshold[] thresholds;
    private ExtendedColor[] colors;
    private static BitField clamp = BitFieldFactory.getInstance(1);
    private static BitField background = BitFieldFactory.getInstance(2);

    public ColorGradientFormatting() {
        this.options = (byte)3;
        this.thresholds = new ColorGradientThreshold[3];
        this.colors = new ExtendedColor[3];
    }

    public ColorGradientFormatting(LittleEndianInput littleEndianInput) {
        int n;
        littleEndianInput.readShort();
        littleEndianInput.readByte();
        byte by = littleEndianInput.readByte();
        byte by2 = littleEndianInput.readByte();
        if (by != by2) {
            log.log(5, new Object[]{"Inconsistent Color Gradient defintion, found " + by + " vs " + by2 + " entries"});
        }
        this.options = littleEndianInput.readByte();
        this.thresholds = new ColorGradientThreshold[by];
        for (n = 0; n < this.thresholds.length; ++n) {
            this.thresholds[n] = new ColorGradientThreshold(littleEndianInput);
        }
        this.colors = new ExtendedColor[by2];
        for (n = 0; n < this.colors.length; ++n) {
            littleEndianInput.readDouble();
            this.colors[n] = new ExtendedColor(littleEndianInput);
        }
    }

    public int getNumControlPoints() {
        return this.thresholds.length;
    }

    public void setNumControlPoints(int n) {
        if (n != this.thresholds.length) {
            ColorGradientThreshold[] colorGradientThresholdArray = new ColorGradientThreshold[n];
            ExtendedColor[] extendedColorArray = new ExtendedColor[n];
            int n2 = Math.min(this.thresholds.length, n);
            System.arraycopy(this.thresholds, 0, colorGradientThresholdArray, 0, n2);
            System.arraycopy(this.colors, 0, extendedColorArray, 0, n2);
            this.thresholds = colorGradientThresholdArray;
            this.colors = extendedColorArray;
            this.updateThresholdPositions();
        }
    }

    public ColorGradientThreshold[] getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(ColorGradientThreshold[] colorGradientThresholdArray) {
        this.thresholds = colorGradientThresholdArray;
        this.updateThresholdPositions();
    }

    public ExtendedColor[] getColors() {
        return this.colors;
    }

    public void setColors(ExtendedColor[] extendedColorArray) {
        this.colors = extendedColorArray;
    }

    public boolean isClampToCurve() {
        return this.getOptionFlag(clamp);
    }

    public boolean isAppliesToBackground() {
        return this.getOptionFlag(background);
    }

    private boolean getOptionFlag(BitField bitField) {
        int n = bitField.getValue(this.options);
        return n != 0;
    }

    private void updateThresholdPositions() {
        double d = 1.0 / (double)(this.thresholds.length - 1);
        for (int i = 0; i < this.thresholds.length; ++i) {
            this.thresholds[i].setPosition(d * (double)i);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    [Color Gradient Formatting]\n");
        stringBuffer.append("          .clamp     = ").append(this.isClampToCurve()).append("\n");
        stringBuffer.append("          .background= ").append(this.isAppliesToBackground()).append("\n");
        for (ColorGradientThreshold object : this.thresholds) {
            stringBuffer.append(object.toString());
        }
        for (ExtendedColor extendedColor : this.colors) {
            stringBuffer.append(extendedColor.toString());
        }
        stringBuffer.append("    [/Color Gradient Formatting]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        ColorGradientFormatting colorGradientFormatting = new ColorGradientFormatting();
        colorGradientFormatting.options = this.options;
        colorGradientFormatting.thresholds = new ColorGradientThreshold[this.thresholds.length];
        colorGradientFormatting.colors = new ExtendedColor[this.colors.length];
        System.arraycopy(this.thresholds, 0, colorGradientFormatting.thresholds, 0, this.thresholds.length);
        System.arraycopy(this.colors, 0, colorGradientFormatting.colors, 0, this.colors.length);
        return colorGradientFormatting;
    }

    public int getDataLength() {
        int n = 6;
        for (ColorGradientThreshold object : this.thresholds) {
            n += ((Threshold)object).getDataLength();
        }
        for (ExtendedColor extendedColor : this.colors) {
            n += extendedColor.getDataLength();
            n += 8;
        }
        return n;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        Object object;
        int n;
        littleEndianOutput.writeShort(0);
        littleEndianOutput.writeByte(0);
        littleEndianOutput.writeByte(this.thresholds.length);
        littleEndianOutput.writeByte(this.thresholds.length);
        littleEndianOutput.writeByte(this.options);
        ColorGradientThreshold[] colorGradientThresholdArray = this.thresholds;
        int n2 = colorGradientThresholdArray.length;
        for (n = 0; n < n2; ++n) {
            object = colorGradientThresholdArray[n];
            ((ColorGradientThreshold)object).serialize(littleEndianOutput);
        }
        double d = 1.0 / (double)(this.colors.length - 1);
        for (n = 0; n < this.colors.length; ++n) {
            littleEndianOutput.writeDouble((double)n * d);
            object = this.colors[n];
            ((ExtendedColor)object).serialize(littleEndianOutput);
        }
    }
}

