/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.model.RecordStream;
import ai2.org.apache.poi.hssf.record.ObjectProtectRecord;
import ai2.org.apache.poi.hssf.record.PasswordRecord;
import ai2.org.apache.poi.hssf.record.ProtectRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.ScenarioProtectRecord;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;

public final class WorksheetProtectionBlock
extends RecordAggregate {
    private ProtectRecord _protectRecord;
    private ObjectProtectRecord _objectProtectRecord;
    private ScenarioProtectRecord _scenarioProtectRecord;
    private PasswordRecord _passwordRecord;

    public static boolean isComponentRecord(int n) {
        switch (n) {
            case 18: 
            case 19: 
            case 99: 
            case 221: {
                return true;
            }
        }
        return false;
    }

    private boolean readARecord(RecordStream recordStream) {
        switch (recordStream.peekNextSid()) {
            case 18: {
                this.checkNotPresent(this._protectRecord);
                this._protectRecord = (ProtectRecord)recordStream.getNext();
                break;
            }
            case 99: {
                this.checkNotPresent(this._objectProtectRecord);
                this._objectProtectRecord = (ObjectProtectRecord)recordStream.getNext();
                break;
            }
            case 221: {
                this.checkNotPresent(this._scenarioProtectRecord);
                this._scenarioProtectRecord = (ScenarioProtectRecord)recordStream.getNext();
                break;
            }
            case 19: {
                this.checkNotPresent(this._passwordRecord);
                this._passwordRecord = (PasswordRecord)recordStream.getNext();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void checkNotPresent(Record record) {
        if (record != null) {
            throw new RecordFormatException("Duplicate PageSettingsBlock record (sid=0x" + Integer.toHexString(record.getSid()) + ")");
        }
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        WorksheetProtectionBlock.visitIfPresent(this._protectRecord, recordVisitor);
        WorksheetProtectionBlock.visitIfPresent(this._objectProtectRecord, recordVisitor);
        WorksheetProtectionBlock.visitIfPresent(this._scenarioProtectRecord, recordVisitor);
        WorksheetProtectionBlock.visitIfPresent(this._passwordRecord, recordVisitor);
    }

    private static void visitIfPresent(Record record, RecordAggregate.RecordVisitor recordVisitor) {
        if (record != null) {
            recordVisitor.visitRecord(record);
        }
    }

    public PasswordRecord getPasswordRecord() {
        return this._passwordRecord;
    }

    public ScenarioProtectRecord getHCenter() {
        return this._scenarioProtectRecord;
    }

    public void addRecords(RecordStream recordStream) {
        while (this.readARecord(recordStream)) {
        }
    }

    private ProtectRecord getProtect() {
        if (this._protectRecord == null) {
            this._protectRecord = new ProtectRecord(false);
        }
        return this._protectRecord;
    }

    private PasswordRecord getPassword() {
        if (this._passwordRecord == null) {
            this._passwordRecord = WorksheetProtectionBlock.createPassword();
        }
        return this._passwordRecord;
    }

    public void protectSheet(String string, boolean bl, boolean bl2) {
        StandardRecord standardRecord;
        if (string == null) {
            this._passwordRecord = null;
            this._protectRecord = null;
            this._objectProtectRecord = null;
            this._scenarioProtectRecord = null;
            return;
        }
        ProtectRecord protectRecord = this.getProtect();
        PasswordRecord passwordRecord = this.getPassword();
        protectRecord.setProtect(true);
        passwordRecord.setPassword((short)CryptoFunctions.createXorVerifier1(string));
        if (this._objectProtectRecord == null && bl) {
            standardRecord = WorksheetProtectionBlock.createObjectProtect();
            ((ObjectProtectRecord)standardRecord).setProtect(true);
            this._objectProtectRecord = standardRecord;
        }
        if (this._scenarioProtectRecord == null && bl2) {
            standardRecord = WorksheetProtectionBlock.createScenarioProtect();
            ((ScenarioProtectRecord)standardRecord).setProtect(true);
            this._scenarioProtectRecord = standardRecord;
        }
    }

    public boolean isSheetProtected() {
        return this._protectRecord != null && this._protectRecord.getProtect();
    }

    public boolean isObjectProtected() {
        return this._objectProtectRecord != null && this._objectProtectRecord.getProtect();
    }

    public boolean isScenarioProtected() {
        return this._scenarioProtectRecord != null && this._scenarioProtectRecord.getProtect();
    }

    private static ObjectProtectRecord createObjectProtect() {
        ObjectProtectRecord objectProtectRecord = new ObjectProtectRecord();
        objectProtectRecord.setProtect(false);
        return objectProtectRecord;
    }

    private static ScenarioProtectRecord createScenarioProtect() {
        ScenarioProtectRecord scenarioProtectRecord = new ScenarioProtectRecord();
        scenarioProtectRecord.setProtect(false);
        return scenarioProtectRecord;
    }

    private static PasswordRecord createPassword() {
        return new PasswordRecord(0);
    }

    public int getPasswordHash() {
        if (this._passwordRecord == null) {
            return 0;
        }
        return this._passwordRecord.getPassword();
    }
}

