/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordBase;

public abstract class RecordAggregate
extends RecordBase {
    public abstract void visitContainedRecords(RecordVisitor var1);

    public final int serialize(int n, byte[] byArray) {
        SerializingRecordVisitor serializingRecordVisitor = new SerializingRecordVisitor(byArray, n);
        this.visitContainedRecords(serializingRecordVisitor);
        return serializingRecordVisitor.countBytesWritten();
    }

    public int getRecordSize() {
        RecordSizingVisitor recordSizingVisitor = new RecordSizingVisitor();
        this.visitContainedRecords(recordSizingVisitor);
        return recordSizingVisitor.getTotalSize();
    }

    public static final class PositionTrackingVisitor
    implements RecordVisitor {
        private final RecordVisitor _rv;
        private int _position;

        public PositionTrackingVisitor(RecordVisitor recordVisitor, int n) {
            this._rv = recordVisitor;
            this._position = n;
        }

        public void visitRecord(Record record) {
            this._position += record.getRecordSize();
            this._rv.visitRecord(record);
        }

        public void setPosition(int n) {
            this._position = n;
        }

        public int getPosition() {
            return this._position;
        }
    }

    private static final class RecordSizingVisitor
    implements RecordVisitor {
        private int _totalSize = 0;

        public int getTotalSize() {
            return this._totalSize;
        }

        public void visitRecord(Record record) {
            this._totalSize += record.getRecordSize();
        }
    }

    private static final class SerializingRecordVisitor
    implements RecordVisitor {
        private final byte[] _data;
        private final int _startOffset;
        private int _countBytesWritten;

        public SerializingRecordVisitor(byte[] byArray, int n) {
            this._data = byArray;
            this._startOffset = n;
            this._countBytesWritten = 0;
        }

        public int countBytesWritten() {
            return this._countBytesWritten;
        }

        public void visitRecord(Record record) {
            int n = this._startOffset + this._countBytesWritten;
            this._countBytesWritten += record.serialize(n, this._data);
        }
    }

    public static interface RecordVisitor {
        public void visitRecord(Record var1);
    }
}

