/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.aggregates;

import ai2.org.apache.poi.hssf.model.RecordStream;
import ai2.org.apache.poi.hssf.record.ColumnInfoRecord;
import ai2.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ColumnInfoRecordsAggregate
extends RecordAggregate {
    private final List<ColumnInfoRecord> records = new ArrayList<ColumnInfoRecord>();

    public ColumnInfoRecordsAggregate() {
    }

    public ColumnInfoRecordsAggregate(RecordStream recordStream) {
        this();
        boolean bl = true;
        ColumnInfoRecord columnInfoRecord = null;
        while (recordStream.peekNextClass() == ColumnInfoRecord.class) {
            ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)recordStream.getNext();
            this.records.add(columnInfoRecord2);
            if (columnInfoRecord != null && CIRComparator.compareColInfos(columnInfoRecord, columnInfoRecord2) > 0) {
                bl = false;
            }
            columnInfoRecord = columnInfoRecord2;
        }
        if (this.records.size() < 1) {
            throw new RuntimeException("No column info records found");
        }
        if (!bl) {
            Collections.sort(this.records, CIRComparator.instance);
        }
    }

    public Object clone() {
        ColumnInfoRecordsAggregate columnInfoRecordsAggregate = new ColumnInfoRecordsAggregate();
        for (int i = 0; i < this.records.size(); ++i) {
            ColumnInfoRecord columnInfoRecord = this.records.get(i);
            columnInfoRecordsAggregate.records.add((ColumnInfoRecord)columnInfoRecord.clone());
        }
        return columnInfoRecordsAggregate;
    }

    public void insertColumn(ColumnInfoRecord columnInfoRecord) {
        this.records.add(columnInfoRecord);
        Collections.sort(this.records, CIRComparator.instance);
    }

    private void insertColumn(int n, ColumnInfoRecord columnInfoRecord) {
        this.records.add(n, columnInfoRecord);
    }

    int getNumColumns() {
        return this.records.size();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        int n = this.records.size();
        if (n < 1) {
            return;
        }
        ColumnInfoRecord columnInfoRecord = null;
        for (int i = 0; i < n; ++i) {
            ColumnInfoRecord columnInfoRecord2 = this.records.get(i);
            recordVisitor.visitRecord(columnInfoRecord2);
            if (columnInfoRecord != null && CIRComparator.compareColInfos(columnInfoRecord, columnInfoRecord2) > 0) {
                throw new RuntimeException("Column info records are out of order");
            }
            columnInfoRecord = columnInfoRecord2;
        }
    }

    private int findStartOfColumnOutlineGroup(int n) {
        ColumnInfoRecord columnInfoRecord;
        int n2;
        ColumnInfoRecord columnInfoRecord2 = this.records.get(n);
        int n3 = columnInfoRecord2.getOutlineLevel();
        for (n2 = n; n2 != 0 && (columnInfoRecord = this.records.get(n2 - 1)).isAdjacentBefore(columnInfoRecord2) && columnInfoRecord.getOutlineLevel() >= n3; --n2) {
            columnInfoRecord2 = columnInfoRecord;
        }
        return n2;
    }

    private int findEndOfColumnOutlineGroup(int n) {
        ColumnInfoRecord columnInfoRecord;
        int n2;
        ColumnInfoRecord columnInfoRecord2 = this.records.get(n);
        int n3 = columnInfoRecord2.getOutlineLevel();
        for (n2 = n; n2 < this.records.size() - 1 && columnInfoRecord2.isAdjacentBefore(columnInfoRecord = this.records.get(n2 + 1)) && columnInfoRecord.getOutlineLevel() >= n3; ++n2) {
            columnInfoRecord2 = columnInfoRecord;
        }
        return n2;
    }

    private ColumnInfoRecord getColInfo(int n) {
        return this.records.get(n);
    }

    private boolean isColumnGroupCollapsed(int n) {
        int n2 = this.findEndOfColumnOutlineGroup(n);
        int n3 = n2 + 1;
        if (n3 >= this.records.size()) {
            return false;
        }
        ColumnInfoRecord columnInfoRecord = this.getColInfo(n3);
        if (!this.getColInfo(n2).isAdjacentBefore(columnInfoRecord)) {
            return false;
        }
        return columnInfoRecord.getCollapsed();
    }

    private boolean isColumnGroupHiddenByParent(int n) {
        ColumnInfoRecord columnInfoRecord;
        int n2 = 0;
        boolean bl = false;
        int n3 = this.findEndOfColumnOutlineGroup(n);
        if (n3 < this.records.size()) {
            ColumnInfoRecord columnInfoRecord2 = this.getColInfo(n3 + 1);
            if (this.getColInfo(n3).isAdjacentBefore(columnInfoRecord2)) {
                n2 = columnInfoRecord2.getOutlineLevel();
                bl = columnInfoRecord2.getHidden();
            }
        }
        int n4 = 0;
        boolean bl2 = false;
        int n5 = this.findStartOfColumnOutlineGroup(n);
        if (n5 > 0 && (columnInfoRecord = this.getColInfo(n5 - 1)).isAdjacentBefore(this.getColInfo(n5))) {
            n4 = columnInfoRecord.getOutlineLevel();
            bl2 = columnInfoRecord.getHidden();
        }
        if (n2 > n4) {
            return bl;
        }
        return bl2;
    }

    public void collapseColumn(int n) {
        int n2 = this.findColInfoIdx(n, 0);
        if (n2 == -1) {
            return;
        }
        int n3 = this.findStartOfColumnOutlineGroup(n2);
        ColumnInfoRecord columnInfoRecord = this.getColInfo(n3);
        int n4 = this.setGroupHidden(n3, columnInfoRecord.getOutlineLevel(), true);
        this.setColumn(n4 + 1, null, null, null, null, Boolean.TRUE);
    }

    private int setGroupHidden(int n, int n2, boolean bl) {
        int n3;
        ColumnInfoRecord columnInfoRecord = this.getColInfo(n3);
        for (n3 = n; n3 < this.records.size(); ++n3) {
            columnInfoRecord.setHidden(bl);
            if (n3 + 1 >= this.records.size()) continue;
            ColumnInfoRecord columnInfoRecord2 = this.getColInfo(n3 + 1);
            if (!columnInfoRecord.isAdjacentBefore(columnInfoRecord2) || columnInfoRecord2.getOutlineLevel() < n2) break;
            columnInfoRecord = columnInfoRecord2;
        }
        return columnInfoRecord.getLastColumn();
    }

    public void expandColumn(int n) {
        int n2 = this.findColInfoIdx(n, 0);
        if (n2 == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(n2)) {
            return;
        }
        int n3 = this.findStartOfColumnOutlineGroup(n2);
        int n4 = this.findEndOfColumnOutlineGroup(n2);
        ColumnInfoRecord columnInfoRecord = this.getColInfo(n4);
        if (!this.isColumnGroupHiddenByParent(n2)) {
            int n5 = columnInfoRecord.getOutlineLevel();
            for (int i = n3; i <= n4; ++i) {
                ColumnInfoRecord columnInfoRecord2 = this.getColInfo(i);
                if (n5 != columnInfoRecord2.getOutlineLevel()) continue;
                columnInfoRecord2.setHidden(false);
            }
        }
        this.setColumn(columnInfoRecord.getLastColumn() + 1, null, null, null, null, Boolean.FALSE);
    }

    private static ColumnInfoRecord copyColInfo(ColumnInfoRecord columnInfoRecord) {
        return (ColumnInfoRecord)columnInfoRecord.clone();
    }

    public void setColumn(int n, Short s, Integer n2, Integer n3, Boolean bl, Boolean bl2) {
        boolean bl3;
        ColumnInfoRecord columnInfoRecord;
        ColumnInfoRecord columnInfoRecord2 = null;
        int n4 = 0;
        for (n4 = 0; n4 < this.records.size(); ++n4) {
            columnInfoRecord = this.records.get(n4);
            if (columnInfoRecord.containsColumn(n)) {
                columnInfoRecord2 = columnInfoRecord;
                break;
            }
            if (columnInfoRecord.getFirstColumn() > n) break;
        }
        if (columnInfoRecord2 == null) {
            columnInfoRecord = new ColumnInfoRecord();
            columnInfoRecord.setFirstColumn(n);
            columnInfoRecord.setLastColumn(n);
            ColumnInfoRecordsAggregate.setColumnInfoFields(columnInfoRecord, s, n2, n3, bl, bl2);
            this.insertColumn(n4, columnInfoRecord);
            this.attemptMergeColInfoRecords(n4);
            return;
        }
        boolean bl4 = s != null && columnInfoRecord2.getXFIndex() != s.shortValue();
        boolean bl5 = n2 != null && columnInfoRecord2.getColumnWidth() != n2.shortValue();
        boolean bl6 = n3 != null && columnInfoRecord2.getOutlineLevel() != n3.intValue();
        boolean bl7 = bl != null && columnInfoRecord2.getHidden() != bl.booleanValue();
        boolean bl8 = bl2 != null && columnInfoRecord2.getCollapsed() != bl2.booleanValue();
        boolean bl9 = bl3 = bl4 || bl5 || bl6 || bl7 || bl8;
        if (!bl3) {
            return;
        }
        if (columnInfoRecord2.getFirstColumn() == n && columnInfoRecord2.getLastColumn() == n) {
            ColumnInfoRecordsAggregate.setColumnInfoFields(columnInfoRecord2, s, n2, n3, bl, bl2);
            this.attemptMergeColInfoRecords(n4);
            return;
        }
        if (columnInfoRecord2.getFirstColumn() == n || columnInfoRecord2.getLastColumn() == n) {
            if (columnInfoRecord2.getFirstColumn() == n) {
                columnInfoRecord2.setFirstColumn(n + 1);
            } else {
                columnInfoRecord2.setLastColumn(n - 1);
                ++n4;
            }
            ColumnInfoRecord columnInfoRecord3 = ColumnInfoRecordsAggregate.copyColInfo(columnInfoRecord2);
            columnInfoRecord3.setFirstColumn(n);
            columnInfoRecord3.setLastColumn(n);
            ColumnInfoRecordsAggregate.setColumnInfoFields(columnInfoRecord3, s, n2, n3, bl, bl2);
            this.insertColumn(n4, columnInfoRecord3);
            this.attemptMergeColInfoRecords(n4);
        } else {
            ColumnInfoRecord columnInfoRecord4 = columnInfoRecord2;
            ColumnInfoRecord columnInfoRecord5 = ColumnInfoRecordsAggregate.copyColInfo(columnInfoRecord2);
            ColumnInfoRecord columnInfoRecord6 = ColumnInfoRecordsAggregate.copyColInfo(columnInfoRecord2);
            int n5 = columnInfoRecord2.getLastColumn();
            columnInfoRecord4.setLastColumn(n - 1);
            columnInfoRecord5.setFirstColumn(n);
            columnInfoRecord5.setLastColumn(n);
            ColumnInfoRecordsAggregate.setColumnInfoFields(columnInfoRecord5, s, n2, n3, bl, bl2);
            this.insertColumn(++n4, columnInfoRecord5);
            columnInfoRecord6.setFirstColumn(n + 1);
            columnInfoRecord6.setLastColumn(n5);
            this.insertColumn(++n4, columnInfoRecord6);
        }
    }

    private static void setColumnInfoFields(ColumnInfoRecord columnInfoRecord, Short s, Integer n, Integer n2, Boolean bl, Boolean bl2) {
        if (s != null) {
            columnInfoRecord.setXFIndex(s.shortValue());
        }
        if (n != null) {
            columnInfoRecord.setColumnWidth(n);
        }
        if (n2 != null) {
            columnInfoRecord.setOutlineLevel(n2.shortValue());
        }
        if (bl != null) {
            columnInfoRecord.setHidden(bl);
        }
        if (bl2 != null) {
            columnInfoRecord.setCollapsed(bl2);
        }
    }

    private int findColInfoIdx(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + n2);
        }
        for (int i = n2; i < this.records.size(); ++i) {
            ColumnInfoRecord columnInfoRecord = this.getColInfo(i);
            if (columnInfoRecord.containsColumn(n)) {
                return i;
            }
            if (columnInfoRecord.getFirstColumn() > n) break;
        }
        return -1;
    }

    private void attemptMergeColInfoRecords(int n) {
        int n2 = this.records.size();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("colInfoIx " + n + " is out of range (0.." + (n2 - 1) + ")");
        }
        ColumnInfoRecord columnInfoRecord = this.getColInfo(n);
        int n3 = n + 1;
        if (n3 < n2 && ColumnInfoRecordsAggregate.mergeColInfoRecords(columnInfoRecord, this.getColInfo(n3))) {
            this.records.remove(n3);
        }
        if (n > 0 && ColumnInfoRecordsAggregate.mergeColInfoRecords(this.getColInfo(n - 1), columnInfoRecord)) {
            this.records.remove(n);
        }
    }

    private static boolean mergeColInfoRecords(ColumnInfoRecord columnInfoRecord, ColumnInfoRecord columnInfoRecord2) {
        if (columnInfoRecord.isAdjacentBefore(columnInfoRecord2) && columnInfoRecord.formatMatches(columnInfoRecord2)) {
            columnInfoRecord.setLastColumn(columnInfoRecord2.getLastColumn());
            return true;
        }
        return false;
    }

    public void groupColumnRange(int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            int n4 = 1;
            int n5 = this.findColInfoIdx(i, n3);
            if (n5 != -1) {
                n4 = this.getColInfo(n5).getOutlineLevel();
                n4 = bl ? ++n4 : --n4;
                n4 = Math.max(0, n4);
                n4 = Math.min(7, n4);
                n3 = Math.max(0, n5 - 1);
            }
            this.setColumn(i, null, null, n4, null, null);
        }
    }

    public ColumnInfoRecord findColumnInfo(int n) {
        int n2 = this.records.size();
        for (int i = 0; i < n2; ++i) {
            ColumnInfoRecord columnInfoRecord = this.getColInfo(i);
            if (!columnInfoRecord.containsColumn(n)) continue;
            return columnInfoRecord;
        }
        return null;
    }

    public int getMaxOutlineLevel() {
        int n = 0;
        int n2 = this.records.size();
        for (int i = 0; i < n2; ++i) {
            ColumnInfoRecord columnInfoRecord = this.getColInfo(i);
            n = Math.max(columnInfoRecord.getOutlineLevel(), n);
        }
        return n;
    }

    public int getOutlineLevel(int n) {
        ColumnInfoRecord columnInfoRecord = this.findColumnInfo(n);
        if (columnInfoRecord != null) {
            return columnInfoRecord.getOutlineLevel();
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CIRComparator
    implements Comparator<ColumnInfoRecord> {
        public static final Comparator<ColumnInfoRecord> instance = new CIRComparator();

        private CIRComparator() {
        }

        @Override
        public int compare(ColumnInfoRecord columnInfoRecord, ColumnInfoRecord columnInfoRecord2) {
            return CIRComparator.compareColInfos(columnInfoRecord, columnInfoRecord2);
        }

        public static int compareColInfos(ColumnInfoRecord columnInfoRecord, ColumnInfoRecord columnInfoRecord2) {
            return columnInfoRecord.getFirstColumn() - columnInfoRecord2.getFirstColumn();
        }
    }
}

