/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class WindowTwoRecord
extends StandardRecord {
    public static final short sid = 574;
    private static final BitField displayFormulas = BitFieldFactory.getInstance(1);
    private static final BitField displayGridlines = BitFieldFactory.getInstance(2);
    private static final BitField displayRowColHeadings = BitFieldFactory.getInstance(4);
    private static final BitField freezePanes = BitFieldFactory.getInstance(8);
    private static final BitField displayZeros = BitFieldFactory.getInstance(16);
    private static final BitField defaultHeader = BitFieldFactory.getInstance(32);
    private static final BitField arabic = BitFieldFactory.getInstance(64);
    private static final BitField displayGuts = BitFieldFactory.getInstance(128);
    private static final BitField freezePanesNoSplit = BitFieldFactory.getInstance(256);
    private static final BitField selected = BitFieldFactory.getInstance(512);
    private static final BitField active = BitFieldFactory.getInstance(1024);
    private static final BitField savedInPageBreakPreview = BitFieldFactory.getInstance(2048);
    private short field_1_options;
    private short field_2_top_row;
    private short field_3_left_col;
    private int field_4_header_color;
    private short field_5_page_break_zoom;
    private short field_6_normal_zoom;
    private int field_7_reserved;

    public WindowTwoRecord() {
    }

    public WindowTwoRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.remaining();
        this.field_1_options = recordInputStream.readShort();
        this.field_2_top_row = recordInputStream.readShort();
        this.field_3_left_col = recordInputStream.readShort();
        this.field_4_header_color = recordInputStream.readInt();
        if (n > 10) {
            this.field_5_page_break_zoom = recordInputStream.readShort();
            this.field_6_normal_zoom = recordInputStream.readShort();
        }
        if (n > 14) {
            this.field_7_reserved = recordInputStream.readInt();
        }
    }

    public void setOptions(short s) {
        this.field_1_options = s;
    }

    public void setDisplayFormulas(boolean bl) {
        this.field_1_options = displayFormulas.setShortBoolean(this.field_1_options, bl);
    }

    public void setDisplayGridlines(boolean bl) {
        this.field_1_options = displayGridlines.setShortBoolean(this.field_1_options, bl);
    }

    public void setDisplayRowColHeadings(boolean bl) {
        this.field_1_options = displayRowColHeadings.setShortBoolean(this.field_1_options, bl);
    }

    public void setFreezePanes(boolean bl) {
        this.field_1_options = freezePanes.setShortBoolean(this.field_1_options, bl);
    }

    public void setDisplayZeros(boolean bl) {
        this.field_1_options = displayZeros.setShortBoolean(this.field_1_options, bl);
    }

    public void setDefaultHeader(boolean bl) {
        this.field_1_options = defaultHeader.setShortBoolean(this.field_1_options, bl);
    }

    public void setArabic(boolean bl) {
        this.field_1_options = arabic.setShortBoolean(this.field_1_options, bl);
    }

    public void setDisplayGuts(boolean bl) {
        this.field_1_options = displayGuts.setShortBoolean(this.field_1_options, bl);
    }

    public void setFreezePanesNoSplit(boolean bl) {
        this.field_1_options = freezePanesNoSplit.setShortBoolean(this.field_1_options, bl);
    }

    public void setSelected(boolean bl) {
        this.field_1_options = selected.setShortBoolean(this.field_1_options, bl);
    }

    public void setActive(boolean bl) {
        this.field_1_options = active.setShortBoolean(this.field_1_options, bl);
    }

    public void setPaged(boolean bl) {
        this.setActive(bl);
    }

    public void setSavedInPageBreakPreview(boolean bl) {
        this.field_1_options = savedInPageBreakPreview.setShortBoolean(this.field_1_options, bl);
    }

    public void setTopRow(short s) {
        this.field_2_top_row = s;
    }

    public void setLeftCol(short s) {
        this.field_3_left_col = s;
    }

    public void setHeaderColor(int n) {
        this.field_4_header_color = n;
    }

    public void setPageBreakZoom(short s) {
        this.field_5_page_break_zoom = s;
    }

    public void setNormalZoom(short s) {
        this.field_6_normal_zoom = s;
    }

    public void setReserved(int n) {
        this.field_7_reserved = n;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public boolean getDisplayFormulas() {
        return displayFormulas.isSet(this.field_1_options);
    }

    public boolean getDisplayGridlines() {
        return displayGridlines.isSet(this.field_1_options);
    }

    public boolean getDisplayRowColHeadings() {
        return displayRowColHeadings.isSet(this.field_1_options);
    }

    public boolean getFreezePanes() {
        return freezePanes.isSet(this.field_1_options);
    }

    public boolean getDisplayZeros() {
        return displayZeros.isSet(this.field_1_options);
    }

    public boolean getDefaultHeader() {
        return defaultHeader.isSet(this.field_1_options);
    }

    public boolean getArabic() {
        return arabic.isSet(this.field_1_options);
    }

    public boolean getDisplayGuts() {
        return displayGuts.isSet(this.field_1_options);
    }

    public boolean getFreezePanesNoSplit() {
        return freezePanesNoSplit.isSet(this.field_1_options);
    }

    public boolean getSelected() {
        return selected.isSet(this.field_1_options);
    }

    public boolean isActive() {
        return active.isSet(this.field_1_options);
    }

    public boolean getPaged() {
        return this.isActive();
    }

    public boolean getSavedInPageBreakPreview() {
        return savedInPageBreakPreview.isSet(this.field_1_options);
    }

    public short getTopRow() {
        return this.field_2_top_row;
    }

    public short getLeftCol() {
        return this.field_3_left_col;
    }

    public int getHeaderColor() {
        return this.field_4_header_color;
    }

    public short getPageBreakZoom() {
        return this.field_5_page_break_zoom;
    }

    public short getNormalZoom() {
        return this.field_6_normal_zoom;
    }

    public int getReserved() {
        return this.field_7_reserved;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WINDOW2]\n");
        stringBuffer.append("    .options        = ").append(Integer.toHexString(this.getOptions())).append("\n");
        stringBuffer.append("       .dispformulas= ").append(this.getDisplayFormulas()).append("\n");
        stringBuffer.append("       .dispgridlins= ").append(this.getDisplayGridlines()).append("\n");
        stringBuffer.append("       .disprcheadin= ").append(this.getDisplayRowColHeadings()).append("\n");
        stringBuffer.append("       .freezepanes = ").append(this.getFreezePanes()).append("\n");
        stringBuffer.append("       .displayzeros= ").append(this.getDisplayZeros()).append("\n");
        stringBuffer.append("       .defaultheadr= ").append(this.getDefaultHeader()).append("\n");
        stringBuffer.append("       .arabic      = ").append(this.getArabic()).append("\n");
        stringBuffer.append("       .displayguts = ").append(this.getDisplayGuts()).append("\n");
        stringBuffer.append("       .frzpnsnosplt= ").append(this.getFreezePanesNoSplit()).append("\n");
        stringBuffer.append("       .selected    = ").append(this.getSelected()).append("\n");
        stringBuffer.append("       .active       = ").append(this.isActive()).append("\n");
        stringBuffer.append("       .svdinpgbrkpv= ").append(this.getSavedInPageBreakPreview()).append("\n");
        stringBuffer.append("    .toprow         = ").append(Integer.toHexString(this.getTopRow())).append("\n");
        stringBuffer.append("    .leftcol        = ").append(Integer.toHexString(this.getLeftCol())).append("\n");
        stringBuffer.append("    .headercolor    = ").append(Integer.toHexString(this.getHeaderColor())).append("\n");
        stringBuffer.append("    .pagebreakzoom  = ").append(Integer.toHexString(this.getPageBreakZoom())).append("\n");
        stringBuffer.append("    .normalzoom     = ").append(Integer.toHexString(this.getNormalZoom())).append("\n");
        stringBuffer.append("    .reserved       = ").append(Integer.toHexString(this.getReserved())).append("\n");
        stringBuffer.append("[/WINDOW2]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getOptions());
        littleEndianOutput.writeShort(this.getTopRow());
        littleEndianOutput.writeShort(this.getLeftCol());
        littleEndianOutput.writeInt(this.getHeaderColor());
        littleEndianOutput.writeShort(this.getPageBreakZoom());
        littleEndianOutput.writeShort(this.getNormalZoom());
        littleEndianOutput.writeInt(this.getReserved());
    }

    protected int getDataSize() {
        return 18;
    }

    public short getSid() {
        return 574;
    }

    public Object clone() {
        WindowTwoRecord windowTwoRecord = new WindowTwoRecord();
        windowTwoRecord.field_1_options = this.field_1_options;
        windowTwoRecord.field_2_top_row = this.field_2_top_row;
        windowTwoRecord.field_3_left_col = this.field_3_left_col;
        windowTwoRecord.field_4_header_color = this.field_4_header_color;
        windowTwoRecord.field_5_page_break_zoom = this.field_5_page_break_zoom;
        windowTwoRecord.field_6_normal_zoom = this.field_6_normal_zoom;
        windowTwoRecord.field_7_reserved = this.field_7_reserved;
        return windowTwoRecord;
    }
}

