/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.ExtSSTRecord;
import ai2.org.apache.poi.hssf.record.common.UnicodeString;
import ai2.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import ai2.org.apache.poi.util.IntMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SSTSerializer {
    private final int _numStrings;
    private final int _numUniqueStrings;
    private final IntMapper<UnicodeString> strings;
    private final int[] bucketAbsoluteOffsets;
    private final int[] bucketRelativeOffsets;

    public SSTSerializer(IntMapper<UnicodeString> intMapper, int n, int n2) {
        this.strings = intMapper;
        this._numStrings = n;
        this._numUniqueStrings = n2;
        int n3 = ExtSSTRecord.getNumberOfInfoRecsForStrings(intMapper.size());
        this.bucketAbsoluteOffsets = new int[n3];
        this.bucketRelativeOffsets = new int[n3];
    }

    public void serialize(ContinuableRecordOutput continuableRecordOutput) {
        continuableRecordOutput.writeInt(this._numStrings);
        continuableRecordOutput.writeInt(this._numUniqueStrings);
        for (int i = 0; i < this.strings.size(); ++i) {
            if (i % 8 == 0) {
                int n = continuableRecordOutput.getTotalSize();
                int n2 = i / 8;
                if (n2 < 128) {
                    this.bucketAbsoluteOffsets[n2] = n;
                    this.bucketRelativeOffsets[n2] = n;
                }
            }
            UnicodeString unicodeString = this.getUnicodeString(i);
            unicodeString.serialize(continuableRecordOutput);
        }
    }

    private UnicodeString getUnicodeString(int n) {
        return SSTSerializer.getUnicodeString(this.strings, n);
    }

    private static UnicodeString getUnicodeString(IntMapper<UnicodeString> intMapper, int n) {
        return intMapper.get(n);
    }

    public int[] getBucketAbsoluteOffsets() {
        return this.bucketAbsoluteOffsets;
    }

    public int[] getBucketRelativeOffsets() {
        return this.bucketRelativeOffsets;
    }
}

