/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.BiffHeaderInput;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordFactory;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.crypto.Biff8DecryptingStream;
import ai2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Locale;

public final class RecordInputStream
implements LittleEndianInput {
    public static final short MAX_RECORD_DATA_SIZE = 8224;
    private static final int INVALID_SID_VALUE = -1;
    private static final int DATA_LEN_NEEDS_TO_BE_READ = -1;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final BiffHeaderInput _bhi;
    private final LittleEndianInput _dataInput;
    private int _currentSid;
    private int _currentDataLength;
    private int _nextSid;
    private int _currentDataOffset;

    public RecordInputStream(InputStream inputStream) throws RecordFormatException {
        this(inputStream, null, 0);
    }

    public RecordInputStream(InputStream inputStream, Biff8EncryptionKey biff8EncryptionKey, int n) throws RecordFormatException {
        if (biff8EncryptionKey == null) {
            this._dataInput = RecordInputStream.getLEI(inputStream);
            this._bhi = new SimpleHeaderInput(inputStream);
        } else {
            Biff8DecryptingStream biff8DecryptingStream = new Biff8DecryptingStream(inputStream, n, biff8EncryptionKey);
            this._bhi = biff8DecryptingStream;
            this._dataInput = biff8DecryptingStream;
        }
        this._nextSid = this.readNextSid();
    }

    static LittleEndianInput getLEI(InputStream inputStream) {
        if (inputStream instanceof LittleEndianInput) {
            return (LittleEndianInput)((Object)inputStream);
        }
        return new LittleEndianInputStream(inputStream);
    }

    public int available() {
        return this.remaining();
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, this.remaining());
        if (n3 == 0) {
            return 0;
        }
        this.readFully(byArray, n, n3);
        return n3;
    }

    public short getSid() {
        return (short)this._currentSid;
    }

    public boolean hasNextRecord() throws LeftoverDataException {
        if (this._currentDataLength != -1 && this._currentDataLength != this._currentDataOffset) {
            throw new LeftoverDataException(this._currentSid, this.remaining());
        }
        if (this._currentDataLength != -1) {
            this._nextSid = this.readNextSid();
        }
        return this._nextSid != -1;
    }

    private int readNextSid() {
        int n = this._bhi.available();
        if (n < 4) {
            if (n > 0) {
                // empty if block
            }
            return -1;
        }
        int n2 = this._bhi.readRecordSID();
        if (n2 == -1) {
            throw new RecordFormatException("Found invalid sid (" + n2 + ")");
        }
        this._currentDataLength = -1;
        return n2;
    }

    public void nextRecord() throws RecordFormatException {
        if (this._nextSid == -1) {
            throw new IllegalStateException("EOF - next record not available");
        }
        if (this._currentDataLength != -1) {
            throw new IllegalStateException("Cannot call nextRecord() without checking hasNextRecord() first");
        }
        this._currentSid = this._nextSid;
        this._currentDataOffset = 0;
        this._currentDataLength = this._bhi.readDataSize();
        if (this._currentDataLength > 8224) {
            throw new RecordFormatException("The content of an excel record cannot exceed 8224 bytes");
        }
    }

    private void checkRecordPosition(int n) {
        int n2 = this.remaining();
        if (n2 >= n) {
            return;
        }
        if (n2 == 0 && this.isContinueNext()) {
            this.nextRecord();
            return;
        }
        throw new RecordFormatException("Not enough data (" + n2 + ") to read requested (" + n + ") bytes");
    }

    public byte readByte() {
        this.checkRecordPosition(1);
        ++this._currentDataOffset;
        return this._dataInput.readByte();
    }

    public short readShort() {
        this.checkRecordPosition(2);
        this._currentDataOffset += 2;
        return this._dataInput.readShort();
    }

    public int readInt() {
        this.checkRecordPosition(4);
        this._currentDataOffset += 4;
        return this._dataInput.readInt();
    }

    public long readLong() {
        this.checkRecordPosition(8);
        this._currentDataOffset += 8;
        return this._dataInput.readLong();
    }

    public int readUByte() {
        return this.readByte() & 0xFF;
    }

    public int readUShort() {
        this.checkRecordPosition(2);
        this._currentDataOffset += 2;
        return this._dataInput.readUShort();
    }

    public double readDouble() {
        long l = this.readLong();
        double d = Double.longBitsToDouble(l);
        if (Double.isNaN(d)) {
            // empty if block
        }
        return d;
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        int n3 = n2;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        while (n2 > 0) {
            int n4 = Math.min(this.available(), n2);
            if (n4 == 0) {
                if (!this.hasNextRecord()) {
                    throw new RecordFormatException("Can't read the remaining " + n2 + " bytes of the requested " + n3 + " bytes. No further record exists.");
                }
                this.nextRecord();
                n4 = Math.min(this.available(), n2);
                assert (n4 > 0);
            }
            this.checkRecordPosition(n4);
            this._dataInput.readFully(byArray, n, n4);
            this._currentDataOffset += n4;
            n += n4;
            n2 -= n4;
        }
    }

    public String readString() {
        int n = this.readUShort();
        byte by = this.readByte();
        return this.readStringCommon(n, by == 0);
    }

    public String readUnicodeLEString(int n) {
        return this.readStringCommon(n, false);
    }

    public String readCompressedUnicode(int n) {
        return this.readStringCommon(n, true);
    }

    private String readStringCommon(int n, boolean bl) {
        if (n < 0 || n > 0x100000) {
            throw new IllegalArgumentException("Bad requested string length (" + n + ")");
        }
        char[] cArray = new char[n];
        boolean bl2 = bl;
        int n2 = 0;
        while (true) {
            char c;
            int n3;
            int n4 = n3 = bl2 ? this.remaining() : this.remaining() / 2;
            if (n - n2 <= n3) {
                while (n2 < n) {
                    c = bl2 ? (char)this.readUByte() : (char)this.readShort();
                    cArray[n2] = c;
                    ++n2;
                }
                return new String(cArray);
            }
            while (n3 > 0) {
                c = bl2 ? (char)this.readUByte() : (char)this.readShort();
                cArray[n2] = c;
                ++n2;
                --n3;
            }
            if (!this.isContinueNext()) {
                throw new RecordFormatException("Expected to find a ContinueRecord in order to read remaining " + (n - n2) + " of " + n + " chars");
            }
            if (this.remaining() != 0) {
                throw new RecordFormatException("Odd number of bytes(" + this.remaining() + ") left behind");
            }
            this.nextRecord();
            c = (char)this.readByte();
            assert (c == '\u0000' || c == '\u0001');
            bl2 = c == '\u0000';
        }
    }

    public byte[] readRemainder() {
        int n = this.remaining();
        if (n == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public byte[] readAllContinuedRemainder() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16448);
        while (true) {
            byte[] byArray = this.readRemainder();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (!this.isContinueNext()) break;
            this.nextRecord();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int remaining() {
        if (this._currentDataLength == -1) {
            return 0;
        }
        return this._currentDataLength - this._currentDataOffset;
    }

    private boolean isContinueNext() {
        if (this._currentDataLength != -1 && this._currentDataOffset != this._currentDataLength) {
            throw new IllegalStateException("Should never be called before end of current record");
        }
        if (!this.hasNextRecord()) {
            return false;
        }
        return this._nextSid == 60;
    }

    public int getNextSid() {
        return this._nextSid;
    }

    private static final class SimpleHeaderInput
    implements BiffHeaderInput {
        private final LittleEndianInput _lei;

        public SimpleHeaderInput(InputStream inputStream) {
            this._lei = RecordInputStream.getLEI(inputStream);
        }

        public int available() {
            return this._lei.available();
        }

        public int readDataSize() {
            return this._lei.readUShort();
        }

        public int readRecordSID() {
            return this._lei.readUShort();
        }
    }

    public static final class LeftoverDataException
    extends RuntimeException {
        public LeftoverDataException(int n, int n2) {
            super("Initialisation of record 0x" + Integer.toHexString(n).toUpperCase(Locale.ROOT) + "(" + LeftoverDataException.getRecordName(n) + ") left " + n2 + " bytes remaining still to be read.");
        }

        private static String getRecordName(int n) {
            Class<? extends Record> clazz = RecordFactory.getRecordClass(n);
            if (clazz == null) {
                return null;
            }
            return clazz.getSimpleName();
        }
    }
}

