/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CodepageRecord;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.util.CodePageUtil;
import java.io.UnsupportedEncodingException;

public final class OldStringRecord {
    public static final short biff2_sid = 7;
    public static final short biff345_sid = 519;
    private short sid;
    private short field_1_string_len;
    private byte[] field_2_bytes;
    private CodepageRecord codepage;

    public OldStringRecord(RecordInputStream recordInputStream) {
        this.sid = recordInputStream.getSid();
        this.field_1_string_len = recordInputStream.getSid() == 7 ? (short)recordInputStream.readUByte() : recordInputStream.readShort();
        this.field_2_bytes = new byte[this.field_1_string_len];
        recordInputStream.read(this.field_2_bytes, 0, this.field_1_string_len);
    }

    public boolean isBiff2() {
        return this.sid == 7;
    }

    public short getSid() {
        return this.sid;
    }

    public void setCodePage(CodepageRecord codepageRecord) {
        this.codepage = codepageRecord;
    }

    public String getString() {
        return OldStringRecord.getString(this.field_2_bytes, this.codepage);
    }

    protected static String getString(byte[] byArray, CodepageRecord codepageRecord) {
        int n = 28591;
        if (codepageRecord != null) {
            n = codepageRecord.getCodepage() & 0xFFFF;
        }
        try {
            return CodePageUtil.getStringFromCodePage(byArray, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unsupported codepage requested", unsupportedEncodingException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[OLD STRING]\n");
        stringBuffer.append("    .string            = ").append(this.getString()).append("\n");
        stringBuffer.append("[/OLD STRING]\n");
        return stringBuffer.toString();
    }
}

