/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CodepageRecord;
import ai2.org.apache.poi.hssf.record.OldStringRecord;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.util.HexDump;

public final class OldSheetRecord {
    public static final short sid = 133;
    private int field_1_position_of_BOF;
    private int field_2_visibility;
    private int field_3_type;
    private byte[] field_5_sheetname;
    private CodepageRecord codepage;

    public OldSheetRecord(RecordInputStream recordInputStream) {
        this.field_1_position_of_BOF = recordInputStream.readInt();
        this.field_2_visibility = recordInputStream.readUByte();
        this.field_3_type = recordInputStream.readUByte();
        int n = recordInputStream.readUByte();
        this.field_5_sheetname = new byte[n];
        recordInputStream.read(this.field_5_sheetname, 0, n);
    }

    public void setCodePage(CodepageRecord codepageRecord) {
        this.codepage = codepageRecord;
    }

    public short getSid() {
        return 133;
    }

    public int getPositionOfBof() {
        return this.field_1_position_of_BOF;
    }

    public String getSheetname() {
        return OldStringRecord.getString(this.field_5_sheetname, this.codepage);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BOUNDSHEET]\n");
        stringBuffer.append("    .bof        = ").append(HexDump.intToHex(this.getPositionOfBof())).append("\n");
        stringBuffer.append("    .visibility = ").append(HexDump.shortToHex(this.field_2_visibility)).append("\n");
        stringBuffer.append("    .type       = ").append(HexDump.byteToHex(this.field_3_type)).append("\n");
        stringBuffer.append("    .sheetname  = ").append(this.getSheetname()).append("\n");
        stringBuffer.append("[/BOUNDSHEET]\n");
        return stringBuffer.toString();
    }
}

