/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;

public final class NameCommentRecord
extends StandardRecord {
    public static final short sid = 2196;
    private final short field_1_record_type;
    private final short field_2_frt_cell_ref_flag;
    private final long field_3_reserved;
    private String field_6_name_text;
    private String field_7_comment_text;

    public NameCommentRecord(String string, String string2) {
        this.field_1_record_type = 0;
        this.field_2_frt_cell_ref_flag = 0;
        this.field_3_reserved = 0L;
        this.field_6_name_text = string;
        this.field_7_comment_text = string2;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this.field_6_name_text.length();
        int n2 = this.field_7_comment_text.length();
        littleEndianOutput.writeShort(this.field_1_record_type);
        littleEndianOutput.writeShort(this.field_2_frt_cell_ref_flag);
        littleEndianOutput.writeLong(this.field_3_reserved);
        littleEndianOutput.writeShort(n);
        littleEndianOutput.writeShort(n2);
        boolean bl = StringUtil.hasMultibyte(this.field_6_name_text);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(this.field_6_name_text, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(this.field_6_name_text, littleEndianOutput);
        }
        boolean bl2 = StringUtil.hasMultibyte(this.field_7_comment_text);
        littleEndianOutput.writeByte(bl2 ? 1 : 0);
        if (bl2) {
            StringUtil.putUnicodeLE(this.field_7_comment_text, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(this.field_7_comment_text, littleEndianOutput);
        }
    }

    protected int getDataSize() {
        return 18 + (StringUtil.hasMultibyte(this.field_6_name_text) ? this.field_6_name_text.length() * 2 : this.field_6_name_text.length()) + (StringUtil.hasMultibyte(this.field_7_comment_text) ? this.field_7_comment_text.length() * 2 : this.field_7_comment_text.length());
    }

    public NameCommentRecord(RecordInputStream recordInputStream) {
        RecordInputStream recordInputStream2 = recordInputStream;
        this.field_1_record_type = recordInputStream2.readShort();
        this.field_2_frt_cell_ref_flag = recordInputStream2.readShort();
        this.field_3_reserved = recordInputStream2.readLong();
        short s = recordInputStream2.readShort();
        short s2 = recordInputStream2.readShort();
        this.field_6_name_text = recordInputStream2.readByte() == 0 ? StringUtil.readCompressedUnicode(recordInputStream2, s) : StringUtil.readUnicodeLE(recordInputStream2, s);
        this.field_7_comment_text = recordInputStream2.readByte() == 0 ? StringUtil.readCompressedUnicode(recordInputStream2, s2) : StringUtil.readUnicodeLE(recordInputStream2, s2);
    }

    public short getSid() {
        return 2196;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[NAMECMT]\n");
        stringBuffer.append("    .record type            = ").append(HexDump.shortToHex(this.field_1_record_type)).append("\n");
        stringBuffer.append("    .frt cell ref flag      = ").append(HexDump.byteToHex(this.field_2_frt_cell_ref_flag)).append("\n");
        stringBuffer.append("    .reserved               = ").append(this.field_3_reserved).append("\n");
        stringBuffer.append("    .name length            = ").append(this.field_6_name_text.length()).append("\n");
        stringBuffer.append("    .comment length         = ").append(this.field_7_comment_text.length()).append("\n");
        stringBuffer.append("    .name                   = ").append(this.field_6_name_text).append("\n");
        stringBuffer.append("    .comment                = ").append(this.field_7_comment_text).append("\n");
        stringBuffer.append("[/NAMECMT]\n");
        return stringBuffer.toString();
    }

    public String getNameText() {
        return this.field_6_name_text;
    }

    public void setNameText(String string) {
        this.field_6_name_text = string;
    }

    public String getCommentText() {
        return this.field_7_comment_text;
    }

    public void setCommentText(String string) {
        this.field_7_comment_text = string;
    }

    public short getRecordType() {
        return this.field_1_record_type;
    }
}

