/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public final class LabelRecord
extends Record
implements CellValueRecordInterface {
    private static final POILogger logger = POILogFactory.getLogger(LabelRecord.class);
    public static final short sid = 516;
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf_index;
    private short field_4_string_len;
    private byte field_5_unicode_flag;
    private String field_6_value;

    public LabelRecord() {
    }

    public LabelRecord(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_column = recordInputStream.readShort();
        this.field_3_xf_index = recordInputStream.readShort();
        this.field_4_string_len = recordInputStream.readShort();
        this.field_5_unicode_flag = recordInputStream.readByte();
        this.field_6_value = this.field_4_string_len > 0 ? (this.isUnCompressedUnicode() ? recordInputStream.readUnicodeLEString(this.field_4_string_len) : recordInputStream.readCompressedUnicode(this.field_4_string_len)) : "";
        if (recordInputStream.remaining() > 0) {
            logger.log(3, new Object[]{"LabelRecord data remains: " + recordInputStream.remaining() + " : " + HexDump.toHex(recordInputStream.readRemainder())});
        }
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public short getStringLength() {
        return this.field_4_string_len;
    }

    public boolean isUnCompressedUnicode() {
        return (this.field_5_unicode_flag & 1) != 0;
    }

    public String getValue() {
        return this.field_6_value;
    }

    public int serialize(int n, byte[] byArray) {
        throw new RecordFormatException("Label Records are supported READ ONLY...convert to LabelSST");
    }

    public int getRecordSize() {
        throw new RecordFormatException("Label Records are supported READ ONLY...convert to LabelSST");
    }

    public short getSid() {
        return 516;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[LABEL]\n");
        stringBuffer.append("    .row       = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        stringBuffer.append("    .column    = ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        stringBuffer.append("    .xfindex   = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        stringBuffer.append("    .string_len= ").append(HexDump.shortToHex(this.field_4_string_len)).append("\n");
        stringBuffer.append("    .unicode_flag= ").append(HexDump.byteToHex(this.field_5_unicode_flag)).append("\n");
        stringBuffer.append("    .value       = ").append(this.getValue()).append("\n");
        stringBuffer.append("[/LABEL]\n");
        return stringBuffer.toString();
    }

    public void setColumn(short s) {
    }

    public void setRow(int n) {
    }

    public void setXFIndex(short s) {
    }

    public Object clone() {
        LabelRecord labelRecord = new LabelRecord();
        labelRecord.field_1_row = this.field_1_row;
        labelRecord.field_2_column = this.field_2_column;
        labelRecord.field_3_xf_index = this.field_3_xf_index;
        labelRecord.field_4_string_len = this.field_4_string_len;
        labelRecord.field_5_unicode_flag = this.field_5_unicode_flag;
        labelRecord.field_6_value = this.field_6_value;
        return labelRecord;
    }
}

