/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class IterationRecord
extends StandardRecord {
    public static final short sid = 17;
    private static final BitField iterationOn = BitFieldFactory.getInstance(1);
    private int _flags;

    public IterationRecord(boolean bl) {
        this._flags = iterationOn.setBoolean(0, bl);
    }

    public IterationRecord(RecordInputStream recordInputStream) {
        this._flags = recordInputStream.readShort();
    }

    public void setIteration(boolean bl) {
        this._flags = iterationOn.setBoolean(this._flags, bl);
    }

    public boolean getIteration() {
        return iterationOn.isSet(this._flags);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ITERATION]\n");
        stringBuffer.append("    .flags      = ").append(HexDump.shortToHex(this._flags)).append("\n");
        stringBuffer.append("[/ITERATION]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._flags);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 17;
    }

    public Object clone() {
        return new IterationRecord(this.getIteration());
    }
}

