/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class FilePassRecord
extends StandardRecord {
    public static final short sid = 47;
    private int _encryptionType;
    private KeyData _keyData;
    private static final int ENCRYPTION_XOR = 0;
    private static final int ENCRYPTION_OTHER = 1;

    public FilePassRecord(RecordInputStream recordInputStream) {
        this._encryptionType = recordInputStream.readUShort();
        switch (this._encryptionType) {
            case 0: {
                this._keyData = new XorKeyData();
                break;
            }
            case 1: {
                this._keyData = new Rc4KeyData();
                break;
            }
            default: {
                throw new RecordFormatException("Unknown encryption type " + this._encryptionType);
            }
        }
        this._keyData.read(recordInputStream);
    }

    private static byte[] read(RecordInputStream recordInputStream, int n) {
        byte[] byArray = new byte[n];
        recordInputStream.readFully(byArray);
        return byArray;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._encryptionType);
        assert (this._keyData != null);
        this._keyData.serialize(littleEndianOutput);
    }

    protected int getDataSize() {
        assert (this._keyData != null);
        return this._keyData.getDataSize();
    }

    public Rc4KeyData getRc4KeyData() {
        return this._keyData instanceof Rc4KeyData ? (Rc4KeyData)this._keyData : null;
    }

    public XorKeyData getXorKeyData() {
        return this._keyData instanceof XorKeyData ? (XorKeyData)this._keyData : null;
    }

    private Rc4KeyData checkRc4() {
        Rc4KeyData rc4KeyData = this.getRc4KeyData();
        if (rc4KeyData == null) {
            throw new RecordFormatException("file pass record doesn't contain a rc4 key.");
        }
        return rc4KeyData;
    }

    public byte[] getDocId() {
        return this.checkRc4().getSalt();
    }

    public void setDocId(byte[] byArray) {
        this.checkRc4().setSalt(byArray);
    }

    public byte[] getSaltData() {
        return this.checkRc4().getEncryptedVerifier();
    }

    public void setSaltData(byte[] byArray) {
        this.getRc4KeyData().setEncryptedVerifier(byArray);
    }

    public byte[] getSaltHash() {
        return this.getRc4KeyData().getEncryptedVerifierHash();
    }

    public void setSaltHash(byte[] byArray) {
        this.getRc4KeyData().setEncryptedVerifierHash(byArray);
    }

    public short getSid() {
        return 47;
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FILEPASS]\n");
        stringBuffer.append("    .type = ").append(HexDump.shortToHex(this._encryptionType)).append("\n");
        this._keyData.appendToString(stringBuffer);
        stringBuffer.append("[/FILEPASS]\n");
        return stringBuffer.toString();
    }

    public static class XorKeyData
    implements KeyData {
        private int _key;
        private int _verifier;

        public void read(RecordInputStream recordInputStream) {
            this._key = recordInputStream.readUShort();
            this._verifier = recordInputStream.readUShort();
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._key);
            littleEndianOutput.writeShort(this._verifier);
        }

        public int getDataSize() {
            return 6;
        }

        public int getKey() {
            return this._key;
        }

        public int getVerifier() {
            return this._verifier;
        }

        public void setKey(int n) {
            this._key = n;
        }

        public void setVerifier(int n) {
            this._verifier = n;
        }

        public void appendToString(StringBuffer stringBuffer) {
            stringBuffer.append("    .xor.key = ").append(HexDump.intToHex(this._key)).append("\n");
            stringBuffer.append("    .xor.verifier  = ").append(HexDump.intToHex(this._verifier)).append("\n");
        }
    }

    public static class Rc4KeyData
    implements KeyData {
        private static final int ENCRYPTION_OTHER_RC4 = 1;
        private static final int ENCRYPTION_OTHER_CAPI_2 = 2;
        private static final int ENCRYPTION_OTHER_CAPI_3 = 3;
        private static final int ENCRYPTION_OTHER_CAPI_4 = 4;
        private byte[] _salt;
        private byte[] _encryptedVerifier;
        private byte[] _encryptedVerifierHash;
        private int _encryptionInfo;
        private int _minorVersionNo;

        public void read(RecordInputStream recordInputStream) {
            this._encryptionInfo = recordInputStream.readUShort();
            switch (this._encryptionInfo) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    throw new EncryptedDocumentException("HSSF does not currently support CryptoAPI encryption");
                }
                default: {
                    throw new RecordFormatException("Unknown encryption info " + this._encryptionInfo);
                }
            }
            this._minorVersionNo = recordInputStream.readUShort();
            if (this._minorVersionNo != 1) {
                throw new RecordFormatException("Unexpected VersionInfo number for RC4Header " + this._minorVersionNo);
            }
            this._salt = FilePassRecord.read(recordInputStream, 16);
            this._encryptedVerifier = FilePassRecord.read(recordInputStream, 16);
            this._encryptedVerifierHash = FilePassRecord.read(recordInputStream, 16);
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._encryptionInfo);
            littleEndianOutput.writeShort(this._minorVersionNo);
            littleEndianOutput.write(this._salt);
            littleEndianOutput.write(this._encryptedVerifier);
            littleEndianOutput.write(this._encryptedVerifierHash);
        }

        public int getDataSize() {
            return 54;
        }

        public byte[] getSalt() {
            return (byte[])this._salt.clone();
        }

        public void setSalt(byte[] byArray) {
            this._salt = (byte[])byArray.clone();
        }

        public byte[] getEncryptedVerifier() {
            return (byte[])this._encryptedVerifier.clone();
        }

        public void setEncryptedVerifier(byte[] byArray) {
            this._encryptedVerifier = (byte[])byArray.clone();
        }

        public byte[] getEncryptedVerifierHash() {
            return (byte[])this._encryptedVerifierHash.clone();
        }

        public void setEncryptedVerifierHash(byte[] byArray) {
            this._encryptedVerifierHash = (byte[])byArray.clone();
        }

        public void appendToString(StringBuffer stringBuffer) {
            stringBuffer.append("    .rc4.info = ").append(HexDump.shortToHex(this._encryptionInfo)).append("\n");
            stringBuffer.append("    .rc4.ver  = ").append(HexDump.shortToHex(this._minorVersionNo)).append("\n");
            stringBuffer.append("    .rc4.salt = ").append(HexDump.toHex(this._salt)).append("\n");
            stringBuffer.append("    .rc4.verifier = ").append(HexDump.toHex(this._encryptedVerifier)).append("\n");
            stringBuffer.append("    .rc4.verifierHash = ").append(HexDump.toHex(this._encryptedVerifierHash)).append("\n");
        }
    }

    private static interface KeyData {
        public void read(RecordInputStream var1);

        public void serialize(LittleEndianOutput var1);

        public int getDataSize();

        public void appendToString(StringBuffer var1);
    }
}

