/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.ArrayList;
import java.util.List;

public class ExternSheetRecord
extends StandardRecord {
    public static final short sid = 23;
    private List<RefSubRecord> _list = new ArrayList<RefSubRecord>();

    public ExternSheetRecord() {
    }

    public ExternSheetRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            RefSubRecord refSubRecord = new RefSubRecord(recordInputStream);
            this._list.add(refSubRecord);
        }
    }

    public int getNumOfRefs() {
        return this._list.size();
    }

    public void addREFRecord(RefSubRecord refSubRecord) {
        this._list.add(refSubRecord);
    }

    public int getNumOfREFRecords() {
        return this._list.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._list.size();
        stringBuffer.append("[EXTERNSHEET]\n");
        stringBuffer.append("   numOfRefs     = ").append(n).append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("refrec         #").append(i).append(": ");
            stringBuffer.append(this.getRef(i).toString());
            stringBuffer.append('\n');
        }
        stringBuffer.append("[/EXTERNSHEET]\n");
        return stringBuffer.toString();
    }

    protected int getDataSize() {
        return 2 + this._list.size() * 6;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this._list.size();
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.getRef(i).serialize(littleEndianOutput);
        }
    }

    private RefSubRecord getRef(int n) {
        return this._list.get(n);
    }

    @Deprecated
    public void adjustIndex(int n, int n2) {
        this.getRef(n).adjustIndex(n2);
    }

    public void removeSheet(int n) {
        int n2 = this._list.size();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            RefSubRecord refSubRecord = this._list.get(i);
            if (refSubRecord.getFirstSheetIndex() == n && refSubRecord.getLastSheetIndex() == n) {
                n3 = i;
                continue;
            }
            if (refSubRecord.getFirstSheetIndex() <= n || refSubRecord.getLastSheetIndex() <= n) continue;
            this._list.set(i, new RefSubRecord(refSubRecord.getExtBookIndex(), refSubRecord.getFirstSheetIndex() - 1, refSubRecord.getLastSheetIndex() - 1));
        }
        if (n3 != -1) {
            this._list.remove(n3);
        }
    }

    public short getSid() {
        return 23;
    }

    public int getExtbookIndexFromRefIndex(int n) {
        RefSubRecord refSubRecord = this.getRef(n);
        return refSubRecord.getExtBookIndex();
    }

    public int findRefIndexFromExtBookIndex(int n) {
        int n2 = this._list.size();
        for (int i = 0; i < n2; ++i) {
            if (this.getRef(i).getExtBookIndex() != n) continue;
            return i;
        }
        return -1;
    }

    public int getFirstSheetIndexFromRefIndex(int n) {
        return this.getRef(n).getFirstSheetIndex();
    }

    public int getLastSheetIndexFromRefIndex(int n) {
        return this.getRef(n).getLastSheetIndex();
    }

    public int addRef(int n, int n2, int n3) {
        this._list.add(new RefSubRecord(n, n2, n3));
        return this._list.size() - 1;
    }

    public int getRefIxForSheet(int n, int n2, int n3) {
        int n4 = this._list.size();
        for (int i = 0; i < n4; ++i) {
            RefSubRecord refSubRecord = this.getRef(i);
            if (refSubRecord.getExtBookIndex() != n || refSubRecord.getFirstSheetIndex() != n2 || refSubRecord.getLastSheetIndex() != n3) continue;
            return i;
        }
        return -1;
    }

    public static ExternSheetRecord combine(ExternSheetRecord[] externSheetRecordArray) {
        ExternSheetRecord externSheetRecord = new ExternSheetRecord();
        for (int i = 0; i < externSheetRecordArray.length; ++i) {
            ExternSheetRecord externSheetRecord2 = externSheetRecordArray[i];
            int n = externSheetRecord2.getNumOfREFRecords();
            for (int j = 0; j < n; ++j) {
                externSheetRecord.addREFRecord(externSheetRecord2.getRef(j));
            }
        }
        return externSheetRecord;
    }

    private static final class RefSubRecord {
        public static final int ENCODED_SIZE = 6;
        private int _extBookIndex;
        private int _firstSheetIndex;
        private int _lastSheetIndex;

        public void adjustIndex(int n) {
            this._firstSheetIndex += n;
            this._lastSheetIndex += n;
        }

        public RefSubRecord(int n, int n2, int n3) {
            this._extBookIndex = n;
            this._firstSheetIndex = n2;
            this._lastSheetIndex = n3;
        }

        public RefSubRecord(RecordInputStream recordInputStream) {
            this(recordInputStream.readShort(), recordInputStream.readShort(), recordInputStream.readShort());
        }

        public int getExtBookIndex() {
            return this._extBookIndex;
        }

        public int getFirstSheetIndex() {
            return this._firstSheetIndex;
        }

        public int getLastSheetIndex() {
            return this._lastSheetIndex;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("extBook=").append(this._extBookIndex);
            stringBuffer.append(" firstSheet=").append(this._firstSheetIndex);
            stringBuffer.append(" lastSheet=").append(this._lastSheetIndex);
            return stringBuffer.toString();
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._extBookIndex);
            littleEndianOutput.writeShort(this._firstSheetIndex);
            littleEndianOutput.writeShort(this._lastSheetIndex);
        }
    }
}

