/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherSpgrRecord;
import ai2.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import ai2.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai2.org.apache.poi.hssf.record.ContinueRecord;
import ai2.org.apache.poi.hssf.record.DrawingRecord;
import ai2.org.apache.poi.hssf.record.NoteRecord;
import ai2.org.apache.poi.hssf.record.ObjRecord;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordBase;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EscherAggregate
extends AbstractEscherHolderRecord {
    public static final short sid = 9876;
    private static POILogger log = POILogFactory.getLogger(EscherAggregate.class);
    public static final short ST_MIN = 0;
    public static final short ST_NOT_PRIMATIVE = 0;
    public static final short ST_RECTANGLE = 1;
    public static final short ST_ROUNDRECTANGLE = 2;
    public static final short ST_ELLIPSE = 3;
    public static final short ST_DIAMOND = 4;
    public static final short ST_ISOCELESTRIANGLE = 5;
    public static final short ST_RIGHTTRIANGLE = 6;
    public static final short ST_PARALLELOGRAM = 7;
    public static final short ST_TRAPEZOID = 8;
    public static final short ST_HEXAGON = 9;
    public static final short ST_OCTAGON = 10;
    public static final short ST_PLUS = 11;
    public static final short ST_STAR = 12;
    public static final short ST_ARROW = 13;
    public static final short ST_THICKARROW = 14;
    public static final short ST_HOMEPLATE = 15;
    public static final short ST_CUBE = 16;
    public static final short ST_BALLOON = 17;
    public static final short ST_SEAL = 18;
    public static final short ST_ARC = 19;
    public static final short ST_LINE = 20;
    public static final short ST_PLAQUE = 21;
    public static final short ST_CAN = 22;
    public static final short ST_DONUT = 23;
    public static final short ST_TEXTSIMPLE = 24;
    public static final short ST_TEXTOCTAGON = 25;
    public static final short ST_TEXTHEXAGON = 26;
    public static final short ST_TEXTCURVE = 27;
    public static final short ST_TEXTWAVE = 28;
    public static final short ST_TEXTRING = 29;
    public static final short ST_TEXTONCURVE = 30;
    public static final short ST_TEXTONRING = 31;
    public static final short ST_STRAIGHTCONNECTOR1 = 32;
    public static final short ST_BENTCONNECTOR2 = 33;
    public static final short ST_BENTCONNECTOR3 = 34;
    public static final short ST_BENTCONNECTOR4 = 35;
    public static final short ST_BENTCONNECTOR5 = 36;
    public static final short ST_CURVEDCONNECTOR2 = 37;
    public static final short ST_CURVEDCONNECTOR3 = 38;
    public static final short ST_CURVEDCONNECTOR4 = 39;
    public static final short ST_CURVEDCONNECTOR5 = 40;
    public static final short ST_CALLOUT1 = 41;
    public static final short ST_CALLOUT2 = 42;
    public static final short ST_CALLOUT3 = 43;
    public static final short ST_ACCENTCALLOUT1 = 44;
    public static final short ST_ACCENTCALLOUT2 = 45;
    public static final short ST_ACCENTCALLOUT3 = 46;
    public static final short ST_BORDERCALLOUT1 = 47;
    public static final short ST_BORDERCALLOUT2 = 48;
    public static final short ST_BORDERCALLOUT3 = 49;
    public static final short ST_ACCENTBORDERCALLOUT1 = 50;
    public static final short ST_ACCENTBORDERCALLOUT2 = 51;
    public static final short ST_ACCENTBORDERCALLOUT3 = 52;
    public static final short ST_RIBBON = 53;
    public static final short ST_RIBBON2 = 54;
    public static final short ST_CHEVRON = 55;
    public static final short ST_PENTAGON = 56;
    public static final short ST_NOSMOKING = 57;
    public static final short ST_SEAL8 = 58;
    public static final short ST_SEAL16 = 59;
    public static final short ST_SEAL32 = 60;
    public static final short ST_WEDGERECTCALLOUT = 61;
    public static final short ST_WEDGERRECTCALLOUT = 62;
    public static final short ST_WEDGEELLIPSECALLOUT = 63;
    public static final short ST_WAVE = 64;
    public static final short ST_FOLDEDCORNER = 65;
    public static final short ST_LEFTARROW = 66;
    public static final short ST_DOWNARROW = 67;
    public static final short ST_UPARROW = 68;
    public static final short ST_LEFTRIGHTARROW = 69;
    public static final short ST_UPDOWNARROW = 70;
    public static final short ST_IRREGULARSEAL1 = 71;
    public static final short ST_IRREGULARSEAL2 = 72;
    public static final short ST_LIGHTNINGBOLT = 73;
    public static final short ST_HEART = 74;
    public static final short ST_PICTUREFRAME = 75;
    public static final short ST_QUADARROW = 76;
    public static final short ST_LEFTARROWCALLOUT = 77;
    public static final short ST_RIGHTARROWCALLOUT = 78;
    public static final short ST_UPARROWCALLOUT = 79;
    public static final short ST_DOWNARROWCALLOUT = 80;
    public static final short ST_LEFTRIGHTARROWCALLOUT = 81;
    public static final short ST_UPDOWNARROWCALLOUT = 82;
    public static final short ST_QUADARROWCALLOUT = 83;
    public static final short ST_BEVEL = 84;
    public static final short ST_LEFTBRACKET = 85;
    public static final short ST_RIGHTBRACKET = 86;
    public static final short ST_LEFTBRACE = 87;
    public static final short ST_RIGHTBRACE = 88;
    public static final short ST_LEFTUPARROW = 89;
    public static final short ST_BENTUPARROW = 90;
    public static final short ST_BENTARROW = 91;
    public static final short ST_SEAL24 = 92;
    public static final short ST_STRIPEDRIGHTARROW = 93;
    public static final short ST_NOTCHEDRIGHTARROW = 94;
    public static final short ST_BLOCKARC = 95;
    public static final short ST_SMILEYFACE = 96;
    public static final short ST_VERTICALSCROLL = 97;
    public static final short ST_HORIZONTALSCROLL = 98;
    public static final short ST_CIRCULARARROW = 99;
    public static final short ST_NOTCHEDCIRCULARARROW = 100;
    public static final short ST_UTURNARROW = 101;
    public static final short ST_CURVEDRIGHTARROW = 102;
    public static final short ST_CURVEDLEFTARROW = 103;
    public static final short ST_CURVEDUPARROW = 104;
    public static final short ST_CURVEDDOWNARROW = 105;
    public static final short ST_CLOUDCALLOUT = 106;
    public static final short ST_ELLIPSERIBBON = 107;
    public static final short ST_ELLIPSERIBBON2 = 108;
    public static final short ST_FLOWCHARTPROCESS = 109;
    public static final short ST_FLOWCHARTDECISION = 110;
    public static final short ST_FLOWCHARTINPUTOUTPUT = 111;
    public static final short ST_FLOWCHARTPREDEFINEDPROCESS = 112;
    public static final short ST_FLOWCHARTINTERNALSTORAGE = 113;
    public static final short ST_FLOWCHARTDOCUMENT = 114;
    public static final short ST_FLOWCHARTMULTIDOCUMENT = 115;
    public static final short ST_FLOWCHARTTERMINATOR = 116;
    public static final short ST_FLOWCHARTPREPARATION = 117;
    public static final short ST_FLOWCHARTMANUALINPUT = 118;
    public static final short ST_FLOWCHARTMANUALOPERATION = 119;
    public static final short ST_FLOWCHARTCONNECTOR = 120;
    public static final short ST_FLOWCHARTPUNCHEDCARD = 121;
    public static final short ST_FLOWCHARTPUNCHEDTAPE = 122;
    public static final short ST_FLOWCHARTSUMMINGJUNCTION = 123;
    public static final short ST_FLOWCHARTOR = 124;
    public static final short ST_FLOWCHARTCOLLATE = 125;
    public static final short ST_FLOWCHARTSORT = 126;
    public static final short ST_FLOWCHARTEXTRACT = 127;
    public static final short ST_FLOWCHARTMERGE = 128;
    public static final short ST_FLOWCHARTOFFLINESTORAGE = 129;
    public static final short ST_FLOWCHARTONLINESTORAGE = 130;
    public static final short ST_FLOWCHARTMAGNETICTAPE = 131;
    public static final short ST_FLOWCHARTMAGNETICDISK = 132;
    public static final short ST_FLOWCHARTMAGNETICDRUM = 133;
    public static final short ST_FLOWCHARTDISPLAY = 134;
    public static final short ST_FLOWCHARTDELAY = 135;
    public static final short ST_TEXTPLAINTEXT = 136;
    public static final short ST_TEXTSTOP = 137;
    public static final short ST_TEXTTRIANGLE = 138;
    public static final short ST_TEXTTRIANGLEINVERTED = 139;
    public static final short ST_TEXTCHEVRON = 140;
    public static final short ST_TEXTCHEVRONINVERTED = 141;
    public static final short ST_TEXTRINGINSIDE = 142;
    public static final short ST_TEXTRINGOUTSIDE = 143;
    public static final short ST_TEXTARCHUPCURVE = 144;
    public static final short ST_TEXTARCHDOWNCURVE = 145;
    public static final short ST_TEXTCIRCLECURVE = 146;
    public static final short ST_TEXTBUTTONCURVE = 147;
    public static final short ST_TEXTARCHUPPOUR = 148;
    public static final short ST_TEXTARCHDOWNPOUR = 149;
    public static final short ST_TEXTCIRCLEPOUR = 150;
    public static final short ST_TEXTBUTTONPOUR = 151;
    public static final short ST_TEXTCURVEUP = 152;
    public static final short ST_TEXTCURVEDOWN = 153;
    public static final short ST_TEXTCASCADEUP = 154;
    public static final short ST_TEXTCASCADEDOWN = 155;
    public static final short ST_TEXTWAVE1 = 156;
    public static final short ST_TEXTWAVE2 = 157;
    public static final short ST_TEXTWAVE3 = 158;
    public static final short ST_TEXTWAVE4 = 159;
    public static final short ST_TEXTINFLATE = 160;
    public static final short ST_TEXTDEFLATE = 161;
    public static final short ST_TEXTINFLATEBOTTOM = 162;
    public static final short ST_TEXTDEFLATEBOTTOM = 163;
    public static final short ST_TEXTINFLATETOP = 164;
    public static final short ST_TEXTDEFLATETOP = 165;
    public static final short ST_TEXTDEFLATEINFLATE = 166;
    public static final short ST_TEXTDEFLATEINFLATEDEFLATE = 167;
    public static final short ST_TEXTFADERIGHT = 168;
    public static final short ST_TEXTFADELEFT = 169;
    public static final short ST_TEXTFADEUP = 170;
    public static final short ST_TEXTFADEDOWN = 171;
    public static final short ST_TEXTSLANTUP = 172;
    public static final short ST_TEXTSLANTDOWN = 173;
    public static final short ST_TEXTCANUP = 174;
    public static final short ST_TEXTCANDOWN = 175;
    public static final short ST_FLOWCHARTALTERNATEPROCESS = 176;
    public static final short ST_FLOWCHARTOFFPAGECONNECTOR = 177;
    public static final short ST_CALLOUT90 = 178;
    public static final short ST_ACCENTCALLOUT90 = 179;
    public static final short ST_BORDERCALLOUT90 = 180;
    public static final short ST_ACCENTBORDERCALLOUT90 = 181;
    public static final short ST_LEFTRIGHTUPARROW = 182;
    public static final short ST_SUN = 183;
    public static final short ST_MOON = 184;
    public static final short ST_BRACKETPAIR = 185;
    public static final short ST_BRACEPAIR = 186;
    public static final short ST_SEAL4 = 187;
    public static final short ST_DOUBLEWAVE = 188;
    public static final short ST_ACTIONBUTTONBLANK = 189;
    public static final short ST_ACTIONBUTTONHOME = 190;
    public static final short ST_ACTIONBUTTONHELP = 191;
    public static final short ST_ACTIONBUTTONINFORMATION = 192;
    public static final short ST_ACTIONBUTTONFORWARDNEXT = 193;
    public static final short ST_ACTIONBUTTONBACKPREVIOUS = 194;
    public static final short ST_ACTIONBUTTONEND = 195;
    public static final short ST_ACTIONBUTTONBEGINNING = 196;
    public static final short ST_ACTIONBUTTONRETURN = 197;
    public static final short ST_ACTIONBUTTONDOCUMENT = 198;
    public static final short ST_ACTIONBUTTONSOUND = 199;
    public static final short ST_ACTIONBUTTONMOVIE = 200;
    public static final short ST_HOSTCONTROL = 201;
    public static final short ST_TEXTBOX = 202;
    public static final short ST_NIL = 4095;
    private final Map<EscherRecord, Record> shapeToObj = new HashMap<EscherRecord, Record>();
    private Map<Integer, NoteRecord> tailRec = new LinkedHashMap<Integer, NoteRecord>();

    public EscherAggregate(boolean bl) {
        if (bl) {
            this.buildBaseTree();
        }
    }

    @Override
    public short getSid() {
        return 9876;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separtor");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getRecordName()).append(']').append(string);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            stringBuilder.append(escherRecord.toString());
        }
        stringBuilder.append("[/").append(this.getRecordName()).append(']').append(string);
        return stringBuilder.toString();
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("<").append(this.getRecordName()).append(">\n");
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            stringBuilder.append(escherRecord.toXml(string + "\t"));
        }
        stringBuilder.append(string).append("</").append(this.getRecordName()).append(">\n");
        return stringBuilder.toString();
    }

    private static boolean isDrawingLayerRecord(short s) {
        return s == 236 || s == 60 || s == 93 || s == 438;
    }

    public static EscherAggregate createAggregate(List<RecordBase> list, int n) {
        int n2;
        final ArrayList arrayList = new ArrayList();
        DefaultEscherRecordFactory defaultEscherRecordFactory = new DefaultEscherRecordFactory(){

            public EscherRecord createRecord(byte[] byArray, int n) {
                EscherRecord escherRecord = super.createRecord(byArray, n);
                if (escherRecord.getRecordId() == -4079 || escherRecord.getRecordId() == -4083) {
                    arrayList.add(escherRecord);
                }
                return escherRecord;
            }
        };
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EscherAggregate escherAggregate = new EscherAggregate(false);
        int n3 = n;
        while (n3 + 1 < list.size() && EscherAggregate.isDrawingLayerRecord(EscherAggregate.sid(list, n3))) {
            try {
                if (EscherAggregate.sid(list, n3) != 236 && EscherAggregate.sid(list, n3) != 60) {
                    ++n3;
                    continue;
                }
                if (EscherAggregate.sid(list, n3) == 236) {
                    byteArrayOutputStream.write(((DrawingRecord)list.get(n3)).getRecordData());
                } else {
                    byteArrayOutputStream.write(((ContinueRecord)list.get(n3)).getData());
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Couldn't get data from drawing/continue records", iOException);
            }
            ++n3;
        }
        for (int i = 0; i < byteArrayOutputStream.size(); i += n2) {
            EscherRecord escherRecord = defaultEscherRecordFactory.createRecord(byteArrayOutputStream.toByteArray(), i);
            n2 = escherRecord.fillFields(byteArrayOutputStream.toByteArray(), i, defaultEscherRecordFactory);
            escherAggregate.addEscherRecord(escherRecord);
        }
        n3 = n + 1;
        int n4 = 0;
        while (n3 < list.size() && EscherAggregate.isDrawingLayerRecord(EscherAggregate.sid(list, n3))) {
            if (!EscherAggregate.isObjectRecord(list, n3)) {
                ++n3;
                continue;
            }
            Record record = (Record)list.get(n3);
            escherAggregate.shapeToObj.put((EscherRecord)arrayList.get(n4++), record);
            ++n3;
        }
        while (n3 < list.size() && EscherAggregate.sid(list, n3) == 28) {
            NoteRecord noteRecord = (NoteRecord)list.get(n3);
            escherAggregate.tailRec.put(noteRecord.getShapeId(), noteRecord);
            ++n3;
        }
        int n5 = n3;
        list.subList(n, n5).clear();
        list.add(n, escherAggregate);
        return escherAggregate;
    }

    @Override
    public int serialize(int n, byte[] byArray) {
        int n2;
        List<EscherRecord> list = this.getEscherRecords();
        int n3 = this.getEscherRecordSize(list);
        byte[] byArray2 = new byte[n3];
        final ArrayList<Integer> arrayList = new ArrayList<Integer>();
        final ArrayList arrayList2 = new ArrayList();
        int n4 = 0;
        Iterator<EscherRecord> iterator = list.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord;
            EscherRecord escherRecord2 = escherRecord = iterator.next();
            n4 += escherRecord2.serialize(n4, byArray2, new EscherSerializationListener(){

                public void beforeRecordSerialize(int n, short s, EscherRecord escherRecord) {
                }

                public void afterRecordSerialize(int n, short s, int n2, EscherRecord escherRecord) {
                    if (s == -4079 || s == -4083) {
                        arrayList.add(n);
                        arrayList2.add(escherRecord);
                    }
                }
            });
        }
        arrayList2.add(0, null);
        arrayList.add(0, 0);
        n4 = n;
        int n5 = 0;
        for (n2 = 1; n2 < arrayList2.size(); ++n2) {
            int n6 = (Integer)arrayList.get(n2) - 1;
            int n7 = n2 == 1 ? 0 : (Integer)arrayList.get(n2 - 1);
            byte[] byArray3 = new byte[n6 - n7 + 1];
            System.arraycopy(byArray2, n7, byArray3, 0, byArray3.length);
            n4 += this.writeDataIntoDrawingRecord(byArray3, n5, n4, byArray, n2);
            n5 += byArray3.length;
            Record record = this.shapeToObj.get(arrayList2.get(n2));
            n4 += record.serialize(n4, byArray);
            if (n2 != arrayList2.size() - 1 || n6 >= byArray2.length - 1) continue;
            byArray3 = new byte[byArray2.length - n6 - 1];
            System.arraycopy(byArray2, n6 + 1, byArray3, 0, byArray3.length);
            n4 += this.writeDataIntoDrawingRecord(byArray3, n5, n4, byArray, n2);
        }
        if (n4 - n < byArray2.length - 1) {
            byte[] byArray4 = new byte[byArray2.length - (n4 - n)];
            System.arraycopy(byArray2, n4 - n, byArray4, 0, byArray4.length);
            n4 += this.writeDataIntoDrawingRecord(byArray4, n5, n4, byArray, n2);
        }
        for (n2 = 0; n2 < this.tailRec.size(); ++n2) {
            Record record = (Record)this.tailRec.values().toArray()[n2];
            n4 += record.serialize(n4, byArray);
        }
        int n8 = n4 - n;
        if (n8 != this.getRecordSize()) {
            throw new RecordFormatException(n8 + " bytes written but getRecordSize() reports " + this.getRecordSize());
        }
        return n8;
    }

    private int writeDataIntoDrawingRecord(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        if (n + byArray.length > 8224 && n3 != 1) {
            for (int i = 0; i < byArray.length; i += 8224) {
                byte[] byArray3 = new byte[Math.min(8224, byArray.length - i)];
                System.arraycopy(byArray, i, byArray3, 0, Math.min(8224, byArray.length - i));
                ContinueRecord continueRecord = new ContinueRecord(byArray3);
                n4 += continueRecord.serialize(n2 + n4, byArray2);
            }
        } else {
            for (int i = 0; i < byArray.length; i += 8224) {
                Object object;
                Object object2;
                if (i == 0) {
                    object2 = new DrawingRecord();
                    object = new byte[Math.min(8224, byArray.length - i)];
                    System.arraycopy(byArray, i, object, 0, Math.min(8224, byArray.length - i));
                    ((DrawingRecord)object2).setData((byte[])object);
                    n4 += ((StandardRecord)object2).serialize(n2 + n4, byArray2);
                    continue;
                }
                object2 = new byte[Math.min(8224, byArray.length - i)];
                System.arraycopy(byArray, i, object2, 0, Math.min(8224, byArray.length - i));
                object = new ContinueRecord((byte[])object2);
                n4 += ((StandardRecord)object).serialize(n2 + n4, byArray2);
            }
        }
        return n4;
    }

    private int getEscherRecordSize(List<EscherRecord> list) {
        int n = 0;
        for (EscherRecord escherRecord : list) {
            n += escherRecord.getRecordSize();
        }
        return n;
    }

    @Override
    public int getRecordSize() {
        int n;
        int n2 = 0;
        List<EscherRecord> list = this.getEscherRecords();
        int n3 = this.getEscherRecordSize(list);
        byte[] byArray = new byte[n3];
        final ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = 0;
        for (EscherRecord escherRecord : list) {
            n4 += escherRecord.serialize(n4, byArray, new EscherSerializationListener(){

                public void beforeRecordSerialize(int n, short s, EscherRecord escherRecord) {
                }

                public void afterRecordSerialize(int n, short s, int n2, EscherRecord escherRecord) {
                    if (s == -4079 || s == -4083) {
                        arrayList.add(n);
                    }
                }
            });
        }
        arrayList.add(0, 0);
        for (n = 1; n < arrayList.size(); ++n) {
            if (n == arrayList.size() - 1 && (Integer)arrayList.get(n) < n4) {
                n2 += 4;
            }
            if ((Integer)arrayList.get(n) - (Integer)arrayList.get(n - 1) <= 8224) continue;
            n2 += ((Integer)arrayList.get(n) - (Integer)arrayList.get(n - 1)) / 8224 * 4;
        }
        n = n3 + this.shapeToObj.size() * 4;
        if (n3 != 0 && arrayList.size() == 1) {
            n2 += 4;
        }
        int n5 = 0;
        for (Record object : this.shapeToObj.values()) {
            n5 += object.getRecordSize();
        }
        int n6 = 0;
        for (NoteRecord noteRecord : this.tailRec.values()) {
            n6 += noteRecord.getRecordSize();
        }
        return n + n5 + n6 + n2;
    }

    public void associateShapeToObjRecord(EscherRecord escherRecord, Record record) {
        this.shapeToObj.put(escherRecord, record);
    }

    public void removeShapeToObjRecord(EscherRecord escherRecord) {
        this.shapeToObj.remove(escherRecord);
    }

    @Override
    protected String getRecordName() {
        return "ESCHERAGGREGATE";
    }

    private static boolean isObjectRecord(List<RecordBase> list, int n) {
        return EscherAggregate.sid(list, n) == 93 || EscherAggregate.sid(list, n) == 438;
    }

    private void buildBaseTree() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        EscherContainerRecord escherContainerRecord2 = new EscherContainerRecord();
        EscherContainerRecord escherContainerRecord3 = new EscherContainerRecord();
        EscherSpgrRecord escherSpgrRecord = new EscherSpgrRecord();
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        escherContainerRecord.setRecordId((short)-4094);
        escherContainerRecord.setOptions((short)15);
        EscherDgRecord escherDgRecord = new EscherDgRecord();
        escherDgRecord.setRecordId((short)-4088);
        int n = 1;
        escherDgRecord.setOptions((short)(n << 4));
        escherDgRecord.setNumShapes(0);
        escherDgRecord.setLastMSOSPID(1024);
        escherContainerRecord2.setRecordId((short)-4093);
        escherContainerRecord2.setOptions((short)15);
        escherContainerRecord3.setRecordId((short)-4092);
        escherContainerRecord3.setOptions((short)15);
        escherSpgrRecord.setRecordId((short)-4087);
        escherSpgrRecord.setOptions((short)1);
        escherSpgrRecord.setRectX1(0);
        escherSpgrRecord.setRectY1(0);
        escherSpgrRecord.setRectX2(1023);
        escherSpgrRecord.setRectY2(255);
        escherSpRecord.setRecordId((short)-4086);
        escherSpRecord.setOptions((short)2);
        escherSpRecord.setVersion((short)2);
        escherSpRecord.setShapeId(-1);
        escherSpRecord.setFlags(5);
        escherContainerRecord.addChildRecord(escherDgRecord);
        escherContainerRecord.addChildRecord(escherContainerRecord2);
        escherContainerRecord2.addChildRecord(escherContainerRecord3);
        escherContainerRecord3.addChildRecord(escherSpgrRecord);
        escherContainerRecord3.addChildRecord(escherSpRecord);
        this.addEscherRecord(escherContainerRecord);
    }

    public void setDgId(short s) {
        EscherContainerRecord escherContainerRecord = this.getEscherContainer();
        EscherDgRecord escherDgRecord = (EscherDgRecord)escherContainerRecord.getChildById((short)-4088);
        escherDgRecord.setOptions((short)(s << 4));
    }

    public void setMainSpRecordId(int n) {
        EscherContainerRecord escherContainerRecord = this.getEscherContainer();
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)escherContainerRecord.getChildById((short)-4093);
        EscherContainerRecord escherContainerRecord3 = (EscherContainerRecord)escherContainerRecord2.getChild(0);
        EscherSpRecord escherSpRecord = (EscherSpRecord)escherContainerRecord3.getChildById((short)-4086);
        escherSpRecord.setShapeId(n);
    }

    private static short sid(List<RecordBase> list, int n) {
        RecordBase recordBase = list.get(n);
        if (recordBase instanceof Record) {
            return ((Record)recordBase).getSid();
        }
        return -1;
    }

    public Map<EscherRecord, Record> getShapeToObjMapping() {
        return Collections.unmodifiableMap(this.shapeToObj);
    }

    public Map<Integer, NoteRecord> getTailRecords() {
        return Collections.unmodifiableMap(this.tailRec);
    }

    public NoteRecord getNoteRecordByObj(ObjRecord objRecord) {
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)objRecord.getSubRecords().get(0);
        return this.tailRec.get(commonObjectDataSubRecord.getObjectId());
    }

    public void addTailRecord(NoteRecord noteRecord) {
        this.tailRec.put(noteRecord.getShapeId(), noteRecord);
    }

    public void removeTailRecord(NoteRecord noteRecord) {
        this.tailRec.remove(noteRecord.getShapeId());
    }
}

