/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.SubRecord;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai2.org.apache.poi.ss.formula.ptg.RefPtg;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianInputStream;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;

public final class EmbeddedObjectRefSubRecord
extends SubRecord {
    private static POILogger logger = POILogFactory.getLogger(EmbeddedObjectRefSubRecord.class);
    public static final short sid = 9;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int field_1_unknown_int;
    private Ptg field_2_refPtg;
    private byte[] field_2_unknownFormulaData;
    private boolean field_3_unicode_flag;
    private String field_4_ole_classname;
    private Byte field_4_unknownByte;
    private Integer field_5_stream_id;
    private byte[] field_6_unknown;

    public EmbeddedObjectRefSubRecord() {
        this.field_2_unknownFormulaData = new byte[]{2, 108, 106, 22, 1};
        this.field_6_unknown = EMPTY_BYTE_ARRAY;
        this.field_4_ole_classname = null;
    }

    public short getSid() {
        return 9;
    }

    public EmbeddedObjectRefSubRecord(LittleEndianInput littleEndianInput, int n) {
        int n2;
        int n3;
        short s = littleEndianInput.readShort();
        int n4 = n - 2;
        int n5 = n4 - s;
        int n6 = littleEndianInput.readUShort();
        n4 -= 2;
        this.field_1_unknown_int = littleEndianInput.readInt();
        n4 -= 4;
        byte[] byArray = EmbeddedObjectRefSubRecord.readRawData(littleEndianInput, n6);
        this.field_2_refPtg = EmbeddedObjectRefSubRecord.readRefPtg(byArray);
        this.field_2_unknownFormulaData = (byte[])(this.field_2_refPtg == null ? byArray : null);
        if ((n4 -= n6) >= n5 + 3) {
            n3 = littleEndianInput.readByte();
            n2 = 1;
            if (n3 != 3) {
                throw new RecordFormatException("Expected byte 0x03 here");
            }
            int n7 = littleEndianInput.readUShort();
            n2 += 2;
            if (n7 > 0) {
                this.field_3_unicode_flag = (littleEndianInput.readByte() & 1) != 0;
                ++n2;
                if (this.field_3_unicode_flag) {
                    this.field_4_ole_classname = StringUtil.readUnicodeLE(littleEndianInput, n7);
                    n2 += n7 * 2;
                } else {
                    this.field_4_ole_classname = StringUtil.readCompressedUnicode(littleEndianInput, n7);
                    n2 += n7;
                }
            } else {
                this.field_4_ole_classname = "";
            }
        } else {
            this.field_4_ole_classname = null;
            n2 = 0;
        }
        n4 -= n2;
        if ((n2 + n6) % 2 != 0) {
            n3 = littleEndianInput.readByte();
            --n4;
            if (this.field_2_refPtg != null && this.field_4_ole_classname == null) {
                this.field_4_unknownByte = (byte)n3;
            }
        }
        if ((n3 = n4 - n5) > 0) {
            logger.log(7, new Object[]{"Discarding " + n3 + " unexpected padding bytes "});
            EmbeddedObjectRefSubRecord.readRawData(littleEndianInput, n3);
            n4 -= n3;
        }
        if (n5 >= 4) {
            this.field_5_stream_id = littleEndianInput.readInt();
            n4 -= 4;
        } else {
            this.field_5_stream_id = null;
        }
        this.field_6_unknown = EmbeddedObjectRefSubRecord.readRawData(littleEndianInput, n4);
    }

    private static Ptg readRefPtg(byte[] byArray) {
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
        byte by = littleEndianInputStream.readByte();
        switch (by) {
            case 37: {
                return new AreaPtg(littleEndianInputStream);
            }
            case 59: {
                return new Area3DPtg(littleEndianInputStream);
            }
            case 36: {
                return new RefPtg(littleEndianInputStream);
            }
            case 58: {
                return new Ref3DPtg(littleEndianInputStream);
            }
        }
        return null;
    }

    private static byte[] readRawData(LittleEndianInput littleEndianInput, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative size (" + n + ")");
        }
        if (n == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        littleEndianInput.readFully(byArray);
        return byArray;
    }

    private int getStreamIDOffset(int n) {
        int n2 = 6;
        n2 += n;
        if (this.field_4_ole_classname == null) {
            boolean bl = false;
        } else {
            n2 += 3;
            int n3 = this.field_4_ole_classname.length();
            if (n3 > 0) {
                ++n2;
                n2 = this.field_3_unicode_flag ? (n2 += n3 * 2) : (n2 += n3);
            }
        }
        if (n2 % 2 != 0) {
            ++n2;
        }
        return n2;
    }

    private int getDataSize(int n) {
        int n2 = 2 + n;
        if (this.field_5_stream_id != null) {
            n2 += 4;
        }
        return n2 + this.field_6_unknown.length;
    }

    protected int getDataSize() {
        int n = this.field_2_refPtg == null ? this.field_2_unknownFormulaData.length : this.field_2_refPtg.getSize();
        int n2 = this.getStreamIDOffset(n);
        return this.getDataSize(n2);
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this.field_2_refPtg == null ? this.field_2_unknownFormulaData.length : this.field_2_refPtg.getSize();
        int n2 = this.getStreamIDOffset(n);
        int n3 = this.getDataSize(n2);
        littleEndianOutput.writeShort(9);
        littleEndianOutput.writeShort(n3);
        littleEndianOutput.writeShort(n2);
        littleEndianOutput.writeShort(n);
        littleEndianOutput.writeInt(this.field_1_unknown_int);
        int n4 = 12;
        if (this.field_2_refPtg == null) {
            littleEndianOutput.write(this.field_2_unknownFormulaData);
        } else {
            this.field_2_refPtg.write(littleEndianOutput);
        }
        n4 += n;
        if (this.field_4_ole_classname == null) {
            boolean bl = false;
        } else {
            littleEndianOutput.writeByte(3);
            ++n4;
            int n5 = this.field_4_ole_classname.length();
            littleEndianOutput.writeShort(n5);
            n4 += 2;
            if (n5 > 0) {
                littleEndianOutput.writeByte(this.field_3_unicode_flag ? 1 : 0);
                ++n4;
                if (this.field_3_unicode_flag) {
                    StringUtil.putUnicodeLE(this.field_4_ole_classname, littleEndianOutput);
                    n4 += n5 * 2;
                } else {
                    StringUtil.putCompressedUnicode(this.field_4_ole_classname, littleEndianOutput);
                    n4 += n5;
                }
            }
        }
        switch (n2 - (n4 - 6)) {
            case 1: {
                littleEndianOutput.writeByte(this.field_4_unknownByte == null ? 0 : this.field_4_unknownByte.intValue());
                ++n4;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Bad padding calculation (" + n2 + ", " + n4 + ")");
            }
        }
        if (this.field_5_stream_id != null) {
            littleEndianOutput.writeInt(this.field_5_stream_id);
            n4 += 4;
        }
        littleEndianOutput.write(this.field_6_unknown);
    }

    public Integer getStreamId() {
        return this.field_5_stream_id;
    }

    public String getOLEClassName() {
        return this.field_4_ole_classname;
    }

    public byte[] getObjectData() {
        return this.field_6_unknown;
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ftPictFmla]\n");
        stringBuffer.append("    .f2unknown     = ").append(HexDump.intToHex(this.field_1_unknown_int)).append("\n");
        if (this.field_2_refPtg == null) {
            stringBuffer.append("    .f3unknown     = ").append(HexDump.toHex(this.field_2_unknownFormulaData)).append("\n");
        } else {
            stringBuffer.append("    .formula       = ").append(this.field_2_refPtg.toString()).append("\n");
        }
        if (this.field_4_ole_classname != null) {
            stringBuffer.append("    .unicodeFlag   = ").append(this.field_3_unicode_flag).append("\n");
            stringBuffer.append("    .oleClassname  = ").append(this.field_4_ole_classname).append("\n");
        }
        if (this.field_4_unknownByte != null) {
            stringBuffer.append("    .f4unknown   = ").append(HexDump.byteToHex(this.field_4_unknownByte.intValue())).append("\n");
        }
        if (this.field_5_stream_id != null) {
            stringBuffer.append("    .streamId      = ").append(HexDump.intToHex(this.field_5_stream_id)).append("\n");
        }
        if (this.field_6_unknown.length > 0) {
            stringBuffer.append("    .f7unknown     = ").append(HexDump.toHex(this.field_6_unknown)).append("\n");
        }
        stringBuffer.append("[/ftPictFmla]");
        return stringBuffer.toString();
    }

    public void setUnknownFormulaData(byte[] byArray) {
        this.field_2_unknownFormulaData = byArray;
    }

    public void setOleClassname(String string) {
        this.field_4_ole_classname = string;
    }

    public void setStorageId(int n) {
        this.field_5_stream_id = n;
    }
}

