/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class DefaultRowHeightRecord
extends StandardRecord {
    public static final short sid = 549;
    private short field_1_option_flags;
    private short field_2_row_height;
    public static final short DEFAULT_ROW_HEIGHT = 255;

    public DefaultRowHeightRecord() {
        this.field_1_option_flags = 0;
        this.field_2_row_height = (short)255;
    }

    public DefaultRowHeightRecord(RecordInputStream recordInputStream) {
        this.field_1_option_flags = recordInputStream.readShort();
        this.field_2_row_height = recordInputStream.readShort();
    }

    public void setOptionFlags(short s) {
        this.field_1_option_flags = s;
    }

    public void setRowHeight(short s) {
        this.field_2_row_height = s;
    }

    public short getOptionFlags() {
        return this.field_1_option_flags;
    }

    public short getRowHeight() {
        return this.field_2_row_height;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DEFAULTROWHEIGHT]\n");
        stringBuffer.append("    .optionflags    = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        stringBuffer.append("    .rowheight      = ").append(Integer.toHexString(this.getRowHeight())).append("\n");
        stringBuffer.append("[/DEFAULTROWHEIGHT]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getOptionFlags());
        littleEndianOutput.writeShort(this.getRowHeight());
    }

    protected int getDataSize() {
        return 4;
    }

    public short getSid() {
        return 549;
    }

    public Object clone() {
        DefaultRowHeightRecord defaultRowHeightRecord = new DefaultRowHeightRecord();
        defaultRowHeightRecord.field_1_option_flags = this.field_1_option_flags;
        defaultRowHeightRecord.field_2_row_height = this.field_2_row_height;
        return defaultRowHeightRecord;
    }
}

