/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai2.org.apache.poi.hssf.record.CFRuleRecord;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.hssf.record.cf.BorderFormatting;
import ai2.org.apache.poi.hssf.record.cf.FontFormatting;
import ai2.org.apache.poi.hssf.record.cf.PatternFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public abstract class CFRuleBase
extends StandardRecord {
    protected static final POILogger logger = POILogFactory.getLogger(CFRuleBase.class);
    private byte condition_type;
    public static final byte CONDITION_TYPE_CELL_VALUE_IS = 1;
    public static final byte CONDITION_TYPE_FORMULA = 2;
    public static final byte CONDITION_TYPE_COLOR_SCALE = 3;
    public static final byte CONDITION_TYPE_DATA_BAR = 4;
    public static final byte CONDITION_TYPE_FILTER = 5;
    public static final byte CONDITION_TYPE_ICON_SET = 6;
    private byte comparison_operator;
    public static final int TEMPLATE_CELL_VALUE = 0;
    public static final int TEMPLATE_FORMULA = 1;
    public static final int TEMPLATE_COLOR_SCALE_FORMATTING = 2;
    public static final int TEMPLATE_DATA_BAR_FORMATTING = 3;
    public static final int TEMPLATE_ICON_SET_FORMATTING = 4;
    public static final int TEMPLATE_FILTER = 5;
    public static final int TEMPLATE_UNIQUE_VALUES = 7;
    public static final int TEMPLATE_CONTAINS_TEXT = 8;
    public static final int TEMPLATE_CONTAINS_BLANKS = 9;
    public static final int TEMPLATE_CONTAINS_NO_BLANKS = 10;
    public static final int TEMPLATE_CONTAINS_ERRORS = 11;
    public static final int TEMPLATE_CONTAINS_NO_ERRORS = 12;
    public static final int TEMPLATE_TODAY = 15;
    public static final int TEMPLATE_TOMORROW = 16;
    public static final int TEMPLATE_YESTERDAY = 17;
    public static final int TEMPLATE_LAST_7_DAYS = 18;
    public static final int TEMPLATE_LAST_MONTH = 19;
    public static final int TEMPLATE_NEXT_MONTH = 20;
    public static final int TEMPLATE_THIS_WEEK = 21;
    public static final int TEMPLATE_NEXT_WEEK = 22;
    public static final int TEMPLATE_LAST_WEEK = 23;
    public static final int TEMPLATE_THIS_MONTH = 24;
    public static final int TEMPLATE_ABOVE_AVERAGE = 25;
    public static final int TEMPLATE_BELOW_AVERAGE = 26;
    public static final int TEMPLATE_DUPLICATE_VALUES = 27;
    public static final int TEMPLATE_ABOVE_OR_EQUAL_TO_AVERAGE = 29;
    public static final int TEMPLATE_BELOW_OR_EQUAL_TO_AVERAGE = 30;
    static final BitField modificationBits = CFRuleBase.bf(0x3FFFFF);
    static final BitField alignHor = CFRuleBase.bf(1);
    static final BitField alignVer = CFRuleBase.bf(2);
    static final BitField alignWrap = CFRuleBase.bf(4);
    static final BitField alignRot = CFRuleBase.bf(8);
    static final BitField alignJustLast = CFRuleBase.bf(16);
    static final BitField alignIndent = CFRuleBase.bf(32);
    static final BitField alignShrin = CFRuleBase.bf(64);
    static final BitField mergeCell = CFRuleBase.bf(128);
    static final BitField protLocked = CFRuleBase.bf(256);
    static final BitField protHidden = CFRuleBase.bf(512);
    static final BitField bordLeft = CFRuleBase.bf(1024);
    static final BitField bordRight = CFRuleBase.bf(2048);
    static final BitField bordTop = CFRuleBase.bf(4096);
    static final BitField bordBot = CFRuleBase.bf(8192);
    static final BitField bordTlBr = CFRuleBase.bf(16384);
    static final BitField bordBlTr = CFRuleBase.bf(32768);
    static final BitField pattStyle = CFRuleBase.bf(65536);
    static final BitField pattCol = CFRuleBase.bf(131072);
    static final BitField pattBgCol = CFRuleBase.bf(262144);
    static final BitField notUsed2 = CFRuleBase.bf(0x380000);
    static final BitField undocumented = CFRuleBase.bf(0x3C00000);
    static final BitField fmtBlockBits = CFRuleBase.bf(0x7C000000);
    static final BitField font = CFRuleBase.bf(0x4000000);
    static final BitField align = CFRuleBase.bf(0x8000000);
    static final BitField bord = CFRuleBase.bf(0x10000000);
    static final BitField patt = CFRuleBase.bf(0x20000000);
    static final BitField prot = CFRuleBase.bf(0x40000000);
    static final BitField alignTextDir = CFRuleBase.bf(Integer.MIN_VALUE);
    protected int formatting_options;
    protected short formatting_not_used;
    protected FontFormatting _fontFormatting;
    protected BorderFormatting _borderFormatting;
    protected PatternFormatting _patternFormatting;
    private Formula formula1;
    private Formula formula2;

    private static BitField bf(int n) {
        return BitFieldFactory.getInstance(n);
    }

    protected CFRuleBase(byte by, byte by2) {
        this.setConditionType(by);
        this.setComparisonOperation(by2);
        this.formula1 = Formula.create(Ptg.EMPTY_PTG_ARRAY);
        this.formula2 = Formula.create(Ptg.EMPTY_PTG_ARRAY);
    }

    protected CFRuleBase(byte by, byte by2, Ptg[] ptgArray, Ptg[] ptgArray2) {
        this(by, by2);
        this.formula1 = Formula.create(ptgArray);
        this.formula2 = Formula.create(ptgArray2);
    }

    protected CFRuleBase() {
    }

    protected int readFormatOptions(RecordInputStream recordInputStream) {
        this.formatting_options = recordInputStream.readInt();
        this.formatting_not_used = recordInputStream.readShort();
        int n = 6;
        if (this.containsFontFormattingBlock()) {
            this._fontFormatting = new FontFormatting(recordInputStream);
            n += this._fontFormatting.getDataLength();
        }
        if (this.containsBorderFormattingBlock()) {
            this._borderFormatting = new BorderFormatting(recordInputStream);
            n += this._borderFormatting.getDataLength();
        }
        if (this.containsPatternFormattingBlock()) {
            this._patternFormatting = new PatternFormatting(recordInputStream);
            n += this._patternFormatting.getDataLength();
        }
        return n;
    }

    public byte getConditionType() {
        return this.condition_type;
    }

    protected void setConditionType(byte by) {
        if (this instanceof CFRuleRecord && by != 1 && by != 2) {
            throw new IllegalArgumentException("CFRuleRecord only accepts Value-Is and Formula types");
        }
        this.condition_type = by;
    }

    public void setComparisonOperation(byte by) {
        if (by < 0 || by > 8) {
            throw new IllegalArgumentException("Valid operators are only in the range 0 to 8");
        }
        this.comparison_operator = by;
    }

    public byte getComparisonOperation() {
        return this.comparison_operator;
    }

    public boolean containsFontFormattingBlock() {
        return this.getOptionFlag(font);
    }

    public void setFontFormatting(FontFormatting fontFormatting) {
        this._fontFormatting = fontFormatting;
        this.setOptionFlag(fontFormatting != null, font);
    }

    public FontFormatting getFontFormatting() {
        if (this.containsFontFormattingBlock()) {
            return this._fontFormatting;
        }
        return null;
    }

    public boolean containsAlignFormattingBlock() {
        return this.getOptionFlag(align);
    }

    public void setAlignFormattingUnchanged() {
        this.setOptionFlag(false, align);
    }

    public boolean containsBorderFormattingBlock() {
        return this.getOptionFlag(bord);
    }

    public void setBorderFormatting(BorderFormatting borderFormatting) {
        this._borderFormatting = borderFormatting;
        this.setOptionFlag(borderFormatting != null, bord);
    }

    public BorderFormatting getBorderFormatting() {
        if (this.containsBorderFormattingBlock()) {
            return this._borderFormatting;
        }
        return null;
    }

    public boolean containsPatternFormattingBlock() {
        return this.getOptionFlag(patt);
    }

    public void setPatternFormatting(PatternFormatting patternFormatting) {
        this._patternFormatting = patternFormatting;
        this.setOptionFlag(patternFormatting != null, patt);
    }

    public PatternFormatting getPatternFormatting() {
        if (this.containsPatternFormattingBlock()) {
            return this._patternFormatting;
        }
        return null;
    }

    public boolean containsProtectionFormattingBlock() {
        return this.getOptionFlag(prot);
    }

    public void setProtectionFormattingUnchanged() {
        this.setOptionFlag(false, prot);
    }

    public int getOptions() {
        return this.formatting_options;
    }

    private boolean isModified(BitField bitField) {
        return !bitField.isSet(this.formatting_options);
    }

    private void setModified(boolean bl, BitField bitField) {
        this.formatting_options = bitField.setBoolean(this.formatting_options, !bl);
    }

    public boolean isLeftBorderModified() {
        return this.isModified(bordLeft);
    }

    public void setLeftBorderModified(boolean bl) {
        this.setModified(bl, bordLeft);
    }

    public boolean isRightBorderModified() {
        return this.isModified(bordRight);
    }

    public void setRightBorderModified(boolean bl) {
        this.setModified(bl, bordRight);
    }

    public boolean isTopBorderModified() {
        return this.isModified(bordTop);
    }

    public void setTopBorderModified(boolean bl) {
        this.setModified(bl, bordTop);
    }

    public boolean isBottomBorderModified() {
        return this.isModified(bordBot);
    }

    public void setBottomBorderModified(boolean bl) {
        this.setModified(bl, bordBot);
    }

    public boolean isTopLeftBottomRightBorderModified() {
        return this.isModified(bordTlBr);
    }

    public void setTopLeftBottomRightBorderModified(boolean bl) {
        this.setModified(bl, bordTlBr);
    }

    public boolean isBottomLeftTopRightBorderModified() {
        return this.isModified(bordBlTr);
    }

    public void setBottomLeftTopRightBorderModified(boolean bl) {
        this.setModified(bl, bordBlTr);
    }

    public boolean isPatternStyleModified() {
        return this.isModified(pattStyle);
    }

    public void setPatternStyleModified(boolean bl) {
        this.setModified(bl, pattStyle);
    }

    public boolean isPatternColorModified() {
        return this.isModified(pattCol);
    }

    public void setPatternColorModified(boolean bl) {
        this.setModified(bl, pattCol);
    }

    public boolean isPatternBackgroundColorModified() {
        return this.isModified(pattBgCol);
    }

    public void setPatternBackgroundColorModified(boolean bl) {
        this.setModified(bl, pattBgCol);
    }

    private boolean getOptionFlag(BitField bitField) {
        return bitField.isSet(this.formatting_options);
    }

    private void setOptionFlag(boolean bl, BitField bitField) {
        this.formatting_options = bitField.setBoolean(this.formatting_options, bl);
    }

    protected int getFormattingBlockSize() {
        return 6 + (this.containsFontFormattingBlock() ? this._fontFormatting.getRawRecord().length : 0) + (this.containsBorderFormattingBlock() ? 8 : 0) + (this.containsPatternFormattingBlock() ? 4 : 0);
    }

    protected void serializeFormattingBlock(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.formatting_options);
        littleEndianOutput.writeShort(this.formatting_not_used);
        if (this.containsFontFormattingBlock()) {
            byte[] byArray = this._fontFormatting.getRawRecord();
            littleEndianOutput.write(byArray);
        }
        if (this.containsBorderFormattingBlock()) {
            this._borderFormatting.serialize(littleEndianOutput);
        }
        if (this.containsPatternFormattingBlock()) {
            this._patternFormatting.serialize(littleEndianOutput);
        }
    }

    public Ptg[] getParsedExpression1() {
        return this.formula1.getTokens();
    }

    public void setParsedExpression1(Ptg[] ptgArray) {
        this.formula1 = Formula.create(ptgArray);
    }

    protected Formula getFormula1() {
        return this.formula1;
    }

    protected void setFormula1(Formula formula) {
        this.formula1 = formula;
    }

    public Ptg[] getParsedExpression2() {
        return Formula.getTokens(this.formula2);
    }

    public void setParsedExpression2(Ptg[] ptgArray) {
        this.formula2 = Formula.create(ptgArray);
    }

    protected Formula getFormula2() {
        return this.formula2;
    }

    protected void setFormula2(Formula formula) {
        this.formula2 = formula;
    }

    protected static int getFormulaSize(Formula formula) {
        return formula.getEncodedTokenSize();
    }

    public static Ptg[] parseFormula(String string, HSSFSheet hSSFSheet) {
        if (string == null) {
            return null;
        }
        int n = hSSFSheet.getWorkbook().getSheetIndex(hSSFSheet);
        return HSSFFormulaParser.parse(string, hSSFSheet.getWorkbook(), 0, n);
    }

    protected void copyTo(CFRuleBase cFRuleBase) {
        cFRuleBase.condition_type = this.condition_type;
        cFRuleBase.comparison_operator = this.comparison_operator;
        cFRuleBase.formatting_options = this.formatting_options;
        cFRuleBase.formatting_not_used = this.formatting_not_used;
        if (this.containsFontFormattingBlock()) {
            cFRuleBase._fontFormatting = (FontFormatting)this._fontFormatting.clone();
        }
        if (this.containsBorderFormattingBlock()) {
            cFRuleBase._borderFormatting = (BorderFormatting)this._borderFormatting.clone();
        }
        if (this.containsPatternFormattingBlock()) {
            cFRuleBase._patternFormatting = (PatternFormatting)this._patternFormatting.clone();
        }
        cFRuleBase.setFormula1(this.getFormula1().copy());
        cFRuleBase.setFormula2(this.getFormula2().copy());
    }

    public static final class ComparisonOperator {
        public static final byte NO_COMPARISON = 0;
        public static final byte BETWEEN = 1;
        public static final byte NOT_BETWEEN = 2;
        public static final byte EQUAL = 3;
        public static final byte NOT_EQUAL = 4;
        public static final byte GT = 5;
        public static final byte LT = 6;
        public static final byte GE = 7;
        public static final byte LE = 8;
        private static final byte max_operator = 8;
    }
}

