/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.cf.ColorGradientFormatting;
import ai2.org.apache.poi.hssf.record.cf.ColorGradientThreshold;
import ai2.org.apache.poi.hssf.record.cf.DataBarFormatting;
import ai2.org.apache.poi.hssf.record.cf.DataBarThreshold;
import ai2.org.apache.poi.hssf.record.cf.IconMultiStateFormatting;
import ai2.org.apache.poi.hssf.record.cf.IconMultiStateThreshold;
import ai2.org.apache.poi.hssf.record.cf.Threshold;
import ai2.org.apache.poi.hssf.record.common.ExtendedColor;
import ai2.org.apache.poi.hssf.record.common.FtrHeader;
import ai2.org.apache.poi.hssf.record.common.FutureRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.formula.Formula;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import ai2.org.apache.poi.ss.usermodel.IconMultiStateFormatting;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.Arrays;

public final class CFRule12Record
extends CFRuleBase
implements FutureRecord {
    public static final short sid = 2170;
    private FtrHeader futureHeader;
    private int ext_formatting_length;
    private byte[] ext_formatting_data;
    private Formula formula_scale;
    private byte ext_opts;
    private int priority;
    private int template_type;
    private byte template_param_length;
    private byte[] template_params;
    private DataBarFormatting data_bar;
    private IconMultiStateFormatting multistate;
    private ColorGradientFormatting color_gradient;
    private byte[] filter_data;

    private CFRule12Record(byte by, byte by2) {
        super(by, by2);
        this.setDefaults();
    }

    private CFRule12Record(byte by, byte by2, Ptg[] ptgArray, Ptg[] ptgArray2, Ptg[] ptgArray3) {
        super(by, by2, ptgArray, ptgArray2);
        this.setDefaults();
        this.formula_scale = Formula.create(ptgArray3);
    }

    private void setDefaults() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2170);
        this.ext_formatting_length = 0;
        this.ext_formatting_data = new byte[4];
        this.formula_scale = Formula.create(Ptg.EMPTY_PTG_ARRAY);
        this.ext_opts = 0;
        this.priority = 0;
        this.template_type = this.getConditionType();
        this.template_param_length = (byte)16;
        this.template_params = new byte[this.template_param_length];
    }

    public static CFRule12Record create(HSSFSheet hSSFSheet, String string) {
        Ptg[] ptgArray = CFRule12Record.parseFormula(string, hSSFSheet);
        return new CFRule12Record(2, 0, ptgArray, null, null);
    }

    public static CFRule12Record create(HSSFSheet hSSFSheet, byte by, String string, String string2) {
        Ptg[] ptgArray = CFRule12Record.parseFormula(string, hSSFSheet);
        Ptg[] ptgArray2 = CFRule12Record.parseFormula(string2, hSSFSheet);
        return new CFRule12Record(1, by, ptgArray, ptgArray2, null);
    }

    public static CFRule12Record create(HSSFSheet hSSFSheet, byte by, String string, String string2, String string3) {
        Ptg[] ptgArray = CFRule12Record.parseFormula(string, hSSFSheet);
        Ptg[] ptgArray2 = CFRule12Record.parseFormula(string2, hSSFSheet);
        Ptg[] ptgArray3 = CFRule12Record.parseFormula(string3, hSSFSheet);
        return new CFRule12Record(1, by, ptgArray, ptgArray2, ptgArray3);
    }

    public static CFRule12Record create(HSSFSheet hSSFSheet, ExtendedColor extendedColor) {
        CFRule12Record cFRule12Record = new CFRule12Record(4, 0);
        DataBarFormatting dataBarFormatting = cFRule12Record.createDataBarFormatting();
        dataBarFormatting.setColor(extendedColor);
        dataBarFormatting.setPercentMin((byte)0);
        dataBarFormatting.setPercentMax((byte)100);
        DataBarThreshold dataBarThreshold = new DataBarThreshold();
        dataBarThreshold.setType(ConditionalFormattingThreshold.RangeType.MIN.id);
        dataBarFormatting.setThresholdMin(dataBarThreshold);
        DataBarThreshold dataBarThreshold2 = new DataBarThreshold();
        dataBarThreshold2.setType(ConditionalFormattingThreshold.RangeType.MAX.id);
        dataBarFormatting.setThresholdMax(dataBarThreshold2);
        return cFRule12Record;
    }

    public static CFRule12Record create(HSSFSheet hSSFSheet, IconMultiStateFormatting.IconSet iconSet) {
        Threshold[] thresholdArray = new Threshold[iconSet.num];
        for (int i = 0; i < thresholdArray.length; ++i) {
            thresholdArray[i] = new IconMultiStateThreshold();
        }
        CFRule12Record cFRule12Record = new CFRule12Record(6, 0);
        IconMultiStateFormatting iconMultiStateFormatting = cFRule12Record.createMultiStateFormatting();
        iconMultiStateFormatting.setIconSet(iconSet);
        iconMultiStateFormatting.setThresholds(thresholdArray);
        return cFRule12Record;
    }

    public static CFRule12Record createColorScale(HSSFSheet hSSFSheet) {
        int n = 3;
        ExtendedColor[] extendedColorArray = new ExtendedColor[n];
        ColorGradientThreshold[] colorGradientThresholdArray = new ColorGradientThreshold[n];
        for (int i = 0; i < colorGradientThresholdArray.length; ++i) {
            colorGradientThresholdArray[i] = new ColorGradientThreshold();
            extendedColorArray[i] = new ExtendedColor();
        }
        CFRule12Record cFRule12Record = new CFRule12Record(3, 0);
        ColorGradientFormatting colorGradientFormatting = cFRule12Record.createColorGradientFormatting();
        colorGradientFormatting.setNumControlPoints(n);
        colorGradientFormatting.setThresholds(colorGradientThresholdArray);
        colorGradientFormatting.setColors(extendedColorArray);
        return cFRule12Record;
    }

    public CFRule12Record(RecordInputStream recordInputStream) {
        int n;
        this.futureHeader = new FtrHeader(recordInputStream);
        this.setConditionType(recordInputStream.readByte());
        this.setComparisonOperation(recordInputStream.readByte());
        int n2 = recordInputStream.readUShort();
        int n3 = recordInputStream.readUShort();
        this.ext_formatting_length = recordInputStream.readInt();
        this.ext_formatting_data = new byte[0];
        if (this.ext_formatting_length == 0) {
            recordInputStream.readUShort();
        } else {
            n = this.readFormatOptions(recordInputStream);
            if (n < this.ext_formatting_length) {
                this.ext_formatting_data = new byte[this.ext_formatting_length - n];
                recordInputStream.readFully(this.ext_formatting_data);
            }
        }
        this.setFormula1(Formula.read(n2, recordInputStream));
        this.setFormula2(Formula.read(n3, recordInputStream));
        n = recordInputStream.readUShort();
        this.formula_scale = Formula.read(n, recordInputStream);
        this.ext_opts = recordInputStream.readByte();
        this.priority = recordInputStream.readUShort();
        this.template_type = recordInputStream.readUShort();
        this.template_param_length = recordInputStream.readByte();
        if (this.template_param_length == 0 || this.template_param_length == 16) {
            this.template_params = new byte[this.template_param_length];
            recordInputStream.readFully(this.template_params);
        } else {
            logger.log(5, new Object[]{"CF Rule v12 template params length should be 0 or 16, found " + this.template_param_length});
            recordInputStream.readRemainder();
        }
        byte by = this.getConditionType();
        if (by == 3) {
            this.color_gradient = new ColorGradientFormatting(recordInputStream);
        } else if (by == 4) {
            this.data_bar = new DataBarFormatting(recordInputStream);
        } else if (by == 5) {
            this.filter_data = recordInputStream.readRemainder();
        } else if (by == 6) {
            this.multistate = new IconMultiStateFormatting(recordInputStream);
        }
    }

    public boolean containsDataBarBlock() {
        return this.data_bar != null;
    }

    public DataBarFormatting getDataBarFormatting() {
        return this.data_bar;
    }

    public DataBarFormatting createDataBarFormatting() {
        if (this.data_bar != null) {
            return this.data_bar;
        }
        this.setConditionType((byte)4);
        this.data_bar = new DataBarFormatting();
        return this.data_bar;
    }

    public boolean containsMultiStateBlock() {
        return this.multistate != null;
    }

    public IconMultiStateFormatting getMultiStateFormatting() {
        return this.multistate;
    }

    public IconMultiStateFormatting createMultiStateFormatting() {
        if (this.multistate != null) {
            return this.multistate;
        }
        this.setConditionType((byte)6);
        this.multistate = new IconMultiStateFormatting();
        return this.multistate;
    }

    public boolean containsColorGradientBlock() {
        return this.color_gradient != null;
    }

    public ColorGradientFormatting getColorGradientFormatting() {
        return this.color_gradient;
    }

    public ColorGradientFormatting createColorGradientFormatting() {
        if (this.color_gradient != null) {
            return this.color_gradient;
        }
        this.setConditionType((byte)3);
        this.color_gradient = new ColorGradientFormatting();
        return this.color_gradient;
    }

    public Ptg[] getParsedExpressionScale() {
        return this.formula_scale.getTokens();
    }

    public void setParsedExpressionScale(Ptg[] ptgArray) {
        this.formula_scale = Formula.create(ptgArray);
    }

    public short getSid() {
        return 2170;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        this.futureHeader.serialize(littleEndianOutput);
        int n = CFRule12Record.getFormulaSize(this.getFormula1());
        int n2 = CFRule12Record.getFormulaSize(this.getFormula2());
        littleEndianOutput.writeByte(this.getConditionType());
        littleEndianOutput.writeByte(this.getComparisonOperation());
        littleEndianOutput.writeShort(n);
        littleEndianOutput.writeShort(n2);
        if (this.ext_formatting_length == 0) {
            littleEndianOutput.writeInt(0);
            littleEndianOutput.writeShort(0);
        } else {
            littleEndianOutput.writeInt(this.ext_formatting_length);
            this.serializeFormattingBlock(littleEndianOutput);
            littleEndianOutput.write(this.ext_formatting_data);
        }
        this.getFormula1().serializeTokens(littleEndianOutput);
        this.getFormula2().serializeTokens(littleEndianOutput);
        littleEndianOutput.writeShort(CFRule12Record.getFormulaSize(this.formula_scale));
        this.formula_scale.serializeTokens(littleEndianOutput);
        littleEndianOutput.writeByte(this.ext_opts);
        littleEndianOutput.writeShort(this.priority);
        littleEndianOutput.writeShort(this.template_type);
        littleEndianOutput.writeByte(this.template_param_length);
        littleEndianOutput.write(this.template_params);
        byte by = this.getConditionType();
        if (by == 3) {
            this.color_gradient.serialize(littleEndianOutput);
        } else if (by == 4) {
            this.data_bar.serialize(littleEndianOutput);
        } else if (by == 5) {
            littleEndianOutput.write(this.filter_data);
        } else if (by == 6) {
            this.multistate.serialize(littleEndianOutput);
        }
    }

    protected int getDataSize() {
        int n = FtrHeader.getDataSize() + 6;
        n = this.ext_formatting_length == 0 ? (n += 6) : (n += 4 + this.getFormattingBlockSize() + this.ext_formatting_data.length);
        n += CFRule12Record.getFormulaSize(this.getFormula1());
        n += CFRule12Record.getFormulaSize(this.getFormula2());
        n += 2 + CFRule12Record.getFormulaSize(this.formula_scale);
        n += 6 + this.template_params.length;
        byte by = this.getConditionType();
        if (by == 3) {
            n += this.color_gradient.getDataLength();
        } else if (by == 4) {
            n += this.data_bar.getDataLength();
        } else if (by == 5) {
            n += this.filter_data.length;
        } else if (by == 6) {
            n += this.multistate.getDataLength();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CFRULE12]\n");
        stringBuffer.append("    .condition_type=").append(this.getConditionType()).append("\n");
        stringBuffer.append("    .dxfn12_length =0x").append(Integer.toHexString(this.ext_formatting_length)).append("\n");
        stringBuffer.append("    .option_flags  =0x").append(Integer.toHexString(this.getOptions())).append("\n");
        if (this.containsFontFormattingBlock()) {
            stringBuffer.append(this._fontFormatting.toString()).append("\n");
        }
        if (this.containsBorderFormattingBlock()) {
            stringBuffer.append(this._borderFormatting.toString()).append("\n");
        }
        if (this.containsPatternFormattingBlock()) {
            stringBuffer.append(this._patternFormatting.toString()).append("\n");
        }
        stringBuffer.append("    .dxfn12_ext=").append(HexDump.toHex(this.ext_formatting_data)).append("\n");
        stringBuffer.append("    .formula_1 =").append(Arrays.toString(this.getFormula1().getTokens())).append("\n");
        stringBuffer.append("    .formula_2 =").append(Arrays.toString(this.getFormula2().getTokens())).append("\n");
        stringBuffer.append("    .formula_S =").append(Arrays.toString(this.formula_scale.getTokens())).append("\n");
        stringBuffer.append("    .ext_opts  =").append(this.ext_opts).append("\n");
        stringBuffer.append("    .priority  =").append(this.priority).append("\n");
        stringBuffer.append("    .template_type  =").append(this.template_type).append("\n");
        stringBuffer.append("    .template_params=").append(HexDump.toHex(this.template_params)).append("\n");
        stringBuffer.append("    .filter_data    =").append(HexDump.toHex(this.filter_data)).append("\n");
        if (this.color_gradient != null) {
            stringBuffer.append(this.color_gradient);
        }
        if (this.multistate != null) {
            stringBuffer.append(this.multistate);
        }
        if (this.data_bar != null) {
            stringBuffer.append(this.data_bar);
        }
        stringBuffer.append("[/CFRULE12]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        CFRule12Record cFRule12Record = new CFRule12Record(this.getConditionType(), this.getComparisonOperation());
        cFRule12Record.futureHeader.setAssociatedRange(this.futureHeader.getAssociatedRange().copy());
        super.copyTo(cFRule12Record);
        cFRule12Record.ext_formatting_length = this.ext_formatting_length;
        cFRule12Record.ext_formatting_data = new byte[this.ext_formatting_length];
        System.arraycopy(this.ext_formatting_data, 0, cFRule12Record.ext_formatting_data, 0, this.ext_formatting_length);
        cFRule12Record.formula_scale = this.formula_scale.copy();
        cFRule12Record.ext_opts = this.ext_opts;
        cFRule12Record.priority = this.priority;
        cFRule12Record.template_type = this.template_type;
        cFRule12Record.template_param_length = this.template_param_length;
        cFRule12Record.template_params = new byte[this.template_param_length];
        System.arraycopy(this.template_params, 0, cFRule12Record.template_params, 0, this.template_param_length);
        if (this.color_gradient != null) {
            cFRule12Record.color_gradient = (ColorGradientFormatting)this.color_gradient.clone();
        }
        if (this.multistate != null) {
            cFRule12Record.multistate = (IconMultiStateFormatting)this.multistate.clone();
        }
        if (this.data_bar != null) {
            cFRule12Record.data_bar = (DataBarFormatting)this.data_bar.clone();
        }
        if (this.filter_data != null) {
            cFRule12Record.filter_data = new byte[this.filter_data.length];
            System.arraycopy(this.filter_data, 0, cFRule12Record.filter_data, 0, this.filter_data.length);
        }
        return cFRule12Record;
    }

    public short getFutureRecordType() {
        return this.futureHeader.getRecordType();
    }

    public FtrHeader getFutureHeader() {
        return this.futureHeader;
    }

    public CellRangeAddress getAssociatedRange() {
        return this.futureHeader.getAssociatedRange();
    }
}

